/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.services.glue.model.SchemaId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSchemaVersionsRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, DeleteSchemaVersionsRequest> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaId").getter(DeleteSchemaVersionsRequest.getter(DeleteSchemaVersionsRequest::schemaId)).setter(DeleteSchemaVersionsRequest.setter(Builder::schemaId)).constructor(SchemaId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()}).build();
    private static final SdkField<String> VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Versions").getter(DeleteSchemaVersionsRequest.getter(DeleteSchemaVersionsRequest::versions)).setter(DeleteSchemaVersionsRequest.setter(Builder::versions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Versions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD, VERSIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteSchemaVersionsRequest.memberNameToFieldInitializer();
    private final SchemaId schemaId;
    private final String versions;

    private DeleteSchemaVersionsRequest(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.versions = builder.versions;
    }

    public final SchemaId schemaId() {
        return this.schemaId;
    }

    public final String versions() {
        return this.versions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.versions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSchemaVersionsRequest)) {
            return false;
        }
        DeleteSchemaVersionsRequest other = (DeleteSchemaVersionsRequest)((Object)obj);
        return Objects.equals(this.schemaId(), other.schemaId()) && Objects.equals(this.versions(), other.versions());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSchemaVersionsRequest").add("SchemaId", (Object)this.schemaId()).add("Versions", (Object)this.versions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaId": {
                return Optional.ofNullable(clazz.cast(this.schemaId()));
            }
            case "Versions": {
                return Optional.ofNullable(clazz.cast(this.versions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("Versions", VERSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSchemaVersionsRequest, T> g) {
        return obj -> g.apply((DeleteSchemaVersionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private SchemaId schemaId;
        private String versions;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSchemaVersionsRequest model) {
            super(model);
            this.schemaId(model.schemaId);
            this.versions(model.versions);
        }

        public final SchemaId.Builder getSchemaId() {
            return this.schemaId != null ? this.schemaId.toBuilder() : null;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        @Override
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final String getVersions() {
            return this.versions;
        }

        public final void setVersions(String versions) {
            this.versions = versions;
        }

        @Override
        public final Builder versions(String versions) {
            this.versions = versions;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteSchemaVersionsRequest build() {
            return new DeleteSchemaVersionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSchemaVersionsRequest> {
        public Builder schemaId(SchemaId var1);

        default public Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return this.schemaId((SchemaId)((SchemaId.Builder)SchemaId.builder().applyMutation(schemaId)).build());
        }

        public Builder versions(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

