/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An object that describes the VPC configuration for a table optimizer.
 * </p>
 * <p>
 * This configuration is necessary to perform optimization on tables that are in a customer VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TableOptimizerVpcConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<TableOptimizerVpcConfiguration.Builder, TableOptimizerVpcConfiguration> {
    private static final SdkField<String> GLUE_CONNECTION_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("glueConnectionName").getter(getter(TableOptimizerVpcConfiguration::glueConnectionName))
            .setter(setter(Builder::glueConnectionName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glueConnectionName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GLUE_CONNECTION_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String glueConnectionName;

    private final Type type;

    private TableOptimizerVpcConfiguration(BuilderImpl builder) {
        this.glueConnectionName = builder.glueConnectionName;
        this.type = builder.type;
    }

    /**
     * <p>
     * The name of the Glue connection used for the VPC for the table optimizer.
     * </p>
     * 
     * @return The name of the Glue connection used for the VPC for the table optimizer.
     */
    public final String glueConnectionName() {
        return glueConnectionName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(glueConnectionName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TableOptimizerVpcConfiguration)) {
            return false;
        }
        TableOptimizerVpcConfiguration other = (TableOptimizerVpcConfiguration) obj;
        return Objects.equals(glueConnectionName(), other.glueConnectionName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TableOptimizerVpcConfiguration").add("GlueConnectionName", glueConnectionName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "glueConnectionName":
            return Optional.ofNullable(clazz.cast(glueConnectionName()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #glueConnectionName()} initialized to the given value.
     *
     * <p>
     * The name of the Glue connection used for the VPC for the table optimizer.
     * </p>
     * 
     * @param glueConnectionName
     *        The name of the Glue connection used for the VPC for the table optimizer.
     */
    public static TableOptimizerVpcConfiguration fromGlueConnectionName(String glueConnectionName) {
        return builder().glueConnectionName(glueConnectionName).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("glueConnectionName", GLUE_CONNECTION_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TableOptimizerVpcConfiguration, T> g) {
        return obj -> g.apply((TableOptimizerVpcConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TableOptimizerVpcConfiguration> {
        /**
         * <p>
         * The name of the Glue connection used for the VPC for the table optimizer.
         * </p>
         * 
         * @param glueConnectionName
         *        The name of the Glue connection used for the VPC for the table optimizer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder glueConnectionName(String glueConnectionName);
    }

    static final class BuilderImpl implements Builder {
        private String glueConnectionName;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(TableOptimizerVpcConfiguration model) {
            glueConnectionName(model.glueConnectionName);
        }

        public final String getGlueConnectionName() {
            return glueConnectionName;
        }

        public final void setGlueConnectionName(String glueConnectionName) {
            Object oldValue = this.glueConnectionName;
            this.glueConnectionName = glueConnectionName;
            handleUnionValueChange(Type.GLUE_CONNECTION_NAME, oldValue, this.glueConnectionName);
        }

        @Override
        public final Builder glueConnectionName(String glueConnectionName) {
            Object oldValue = this.glueConnectionName;
            this.glueConnectionName = glueConnectionName;
            handleUnionValueChange(Type.GLUE_CONNECTION_NAME, oldValue, this.glueConnectionName);
            return this;
        }

        @Override
        public TableOptimizerVpcConfiguration build() {
            return new TableOptimizerVpcConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see TableOptimizerVpcConfiguration#type()
     */
    public enum Type {
        GLUE_CONNECTION_NAME,

        UNKNOWN_TO_SDK_VERSION
    }
}
