/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Statistic Annotation.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StatisticAnnotation implements SdkPojo, Serializable,
        ToCopyableBuilder<StatisticAnnotation.Builder, StatisticAnnotation> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(StatisticAnnotation::profileId)).setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<String> STATISTIC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StatisticId").getter(getter(StatisticAnnotation::statisticId)).setter(setter(Builder::statisticId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticId").build()).build();

    private static final SdkField<Instant> STATISTIC_RECORDED_ON_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("StatisticRecordedOn").getter(getter(StatisticAnnotation::statisticRecordedOn))
            .setter(setter(Builder::statisticRecordedOn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StatisticRecordedOn").build())
            .build();

    private static final SdkField<TimestampedInclusionAnnotation> INCLUSION_ANNOTATION_FIELD = SdkField
            .<TimestampedInclusionAnnotation> builder(MarshallingType.SDK_POJO).memberName("InclusionAnnotation")
            .getter(getter(StatisticAnnotation::inclusionAnnotation)).setter(setter(Builder::inclusionAnnotation))
            .constructor(TimestampedInclusionAnnotation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionAnnotation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD,
            STATISTIC_ID_FIELD, STATISTIC_RECORDED_ON_FIELD, INCLUSION_ANNOTATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String profileId;

    private final String statisticId;

    private final Instant statisticRecordedOn;

    private final TimestampedInclusionAnnotation inclusionAnnotation;

    private StatisticAnnotation(BuilderImpl builder) {
        this.profileId = builder.profileId;
        this.statisticId = builder.statisticId;
        this.statisticRecordedOn = builder.statisticRecordedOn;
        this.inclusionAnnotation = builder.inclusionAnnotation;
    }

    /**
     * <p>
     * The Profile ID.
     * </p>
     * 
     * @return The Profile ID.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * The Statistic ID.
     * </p>
     * 
     * @return The Statistic ID.
     */
    public final String statisticId() {
        return statisticId;
    }

    /**
     * <p>
     * The timestamp when the annotated statistic was recorded.
     * </p>
     * 
     * @return The timestamp when the annotated statistic was recorded.
     */
    public final Instant statisticRecordedOn() {
        return statisticRecordedOn;
    }

    /**
     * <p>
     * The inclusion annotation applied to the statistic.
     * </p>
     * 
     * @return The inclusion annotation applied to the statistic.
     */
    public final TimestampedInclusionAnnotation inclusionAnnotation() {
        return inclusionAnnotation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(statisticId());
        hashCode = 31 * hashCode + Objects.hashCode(statisticRecordedOn());
        hashCode = 31 * hashCode + Objects.hashCode(inclusionAnnotation());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatisticAnnotation)) {
            return false;
        }
        StatisticAnnotation other = (StatisticAnnotation) obj;
        return Objects.equals(profileId(), other.profileId()) && Objects.equals(statisticId(), other.statisticId())
                && Objects.equals(statisticRecordedOn(), other.statisticRecordedOn())
                && Objects.equals(inclusionAnnotation(), other.inclusionAnnotation());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StatisticAnnotation").add("ProfileId", profileId()).add("StatisticId", statisticId())
                .add("StatisticRecordedOn", statisticRecordedOn()).add("InclusionAnnotation", inclusionAnnotation()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "StatisticId":
            return Optional.ofNullable(clazz.cast(statisticId()));
        case "StatisticRecordedOn":
            return Optional.ofNullable(clazz.cast(statisticRecordedOn()));
        case "InclusionAnnotation":
            return Optional.ofNullable(clazz.cast(inclusionAnnotation()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("StatisticId", STATISTIC_ID_FIELD);
        map.put("StatisticRecordedOn", STATISTIC_RECORDED_ON_FIELD);
        map.put("InclusionAnnotation", INCLUSION_ANNOTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StatisticAnnotation, T> g) {
        return obj -> g.apply((StatisticAnnotation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StatisticAnnotation> {
        /**
         * <p>
         * The Profile ID.
         * </p>
         * 
         * @param profileId
         *        The Profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * The Statistic ID.
         * </p>
         * 
         * @param statisticId
         *        The Statistic ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticId(String statisticId);

        /**
         * <p>
         * The timestamp when the annotated statistic was recorded.
         * </p>
         * 
         * @param statisticRecordedOn
         *        The timestamp when the annotated statistic was recorded.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticRecordedOn(Instant statisticRecordedOn);

        /**
         * <p>
         * The inclusion annotation applied to the statistic.
         * </p>
         * 
         * @param inclusionAnnotation
         *        The inclusion annotation applied to the statistic.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inclusionAnnotation(TimestampedInclusionAnnotation inclusionAnnotation);

        /**
         * <p>
         * The inclusion annotation applied to the statistic.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimestampedInclusionAnnotation.Builder}
         * avoiding the need to create one manually via {@link TimestampedInclusionAnnotation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimestampedInclusionAnnotation.Builder#build()} is called
         * immediately and its result is passed to {@link #inclusionAnnotation(TimestampedInclusionAnnotation)}.
         * 
         * @param inclusionAnnotation
         *        a consumer that will call methods on {@link TimestampedInclusionAnnotation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #inclusionAnnotation(TimestampedInclusionAnnotation)
         */
        default Builder inclusionAnnotation(Consumer<TimestampedInclusionAnnotation.Builder> inclusionAnnotation) {
            return inclusionAnnotation(TimestampedInclusionAnnotation.builder().applyMutation(inclusionAnnotation).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String profileId;

        private String statisticId;

        private Instant statisticRecordedOn;

        private TimestampedInclusionAnnotation inclusionAnnotation;

        private BuilderImpl() {
        }

        private BuilderImpl(StatisticAnnotation model) {
            profileId(model.profileId);
            statisticId(model.statisticId);
            statisticRecordedOn(model.statisticRecordedOn);
            inclusionAnnotation(model.inclusionAnnotation);
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getStatisticId() {
            return statisticId;
        }

        public final void setStatisticId(String statisticId) {
            this.statisticId = statisticId;
        }

        @Override
        public final Builder statisticId(String statisticId) {
            this.statisticId = statisticId;
            return this;
        }

        public final Instant getStatisticRecordedOn() {
            return statisticRecordedOn;
        }

        public final void setStatisticRecordedOn(Instant statisticRecordedOn) {
            this.statisticRecordedOn = statisticRecordedOn;
        }

        @Override
        public final Builder statisticRecordedOn(Instant statisticRecordedOn) {
            this.statisticRecordedOn = statisticRecordedOn;
            return this;
        }

        public final TimestampedInclusionAnnotation.Builder getInclusionAnnotation() {
            return inclusionAnnotation != null ? inclusionAnnotation.toBuilder() : null;
        }

        public final void setInclusionAnnotation(TimestampedInclusionAnnotation.BuilderImpl inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation != null ? inclusionAnnotation.build() : null;
        }

        @Override
        public final Builder inclusionAnnotation(TimestampedInclusionAnnotation inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
            return this;
        }

        @Override
        public StatisticAnnotation build() {
            return new StatisticAnnotation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
