/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies a Snowflake target.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SnowflakeTarget implements SdkPojo, Serializable, ToCopyableBuilder<SnowflakeTarget.Builder, SnowflakeTarget> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(SnowflakeTarget::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<SnowflakeNodeData> DATA_FIELD = SdkField.<SnowflakeNodeData> builder(MarshallingType.SDK_POJO)
            .memberName("Data").getter(getter(SnowflakeTarget::data)).setter(setter(Builder::data))
            .constructor(SnowflakeNodeData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(SnowflakeTarget::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATA_FIELD,
            INPUTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final SnowflakeNodeData data;

    private final List<String> inputs;

    private SnowflakeTarget(BuilderImpl builder) {
        this.name = builder.name;
        this.data = builder.data;
        this.inputs = builder.inputs;
    }

    /**
     * <p>
     * The name of the Snowflake target.
     * </p>
     * 
     * @return The name of the Snowflake target.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the data of the Snowflake target node.
     * </p>
     * 
     * @return Specifies the data of the Snowflake target node.
     */
    public final SnowflakeNodeData data() {
        return data;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The nodes that are inputs to the data target.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The nodes that are inputs to the data target.
     */
    public final List<String> inputs() {
        return inputs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SnowflakeTarget)) {
            return false;
        }
        SnowflakeTarget other = (SnowflakeTarget) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(data(), other.data()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SnowflakeTarget").add("Name", name()).add("Data", data())
                .add("Inputs", hasInputs() ? inputs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("Data", DATA_FIELD);
        map.put("Inputs", INPUTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SnowflakeTarget, T> g) {
        return obj -> g.apply((SnowflakeTarget) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SnowflakeTarget> {
        /**
         * <p>
         * The name of the Snowflake target.
         * </p>
         * 
         * @param name
         *        The name of the Snowflake target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the data of the Snowflake target node.
         * </p>
         * 
         * @param data
         *        Specifies the data of the Snowflake target node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(SnowflakeNodeData data);

        /**
         * <p>
         * Specifies the data of the Snowflake target node.
         * </p>
         * This is a convenience method that creates an instance of the {@link SnowflakeNodeData.Builder} avoiding the
         * need to create one manually via {@link SnowflakeNodeData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SnowflakeNodeData.Builder#build()} is called immediately and its
         * result is passed to {@link #data(SnowflakeNodeData)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link SnowflakeNodeData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(SnowflakeNodeData)
         */
        default Builder data(Consumer<SnowflakeNodeData.Builder> data) {
            return data(SnowflakeNodeData.builder().applyMutation(data).build());
        }

        /**
         * <p>
         * The nodes that are inputs to the data target.
         * </p>
         * 
         * @param inputs
         *        The nodes that are inputs to the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The nodes that are inputs to the data target.
         * </p>
         * 
         * @param inputs
         *        The nodes that are inputs to the data target.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private SnowflakeNodeData data;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SnowflakeTarget model) {
            name(model.name);
            data(model.data);
            inputs(model.inputs);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final SnowflakeNodeData.Builder getData() {
            return data != null ? data.toBuilder() : null;
        }

        public final void setData(SnowflakeNodeData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(SnowflakeNodeData data) {
            this.data = data;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        public SnowflakeTarget build() {
            return new SnowflakeTarget(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
