/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class QuerySchemaVersionMetadataRequest extends GlueRequest implements
        ToCopyableBuilder<QuerySchemaVersionMetadataRequest.Builder, QuerySchemaVersionMetadataRequest> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.<SchemaId> builder(MarshallingType.SDK_POJO)
            .memberName("SchemaId").getter(getter(QuerySchemaVersionMetadataRequest::schemaId)).setter(setter(Builder::schemaId))
            .constructor(SchemaId::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()).build();

    private static final SdkField<SchemaVersionNumber> SCHEMA_VERSION_NUMBER_FIELD = SdkField
            .<SchemaVersionNumber> builder(MarshallingType.SDK_POJO).memberName("SchemaVersionNumber")
            .getter(getter(QuerySchemaVersionMetadataRequest::schemaVersionNumber)).setter(setter(Builder::schemaVersionNumber))
            .constructor(SchemaVersionNumber::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionNumber").build())
            .build();

    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("SchemaVersionId").getter(getter(QuerySchemaVersionMetadataRequest::schemaVersionId))
            .setter(setter(Builder::schemaVersionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()).build();

    private static final SdkField<List<MetadataKeyValuePair>> METADATA_LIST_FIELD = SdkField
            .<List<MetadataKeyValuePair>> builder(MarshallingType.LIST)
            .memberName("MetadataList")
            .getter(getter(QuerySchemaVersionMetadataRequest::metadataList))
            .setter(setter(Builder::metadataList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MetadataKeyValuePair> builder(MarshallingType.SDK_POJO)
                                            .constructor(MetadataKeyValuePair::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxResults").getter(getter(QuerySchemaVersionMetadataRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(QuerySchemaVersionMetadataRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD,
            SCHEMA_VERSION_NUMBER_FIELD, SCHEMA_VERSION_ID_FIELD, METADATA_LIST_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final SchemaId schemaId;

    private final SchemaVersionNumber schemaVersionNumber;

    private final String schemaVersionId;

    private final List<MetadataKeyValuePair> metadataList;

    private final Integer maxResults;

    private final String nextToken;

    private QuerySchemaVersionMetadataRequest(BuilderImpl builder) {
        super(builder);
        this.schemaId = builder.schemaId;
        this.schemaVersionNumber = builder.schemaVersionNumber;
        this.schemaVersionId = builder.schemaVersionId;
        this.metadataList = builder.metadataList;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * A wrapper structure that may contain the schema name and Amazon Resource Name (ARN).
     * </p>
     * 
     * @return A wrapper structure that may contain the schema name and Amazon Resource Name (ARN).
     */
    public final SchemaId schemaId() {
        return schemaId;
    }

    /**
     * <p>
     * The version number of the schema.
     * </p>
     * 
     * @return The version number of the schema.
     */
    public final SchemaVersionNumber schemaVersionNumber() {
        return schemaVersionNumber;
    }

    /**
     * <p>
     * The unique version ID of the schema version.
     * </p>
     * 
     * @return The unique version ID of the schema version.
     */
    public final String schemaVersionId() {
        return schemaVersionId;
    }

    /**
     * For responses, this returns true if the service returned a value for the MetadataList property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasMetadataList() {
        return metadataList != null && !(metadataList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Search key-value pairs for metadata, if they are not provided all the metadata information will be fetched.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasMetadataList} method.
     * </p>
     * 
     * @return Search key-value pairs for metadata, if they are not provided all the metadata information will be
     *         fetched.
     */
    public final List<MetadataKeyValuePair> metadataList() {
        return metadataList;
    }

    /**
     * <p>
     * Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per page.
     * </p>
     * 
     * @return Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25
     *         per page.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * A continuation token, if this is a continuation call.
     * </p>
     * 
     * @return A continuation token, if this is a continuation call.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(hasMetadataList() ? metadataList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QuerySchemaVersionMetadataRequest)) {
            return false;
        }
        QuerySchemaVersionMetadataRequest other = (QuerySchemaVersionMetadataRequest) obj;
        return Objects.equals(schemaId(), other.schemaId()) && Objects.equals(schemaVersionNumber(), other.schemaVersionNumber())
                && Objects.equals(schemaVersionId(), other.schemaVersionId()) && hasMetadataList() == other.hasMetadataList()
                && Objects.equals(metadataList(), other.metadataList()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QuerySchemaVersionMetadataRequest").add("SchemaId", schemaId())
                .add("SchemaVersionNumber", schemaVersionNumber()).add("SchemaVersionId", schemaVersionId())
                .add("MetadataList", hasMetadataList() ? metadataList() : null).add("MaxResults", maxResults())
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SchemaId":
            return Optional.ofNullable(clazz.cast(schemaId()));
        case "SchemaVersionNumber":
            return Optional.ofNullable(clazz.cast(schemaVersionNumber()));
        case "SchemaVersionId":
            return Optional.ofNullable(clazz.cast(schemaVersionId()));
        case "MetadataList":
            return Optional.ofNullable(clazz.cast(metadataList()));
        case "MaxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("SchemaId", SCHEMA_ID_FIELD);
        map.put("SchemaVersionNumber", SCHEMA_VERSION_NUMBER_FIELD);
        map.put("SchemaVersionId", SCHEMA_VERSION_ID_FIELD);
        map.put("MetadataList", METADATA_LIST_FIELD);
        map.put("MaxResults", MAX_RESULTS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QuerySchemaVersionMetadataRequest, T> g) {
        return obj -> g.apply((QuerySchemaVersionMetadataRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, QuerySchemaVersionMetadataRequest> {
        /**
         * <p>
         * A wrapper structure that may contain the schema name and Amazon Resource Name (ARN).
         * </p>
         * 
         * @param schemaId
         *        A wrapper structure that may contain the schema name and Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaId(SchemaId schemaId);

        /**
         * <p>
         * A wrapper structure that may contain the schema name and Amazon Resource Name (ARN).
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaId.Builder} avoiding the need to
         * create one manually via {@link SchemaId#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaId.Builder#build()} is called immediately and its result is
         * passed to {@link #schemaId(SchemaId)}.
         * 
         * @param schemaId
         *        a consumer that will call methods on {@link SchemaId.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaId(SchemaId)
         */
        default Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return schemaId(SchemaId.builder().applyMutation(schemaId).build());
        }

        /**
         * <p>
         * The version number of the schema.
         * </p>
         * 
         * @param schemaVersionNumber
         *        The version number of the schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionNumber(SchemaVersionNumber schemaVersionNumber);

        /**
         * <p>
         * The version number of the schema.
         * </p>
         * This is a convenience method that creates an instance of the {@link SchemaVersionNumber.Builder} avoiding the
         * need to create one manually via {@link SchemaVersionNumber#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SchemaVersionNumber.Builder#build()} is called immediately and
         * its result is passed to {@link #schemaVersionNumber(SchemaVersionNumber)}.
         * 
         * @param schemaVersionNumber
         *        a consumer that will call methods on {@link SchemaVersionNumber.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #schemaVersionNumber(SchemaVersionNumber)
         */
        default Builder schemaVersionNumber(Consumer<SchemaVersionNumber.Builder> schemaVersionNumber) {
            return schemaVersionNumber(SchemaVersionNumber.builder().applyMutation(schemaVersionNumber).build());
        }

        /**
         * <p>
         * The unique version ID of the schema version.
         * </p>
         * 
         * @param schemaVersionId
         *        The unique version ID of the schema version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersionId(String schemaVersionId);

        /**
         * <p>
         * Search key-value pairs for metadata, if they are not provided all the metadata information will be fetched.
         * </p>
         * 
         * @param metadataList
         *        Search key-value pairs for metadata, if they are not provided all the metadata information will be
         *        fetched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataList(Collection<MetadataKeyValuePair> metadataList);

        /**
         * <p>
         * Search key-value pairs for metadata, if they are not provided all the metadata information will be fetched.
         * </p>
         * 
         * @param metadataList
         *        Search key-value pairs for metadata, if they are not provided all the metadata information will be
         *        fetched.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadataList(MetadataKeyValuePair... metadataList);

        /**
         * <p>
         * Search key-value pairs for metadata, if they are not provided all the metadata information will be fetched.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.MetadataKeyValuePair.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.glue.model.MetadataKeyValuePair#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.MetadataKeyValuePair.Builder#build()} is called immediately
         * and its result is passed to {@link #metadataList(List<MetadataKeyValuePair>)}.
         * 
         * @param metadataList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.MetadataKeyValuePair.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #metadataList(java.util.Collection<MetadataKeyValuePair>)
         */
        Builder metadataList(Consumer<MetadataKeyValuePair.Builder>... metadataList);

        /**
         * <p>
         * Maximum number of results required per page. If the value is not supplied, this will be defaulted to 25 per
         * page.
         * </p>
         * 
         * @param maxResults
         *        Maximum number of results required per page. If the value is not supplied, this will be defaulted to
         *        25 per page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * A continuation token, if this is a continuation call.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if this is a continuation call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private SchemaId schemaId;

        private SchemaVersionNumber schemaVersionNumber;

        private String schemaVersionId;

        private List<MetadataKeyValuePair> metadataList = DefaultSdkAutoConstructList.getInstance();

        private Integer maxResults;

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(QuerySchemaVersionMetadataRequest model) {
            super(model);
            schemaId(model.schemaId);
            schemaVersionNumber(model.schemaVersionNumber);
            schemaVersionId(model.schemaVersionId);
            metadataList(model.metadataList);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
        }

        public final SchemaId.Builder getSchemaId() {
            return schemaId != null ? schemaId.toBuilder() : null;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        @Override
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final SchemaVersionNumber.Builder getSchemaVersionNumber() {
            return schemaVersionNumber != null ? schemaVersionNumber.toBuilder() : null;
        }

        public final void setSchemaVersionNumber(SchemaVersionNumber.BuilderImpl schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber != null ? schemaVersionNumber.build() : null;
        }

        @Override
        public final Builder schemaVersionNumber(SchemaVersionNumber schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber;
            return this;
        }

        public final String getSchemaVersionId() {
            return schemaVersionId;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final List<MetadataKeyValuePair.Builder> getMetadataList() {
            List<MetadataKeyValuePair.Builder> result = MetadataListCopier.copyToBuilder(this.metadataList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setMetadataList(Collection<MetadataKeyValuePair.BuilderImpl> metadataList) {
            this.metadataList = MetadataListCopier.copyFromBuilder(metadataList);
        }

        @Override
        public final Builder metadataList(Collection<MetadataKeyValuePair> metadataList) {
            this.metadataList = MetadataListCopier.copy(metadataList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataList(MetadataKeyValuePair... metadataList) {
            metadataList(Arrays.asList(metadataList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder metadataList(Consumer<MetadataKeyValuePair.Builder>... metadataList) {
            metadataList(Stream.of(metadataList).map(c -> MetadataKeyValuePair.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public QuerySchemaVersionMetadataRequest build() {
            return new QuerySchemaVersionMetadataRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
