/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class PutDataQualityProfileAnnotationRequest extends GlueRequest implements
        ToCopyableBuilder<PutDataQualityProfileAnnotationRequest.Builder, PutDataQualityProfileAnnotationRequest> {
    private static final SdkField<String> PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProfileId").getter(getter(PutDataQualityProfileAnnotationRequest::profileId))
            .setter(setter(Builder::profileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProfileId").build()).build();

    private static final SdkField<String> INCLUSION_ANNOTATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InclusionAnnotation")
            .getter(getter(PutDataQualityProfileAnnotationRequest::inclusionAnnotationAsString))
            .setter(setter(Builder::inclusionAnnotation))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InclusionAnnotation").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROFILE_ID_FIELD,
            INCLUSION_ANNOTATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String profileId;

    private final String inclusionAnnotation;

    private PutDataQualityProfileAnnotationRequest(BuilderImpl builder) {
        super(builder);
        this.profileId = builder.profileId;
        this.inclusionAnnotation = builder.inclusionAnnotation;
    }

    /**
     * <p>
     * The ID of the data quality monitoring profile to annotate.
     * </p>
     * 
     * @return The ID of the data quality monitoring profile to annotate.
     */
    public final String profileId() {
        return profileId;
    }

    /**
     * <p>
     * The inclusion annotation value to apply to the profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inclusionAnnotation} will return {@link InclusionAnnotationValue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inclusionAnnotationAsString}.
     * </p>
     * 
     * @return The inclusion annotation value to apply to the profile.
     * @see InclusionAnnotationValue
     */
    public final InclusionAnnotationValue inclusionAnnotation() {
        return InclusionAnnotationValue.fromValue(inclusionAnnotation);
    }

    /**
     * <p>
     * The inclusion annotation value to apply to the profile.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #inclusionAnnotation} will return {@link InclusionAnnotationValue#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #inclusionAnnotationAsString}.
     * </p>
     * 
     * @return The inclusion annotation value to apply to the profile.
     * @see InclusionAnnotationValue
     */
    public final String inclusionAnnotationAsString() {
        return inclusionAnnotation;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(profileId());
        hashCode = 31 * hashCode + Objects.hashCode(inclusionAnnotationAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutDataQualityProfileAnnotationRequest)) {
            return false;
        }
        PutDataQualityProfileAnnotationRequest other = (PutDataQualityProfileAnnotationRequest) obj;
        return Objects.equals(profileId(), other.profileId())
                && Objects.equals(inclusionAnnotationAsString(), other.inclusionAnnotationAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PutDataQualityProfileAnnotationRequest").add("ProfileId", profileId())
                .add("InclusionAnnotation", inclusionAnnotationAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProfileId":
            return Optional.ofNullable(clazz.cast(profileId()));
        case "InclusionAnnotation":
            return Optional.ofNullable(clazz.cast(inclusionAnnotationAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ProfileId", PROFILE_ID_FIELD);
        map.put("InclusionAnnotation", INCLUSION_ANNOTATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PutDataQualityProfileAnnotationRequest, T> g) {
        return obj -> g.apply((PutDataQualityProfileAnnotationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, PutDataQualityProfileAnnotationRequest> {
        /**
         * <p>
         * The ID of the data quality monitoring profile to annotate.
         * </p>
         * 
         * @param profileId
         *        The ID of the data quality monitoring profile to annotate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder profileId(String profileId);

        /**
         * <p>
         * The inclusion annotation value to apply to the profile.
         * </p>
         * 
         * @param inclusionAnnotation
         *        The inclusion annotation value to apply to the profile.
         * @see InclusionAnnotationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InclusionAnnotationValue
         */
        Builder inclusionAnnotation(String inclusionAnnotation);

        /**
         * <p>
         * The inclusion annotation value to apply to the profile.
         * </p>
         * 
         * @param inclusionAnnotation
         *        The inclusion annotation value to apply to the profile.
         * @see InclusionAnnotationValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see InclusionAnnotationValue
         */
        Builder inclusionAnnotation(InclusionAnnotationValue inclusionAnnotation);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String profileId;

        private String inclusionAnnotation;

        private BuilderImpl() {
        }

        private BuilderImpl(PutDataQualityProfileAnnotationRequest model) {
            super(model);
            profileId(model.profileId);
            inclusionAnnotation(model.inclusionAnnotation);
        }

        public final String getProfileId() {
            return profileId;
        }

        public final void setProfileId(String profileId) {
            this.profileId = profileId;
        }

        @Override
        public final Builder profileId(String profileId) {
            this.profileId = profileId;
            return this;
        }

        public final String getInclusionAnnotation() {
            return inclusionAnnotation;
        }

        public final void setInclusionAnnotation(String inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
        }

        @Override
        public final Builder inclusionAnnotation(String inclusionAnnotation) {
            this.inclusionAnnotation = inclusionAnnotation;
            return this;
        }

        @Override
        public final Builder inclusionAnnotation(InclusionAnnotationValue inclusionAnnotation) {
            this.inclusionAnnotation(inclusionAnnotation == null ? null : inclusionAnnotation.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PutDataQualityProfileAnnotationRequest build() {
            return new PutDataQualityProfileAnnotationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
