/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A structure that contains orphan file deletion metrics for the optimizer run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OrphanFileDeletionMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<OrphanFileDeletionMetrics.Builder, OrphanFileDeletionMetrics> {
    private static final SdkField<IcebergOrphanFileDeletionMetrics> ICEBERG_METRICS_FIELD = SdkField
            .<IcebergOrphanFileDeletionMetrics> builder(MarshallingType.SDK_POJO).memberName("IcebergMetrics")
            .getter(getter(OrphanFileDeletionMetrics::icebergMetrics)).setter(setter(Builder::icebergMetrics))
            .constructor(IcebergOrphanFileDeletionMetrics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IcebergMetrics").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ICEBERG_METRICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final IcebergOrphanFileDeletionMetrics icebergMetrics;

    private OrphanFileDeletionMetrics(BuilderImpl builder) {
        this.icebergMetrics = builder.icebergMetrics;
    }

    /**
     * <p>
     * A structure containing the Iceberg orphan file deletion metrics for the optimizer run.
     * </p>
     * 
     * @return A structure containing the Iceberg orphan file deletion metrics for the optimizer run.
     */
    public final IcebergOrphanFileDeletionMetrics icebergMetrics() {
        return icebergMetrics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(icebergMetrics());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OrphanFileDeletionMetrics)) {
            return false;
        }
        OrphanFileDeletionMetrics other = (OrphanFileDeletionMetrics) obj;
        return Objects.equals(icebergMetrics(), other.icebergMetrics());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OrphanFileDeletionMetrics").add("IcebergMetrics", icebergMetrics()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "IcebergMetrics":
            return Optional.ofNullable(clazz.cast(icebergMetrics()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("IcebergMetrics", ICEBERG_METRICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<OrphanFileDeletionMetrics, T> g) {
        return obj -> g.apply((OrphanFileDeletionMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OrphanFileDeletionMetrics> {
        /**
         * <p>
         * A structure containing the Iceberg orphan file deletion metrics for the optimizer run.
         * </p>
         * 
         * @param icebergMetrics
         *        A structure containing the Iceberg orphan file deletion metrics for the optimizer run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder icebergMetrics(IcebergOrphanFileDeletionMetrics icebergMetrics);

        /**
         * <p>
         * A structure containing the Iceberg orphan file deletion metrics for the optimizer run.
         * </p>
         * This is a convenience method that creates an instance of the {@link IcebergOrphanFileDeletionMetrics.Builder}
         * avoiding the need to create one manually via {@link IcebergOrphanFileDeletionMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link IcebergOrphanFileDeletionMetrics.Builder#build()} is called
         * immediately and its result is passed to {@link #icebergMetrics(IcebergOrphanFileDeletionMetrics)}.
         * 
         * @param icebergMetrics
         *        a consumer that will call methods on {@link IcebergOrphanFileDeletionMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #icebergMetrics(IcebergOrphanFileDeletionMetrics)
         */
        default Builder icebergMetrics(Consumer<IcebergOrphanFileDeletionMetrics.Builder> icebergMetrics) {
            return icebergMetrics(IcebergOrphanFileDeletionMetrics.builder().applyMutation(icebergMetrics).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private IcebergOrphanFileDeletionMetrics icebergMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(OrphanFileDeletionMetrics model) {
            icebergMetrics(model.icebergMetrics);
        }

        public final IcebergOrphanFileDeletionMetrics.Builder getIcebergMetrics() {
            return icebergMetrics != null ? icebergMetrics.toBuilder() : null;
        }

        public final void setIcebergMetrics(IcebergOrphanFileDeletionMetrics.BuilderImpl icebergMetrics) {
            this.icebergMetrics = icebergMetrics != null ? icebergMetrics.build() : null;
        }

        @Override
        public final Builder icebergMetrics(IcebergOrphanFileDeletionMetrics icebergMetrics) {
            this.icebergMetrics = icebergMetrics;
            return this;
        }

        @Override
        public OrphanFileDeletionMetrics build() {
            return new OrphanFileDeletionMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
