/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCustomEntityTypeResponse extends GlueResponse implements
        ToCopyableBuilder<GetCustomEntityTypeResponse.Builder, GetCustomEntityTypeResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(GetCustomEntityTypeResponse::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> REGEX_STRING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("RegexString").getter(getter(GetCustomEntityTypeResponse::regexString))
            .setter(setter(Builder::regexString))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RegexString").build()).build();

    private static final SdkField<List<String>> CONTEXT_WORDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("ContextWords")
            .getter(getter(GetCustomEntityTypeResponse::contextWords))
            .setter(setter(Builder::contextWords))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ContextWords").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            REGEX_STRING_FIELD, CONTEXT_WORDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String regexString;

    private final List<String> contextWords;

    private GetCustomEntityTypeResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.regexString = builder.regexString;
        this.contextWords = builder.contextWords;
    }

    /**
     * <p>
     * The name of the custom pattern that you retrieved.
     * </p>
     * 
     * @return The name of the custom pattern that you retrieved.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * A regular expression string that is used for detecting sensitive data in a custom pattern.
     * </p>
     * 
     * @return A regular expression string that is used for detecting sensitive data in a custom pattern.
     */
    public final String regexString() {
        return regexString;
    }

    /**
     * For responses, this returns true if the service returned a value for the ContextWords property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasContextWords() {
        return contextWords != null && !(contextWords instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of context words if specified when you created the custom pattern. If none of these context words are
     * found within the vicinity of the regular expression the data will not be detected as sensitive data.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContextWords} method.
     * </p>
     * 
     * @return A list of context words if specified when you created the custom pattern. If none of these context words
     *         are found within the vicinity of the regular expression the data will not be detected as sensitive data.
     */
    public final List<String> contextWords() {
        return contextWords;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(regexString());
        hashCode = 31 * hashCode + Objects.hashCode(hasContextWords() ? contextWords() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCustomEntityTypeResponse)) {
            return false;
        }
        GetCustomEntityTypeResponse other = (GetCustomEntityTypeResponse) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(regexString(), other.regexString())
                && hasContextWords() == other.hasContextWords() && Objects.equals(contextWords(), other.contextWords());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCustomEntityTypeResponse").add("Name", name()).add("RegexString", regexString())
                .add("ContextWords", hasContextWords() ? contextWords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "RegexString":
            return Optional.ofNullable(clazz.cast(regexString()));
        case "ContextWords":
            return Optional.ofNullable(clazz.cast(contextWords()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Name", NAME_FIELD);
        map.put("RegexString", REGEX_STRING_FIELD);
        map.put("ContextWords", CONTEXT_WORDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCustomEntityTypeResponse, T> g) {
        return obj -> g.apply((GetCustomEntityTypeResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCustomEntityTypeResponse> {
        /**
         * <p>
         * The name of the custom pattern that you retrieved.
         * </p>
         * 
         * @param name
         *        The name of the custom pattern that you retrieved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * A regular expression string that is used for detecting sensitive data in a custom pattern.
         * </p>
         * 
         * @param regexString
         *        A regular expression string that is used for detecting sensitive data in a custom pattern.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regexString(String regexString);

        /**
         * <p>
         * A list of context words if specified when you created the custom pattern. If none of these context words are
         * found within the vicinity of the regular expression the data will not be detected as sensitive data.
         * </p>
         * 
         * @param contextWords
         *        A list of context words if specified when you created the custom pattern. If none of these context
         *        words are found within the vicinity of the regular expression the data will not be detected as
         *        sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextWords(Collection<String> contextWords);

        /**
         * <p>
         * A list of context words if specified when you created the custom pattern. If none of these context words are
         * found within the vicinity of the regular expression the data will not be detected as sensitive data.
         * </p>
         * 
         * @param contextWords
         *        A list of context words if specified when you created the custom pattern. If none of these context
         *        words are found within the vicinity of the regular expression the data will not be detected as
         *        sensitive data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contextWords(String... contextWords);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private String name;

        private String regexString;

        private List<String> contextWords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetCustomEntityTypeResponse model) {
            super(model);
            name(model.name);
            regexString(model.regexString);
            contextWords(model.contextWords);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getRegexString() {
            return regexString;
        }

        public final void setRegexString(String regexString) {
            this.regexString = regexString;
        }

        @Override
        public final Builder regexString(String regexString) {
            this.regexString = regexString;
            return this;
        }

        public final Collection<String> getContextWords() {
            if (contextWords instanceof SdkAutoConstructList) {
                return null;
            }
            return contextWords;
        }

        public final void setContextWords(Collection<String> contextWords) {
            this.contextWords = ContextWordsCopier.copy(contextWords);
        }

        @Override
        public final Builder contextWords(Collection<String> contextWords) {
            this.contextWords = ContextWordsCopier.copy(contextWords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder contextWords(String... contextWords) {
            contextWords(Arrays.asList(contextWords));
            return this;
        }

        @Override
        public GetCustomEntityTypeResponse build() {
            return new GetCustomEntityTypeResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
