/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetCrawlerMetricsResponse extends GlueResponse implements
        ToCopyableBuilder<GetCrawlerMetricsResponse.Builder, GetCrawlerMetricsResponse> {
    private static final SdkField<List<CrawlerMetrics>> CRAWLER_METRICS_LIST_FIELD = SdkField
            .<List<CrawlerMetrics>> builder(MarshallingType.LIST)
            .memberName("CrawlerMetricsList")
            .getter(getter(GetCrawlerMetricsResponse::crawlerMetricsList))
            .setter(setter(Builder::crawlerMetricsList))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerMetricsList").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CrawlerMetrics> builder(MarshallingType.SDK_POJO)
                                            .constructor(CrawlerMetrics::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(GetCrawlerMetricsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CRAWLER_METRICS_LIST_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<CrawlerMetrics> crawlerMetricsList;

    private final String nextToken;

    private GetCrawlerMetricsResponse(BuilderImpl builder) {
        super(builder);
        this.crawlerMetricsList = builder.crawlerMetricsList;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the CrawlerMetricsList property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCrawlerMetricsList() {
        return crawlerMetricsList != null && !(crawlerMetricsList instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of metrics for the specified crawler.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCrawlerMetricsList} method.
     * </p>
     * 
     * @return A list of metrics for the specified crawler.
     */
    public final List<CrawlerMetrics> crawlerMetricsList() {
        return crawlerMetricsList;
    }

    /**
     * <p>
     * A continuation token, if the returned list does not contain the last metric available.
     * </p>
     * 
     * @return A continuation token, if the returned list does not contain the last metric available.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasCrawlerMetricsList() ? crawlerMetricsList() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetCrawlerMetricsResponse)) {
            return false;
        }
        GetCrawlerMetricsResponse other = (GetCrawlerMetricsResponse) obj;
        return hasCrawlerMetricsList() == other.hasCrawlerMetricsList()
                && Objects.equals(crawlerMetricsList(), other.crawlerMetricsList())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetCrawlerMetricsResponse")
                .add("CrawlerMetricsList", hasCrawlerMetricsList() ? crawlerMetricsList() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CrawlerMetricsList":
            return Optional.ofNullable(clazz.cast(crawlerMetricsList()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("CrawlerMetricsList", CRAWLER_METRICS_LIST_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetCrawlerMetricsResponse, T> g) {
        return obj -> g.apply((GetCrawlerMetricsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetCrawlerMetricsResponse> {
        /**
         * <p>
         * A list of metrics for the specified crawler.
         * </p>
         * 
         * @param crawlerMetricsList
         *        A list of metrics for the specified crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerMetricsList(Collection<CrawlerMetrics> crawlerMetricsList);

        /**
         * <p>
         * A list of metrics for the specified crawler.
         * </p>
         * 
         * @param crawlerMetricsList
         *        A list of metrics for the specified crawler.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crawlerMetricsList(CrawlerMetrics... crawlerMetricsList);

        /**
         * <p>
         * A list of metrics for the specified crawler.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.CrawlerMetrics.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.CrawlerMetrics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.CrawlerMetrics.Builder#build()} is called immediately and
         * its result is passed to {@link #crawlerMetricsList(List<CrawlerMetrics>)}.
         * 
         * @param crawlerMetricsList
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.CrawlerMetrics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #crawlerMetricsList(java.util.Collection<CrawlerMetrics>)
         */
        Builder crawlerMetricsList(Consumer<CrawlerMetrics.Builder>... crawlerMetricsList);

        /**
         * <p>
         * A continuation token, if the returned list does not contain the last metric available.
         * </p>
         * 
         * @param nextToken
         *        A continuation token, if the returned list does not contain the last metric available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends GlueResponse.BuilderImpl implements Builder {
        private List<CrawlerMetrics> crawlerMetricsList = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetCrawlerMetricsResponse model) {
            super(model);
            crawlerMetricsList(model.crawlerMetricsList);
            nextToken(model.nextToken);
        }

        public final List<CrawlerMetrics.Builder> getCrawlerMetricsList() {
            List<CrawlerMetrics.Builder> result = CrawlerMetricsListCopier.copyToBuilder(this.crawlerMetricsList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCrawlerMetricsList(Collection<CrawlerMetrics.BuilderImpl> crawlerMetricsList) {
            this.crawlerMetricsList = CrawlerMetricsListCopier.copyFromBuilder(crawlerMetricsList);
        }

        @Override
        public final Builder crawlerMetricsList(Collection<CrawlerMetrics> crawlerMetricsList) {
            this.crawlerMetricsList = CrawlerMetricsListCopier.copy(crawlerMetricsList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlerMetricsList(CrawlerMetrics... crawlerMetricsList) {
            crawlerMetricsList(Arrays.asList(crawlerMetricsList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder crawlerMetricsList(Consumer<CrawlerMetrics.Builder>... crawlerMetricsList) {
            crawlerMetricsList(Stream.of(crawlerMetricsList).map(c -> CrawlerMetrics.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetCrawlerMetricsResponse build() {
            return new GetCrawlerMetricsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
