/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The <code>Field</code> object has information about the different properties associated with a field in the
 * connector.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Field implements SdkPojo, Serializable, ToCopyableBuilder<Field.Builder, Field> {
    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldName").getter(getter(Field::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldName").build()).build();

    private static final SdkField<String> LABEL_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Label")
            .getter(getter(Field::label)).setter(setter(Builder::label))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Label").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Field::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> FIELD_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FieldType").getter(getter(Field::fieldTypeAsString)).setter(setter(Builder::fieldType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FieldType").build()).build();

    private static final SdkField<Boolean> IS_PRIMARY_KEY_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsPrimaryKey").getter(getter(Field::isPrimaryKey)).setter(setter(Builder::isPrimaryKey))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPrimaryKey").build()).build();

    private static final SdkField<Boolean> IS_NULLABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsNullable").getter(getter(Field::isNullable)).setter(setter(Builder::isNullable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsNullable").build()).build();

    private static final SdkField<Boolean> IS_RETRIEVABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsRetrievable").getter(getter(Field::isRetrievable)).setter(setter(Builder::isRetrievable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsRetrievable").build()).build();

    private static final SdkField<Boolean> IS_FILTERABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsFilterable").getter(getter(Field::isFilterable)).setter(setter(Builder::isFilterable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsFilterable").build()).build();

    private static final SdkField<Boolean> IS_PARTITIONABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsPartitionable").getter(getter(Field::isPartitionable)).setter(setter(Builder::isPartitionable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsPartitionable").build()).build();

    private static final SdkField<Boolean> IS_CREATEABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsCreateable").getter(getter(Field::isCreateable)).setter(setter(Builder::isCreateable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsCreateable").build()).build();

    private static final SdkField<Boolean> IS_UPDATEABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsUpdateable").getter(getter(Field::isUpdateable)).setter(setter(Builder::isUpdateable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsUpdateable").build()).build();

    private static final SdkField<Boolean> IS_UPSERTABLE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsUpsertable").getter(getter(Field::isUpsertable)).setter(setter(Builder::isUpsertable))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsUpsertable").build()).build();

    private static final SdkField<Boolean> IS_DEFAULT_ON_CREATE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsDefaultOnCreate").getter(getter(Field::isDefaultOnCreate)).setter(setter(Builder::isDefaultOnCreate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsDefaultOnCreate").build()).build();

    private static final SdkField<List<String>> SUPPORTED_VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedValues")
            .getter(getter(Field::supportedValues))
            .setter(setter(Builder::supportedValues))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedValues").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> SUPPORTED_FILTER_OPERATORS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("SupportedFilterOperators")
            .getter(getter(Field::supportedFilterOperatorsAsStrings))
            .setter(setter(Builder::supportedFilterOperatorsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedFilterOperators").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> PARENT_FIELD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ParentField").getter(getter(Field::parentField)).setter(setter(Builder::parentField))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParentField").build()).build();

    private static final SdkField<String> NATIVE_DATA_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NativeDataType").getter(getter(Field::nativeDataType)).setter(setter(Builder::nativeDataType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NativeDataType").build()).build();

    private static final SdkField<Map<String, String>> CUSTOM_PROPERTIES_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("CustomProperties")
            .getter(getter(Field::customProperties))
            .setter(setter(Builder::customProperties))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CustomProperties").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FIELD_NAME_FIELD, LABEL_FIELD,
            DESCRIPTION_FIELD, FIELD_TYPE_FIELD, IS_PRIMARY_KEY_FIELD, IS_NULLABLE_FIELD, IS_RETRIEVABLE_FIELD,
            IS_FILTERABLE_FIELD, IS_PARTITIONABLE_FIELD, IS_CREATEABLE_FIELD, IS_UPDATEABLE_FIELD, IS_UPSERTABLE_FIELD,
            IS_DEFAULT_ON_CREATE_FIELD, SUPPORTED_VALUES_FIELD, SUPPORTED_FILTER_OPERATORS_FIELD, PARENT_FIELD_FIELD,
            NATIVE_DATA_TYPE_FIELD, CUSTOM_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String fieldName;

    private final String label;

    private final String description;

    private final String fieldType;

    private final Boolean isPrimaryKey;

    private final Boolean isNullable;

    private final Boolean isRetrievable;

    private final Boolean isFilterable;

    private final Boolean isPartitionable;

    private final Boolean isCreateable;

    private final Boolean isUpdateable;

    private final Boolean isUpsertable;

    private final Boolean isDefaultOnCreate;

    private final List<String> supportedValues;

    private final List<String> supportedFilterOperators;

    private final String parentField;

    private final String nativeDataType;

    private final Map<String, String> customProperties;

    private Field(BuilderImpl builder) {
        this.fieldName = builder.fieldName;
        this.label = builder.label;
        this.description = builder.description;
        this.fieldType = builder.fieldType;
        this.isPrimaryKey = builder.isPrimaryKey;
        this.isNullable = builder.isNullable;
        this.isRetrievable = builder.isRetrievable;
        this.isFilterable = builder.isFilterable;
        this.isPartitionable = builder.isPartitionable;
        this.isCreateable = builder.isCreateable;
        this.isUpdateable = builder.isUpdateable;
        this.isUpsertable = builder.isUpsertable;
        this.isDefaultOnCreate = builder.isDefaultOnCreate;
        this.supportedValues = builder.supportedValues;
        this.supportedFilterOperators = builder.supportedFilterOperators;
        this.parentField = builder.parentField;
        this.nativeDataType = builder.nativeDataType;
        this.customProperties = builder.customProperties;
    }

    /**
     * <p>
     * A unique identifier for the field.
     * </p>
     * 
     * @return A unique identifier for the field.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * A readable label used for the field.
     * </p>
     * 
     * @return A readable label used for the field.
     */
    public final String label() {
        return label;
    }

    /**
     * <p>
     * A description of the field.
     * </p>
     * 
     * @return A description of the field.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The type of data in the field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldType} will
     * return {@link FieldDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldTypeAsString}.
     * </p>
     * 
     * @return The type of data in the field.
     * @see FieldDataType
     */
    public final FieldDataType fieldType() {
        return FieldDataType.fromValue(fieldType);
    }

    /**
     * <p>
     * The type of data in the field.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fieldType} will
     * return {@link FieldDataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fieldTypeAsString}.
     * </p>
     * 
     * @return The type of data in the field.
     * @see FieldDataType
     */
    public final String fieldTypeAsString() {
        return fieldType;
    }

    /**
     * <p>
     * Indicates whether this field can used as a primary key for the given entity.
     * </p>
     * 
     * @return Indicates whether this field can used as a primary key for the given entity.
     */
    public final Boolean isPrimaryKey() {
        return isPrimaryKey;
    }

    /**
     * <p>
     * Indicates whether this field can be nullable or not.
     * </p>
     * 
     * @return Indicates whether this field can be nullable or not.
     */
    public final Boolean isNullable() {
        return isNullable;
    }

    /**
     * <p>
     * Indicates whether this field can be added in Select clause of SQL query or whether it is retrievable or not.
     * </p>
     * 
     * @return Indicates whether this field can be added in Select clause of SQL query or whether it is retrievable or
     *         not.
     */
    public final Boolean isRetrievable() {
        return isRetrievable;
    }

    /**
     * <p>
     * Indicates whether this field can used in a filter clause (<code>WHERE</code> clause) of a SQL statement when
     * querying data.
     * </p>
     * 
     * @return Indicates whether this field can used in a filter clause (<code>WHERE</code> clause) of a SQL statement
     *         when querying data.
     */
    public final Boolean isFilterable() {
        return isFilterable;
    }

    /**
     * <p>
     * Indicates whether a given field can be used in partitioning the query made to SaaS.
     * </p>
     * 
     * @return Indicates whether a given field can be used in partitioning the query made to SaaS.
     */
    public final Boolean isPartitionable() {
        return isPartitionable;
    }

    /**
     * <p>
     * Indicates whether this field can be created as part of a destination write.
     * </p>
     * 
     * @return Indicates whether this field can be created as part of a destination write.
     */
    public final Boolean isCreateable() {
        return isCreateable;
    }

    /**
     * <p>
     * Indicates whether this field can be updated as part of a destination write.
     * </p>
     * 
     * @return Indicates whether this field can be updated as part of a destination write.
     */
    public final Boolean isUpdateable() {
        return isUpdateable;
    }

    /**
     * <p>
     * Indicates whether this field can be upserted as part of a destination write.
     * </p>
     * 
     * @return Indicates whether this field can be upserted as part of a destination write.
     */
    public final Boolean isUpsertable() {
        return isUpsertable;
    }

    /**
     * <p>
     * Indicates whether this field is populated automatically when the object is created, such as a created at
     * timestamp.
     * </p>
     * 
     * @return Indicates whether this field is populated automatically when the object is created, such as a created at
     *         timestamp.
     */
    public final Boolean isDefaultOnCreate() {
        return isDefaultOnCreate;
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedValues property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSupportedValues() {
        return supportedValues != null && !(supportedValues instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of supported values for the field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedValues} method.
     * </p>
     * 
     * @return A list of supported values for the field.
     */
    public final List<String> supportedValues() {
        return supportedValues;
    }

    /**
     * <p>
     * Indicates the support filter operators for this field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedFilterOperators} method.
     * </p>
     * 
     * @return Indicates the support filter operators for this field.
     */
    public final List<FieldFilterOperator> supportedFilterOperators() {
        return FieldFilterOperatorsListCopier.copyStringToEnum(supportedFilterOperators);
    }

    /**
     * For responses, this returns true if the service returned a value for the SupportedFilterOperators property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasSupportedFilterOperators() {
        return supportedFilterOperators != null && !(supportedFilterOperators instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Indicates the support filter operators for this field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSupportedFilterOperators} method.
     * </p>
     * 
     * @return Indicates the support filter operators for this field.
     */
    public final List<String> supportedFilterOperatorsAsStrings() {
        return supportedFilterOperators;
    }

    /**
     * <p>
     * A parent field name for a nested field.
     * </p>
     * 
     * @return A parent field name for a nested field.
     */
    public final String parentField() {
        return parentField;
    }

    /**
     * <p>
     * The data type returned by the SaaS API, such as “picklist” or “textarea” from Salesforce.
     * </p>
     * 
     * @return The data type returned by the SaaS API, such as “picklist” or “textarea” from Salesforce.
     */
    public final String nativeDataType() {
        return nativeDataType;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomProperties property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomProperties() {
        return customProperties != null && !(customProperties instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Optional map of keys which may be returned.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomProperties} method.
     * </p>
     * 
     * @return Optional map of keys which may be returned.
     */
    public final Map<String, String> customProperties() {
        return customProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(label());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(fieldTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(isPrimaryKey());
        hashCode = 31 * hashCode + Objects.hashCode(isNullable());
        hashCode = 31 * hashCode + Objects.hashCode(isRetrievable());
        hashCode = 31 * hashCode + Objects.hashCode(isFilterable());
        hashCode = 31 * hashCode + Objects.hashCode(isPartitionable());
        hashCode = 31 * hashCode + Objects.hashCode(isCreateable());
        hashCode = 31 * hashCode + Objects.hashCode(isUpdateable());
        hashCode = 31 * hashCode + Objects.hashCode(isUpsertable());
        hashCode = 31 * hashCode + Objects.hashCode(isDefaultOnCreate());
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedValues() ? supportedValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasSupportedFilterOperators() ? supportedFilterOperatorsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(parentField());
        hashCode = 31 * hashCode + Objects.hashCode(nativeDataType());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomProperties() ? customProperties() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Field)) {
            return false;
        }
        Field other = (Field) obj;
        return Objects.equals(fieldName(), other.fieldName()) && Objects.equals(label(), other.label())
                && Objects.equals(description(), other.description())
                && Objects.equals(fieldTypeAsString(), other.fieldTypeAsString())
                && Objects.equals(isPrimaryKey(), other.isPrimaryKey()) && Objects.equals(isNullable(), other.isNullable())
                && Objects.equals(isRetrievable(), other.isRetrievable()) && Objects.equals(isFilterable(), other.isFilterable())
                && Objects.equals(isPartitionable(), other.isPartitionable())
                && Objects.equals(isCreateable(), other.isCreateable()) && Objects.equals(isUpdateable(), other.isUpdateable())
                && Objects.equals(isUpsertable(), other.isUpsertable())
                && Objects.equals(isDefaultOnCreate(), other.isDefaultOnCreate())
                && hasSupportedValues() == other.hasSupportedValues()
                && Objects.equals(supportedValues(), other.supportedValues())
                && hasSupportedFilterOperators() == other.hasSupportedFilterOperators()
                && Objects.equals(supportedFilterOperatorsAsStrings(), other.supportedFilterOperatorsAsStrings())
                && Objects.equals(parentField(), other.parentField()) && Objects.equals(nativeDataType(), other.nativeDataType())
                && hasCustomProperties() == other.hasCustomProperties()
                && Objects.equals(customProperties(), other.customProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Field").add("FieldName", fieldName()).add("Label", label()).add("Description", description())
                .add("FieldType", fieldTypeAsString()).add("IsPrimaryKey", isPrimaryKey()).add("IsNullable", isNullable())
                .add("IsRetrievable", isRetrievable()).add("IsFilterable", isFilterable())
                .add("IsPartitionable", isPartitionable()).add("IsCreateable", isCreateable())
                .add("IsUpdateable", isUpdateable()).add("IsUpsertable", isUpsertable())
                .add("IsDefaultOnCreate", isDefaultOnCreate())
                .add("SupportedValues", hasSupportedValues() ? supportedValues() : null)
                .add("SupportedFilterOperators", hasSupportedFilterOperators() ? supportedFilterOperatorsAsStrings() : null)
                .add("ParentField", parentField()).add("NativeDataType", nativeDataType())
                .add("CustomProperties", hasCustomProperties() ? customProperties() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "FieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "Label":
            return Optional.ofNullable(clazz.cast(label()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FieldType":
            return Optional.ofNullable(clazz.cast(fieldTypeAsString()));
        case "IsPrimaryKey":
            return Optional.ofNullable(clazz.cast(isPrimaryKey()));
        case "IsNullable":
            return Optional.ofNullable(clazz.cast(isNullable()));
        case "IsRetrievable":
            return Optional.ofNullable(clazz.cast(isRetrievable()));
        case "IsFilterable":
            return Optional.ofNullable(clazz.cast(isFilterable()));
        case "IsPartitionable":
            return Optional.ofNullable(clazz.cast(isPartitionable()));
        case "IsCreateable":
            return Optional.ofNullable(clazz.cast(isCreateable()));
        case "IsUpdateable":
            return Optional.ofNullable(clazz.cast(isUpdateable()));
        case "IsUpsertable":
            return Optional.ofNullable(clazz.cast(isUpsertable()));
        case "IsDefaultOnCreate":
            return Optional.ofNullable(clazz.cast(isDefaultOnCreate()));
        case "SupportedValues":
            return Optional.ofNullable(clazz.cast(supportedValues()));
        case "SupportedFilterOperators":
            return Optional.ofNullable(clazz.cast(supportedFilterOperatorsAsStrings()));
        case "ParentField":
            return Optional.ofNullable(clazz.cast(parentField()));
        case "NativeDataType":
            return Optional.ofNullable(clazz.cast(nativeDataType()));
        case "CustomProperties":
            return Optional.ofNullable(clazz.cast(customProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("FieldName", FIELD_NAME_FIELD);
        map.put("Label", LABEL_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("FieldType", FIELD_TYPE_FIELD);
        map.put("IsPrimaryKey", IS_PRIMARY_KEY_FIELD);
        map.put("IsNullable", IS_NULLABLE_FIELD);
        map.put("IsRetrievable", IS_RETRIEVABLE_FIELD);
        map.put("IsFilterable", IS_FILTERABLE_FIELD);
        map.put("IsPartitionable", IS_PARTITIONABLE_FIELD);
        map.put("IsCreateable", IS_CREATEABLE_FIELD);
        map.put("IsUpdateable", IS_UPDATEABLE_FIELD);
        map.put("IsUpsertable", IS_UPSERTABLE_FIELD);
        map.put("IsDefaultOnCreate", IS_DEFAULT_ON_CREATE_FIELD);
        map.put("SupportedValues", SUPPORTED_VALUES_FIELD);
        map.put("SupportedFilterOperators", SUPPORTED_FILTER_OPERATORS_FIELD);
        map.put("ParentField", PARENT_FIELD_FIELD);
        map.put("NativeDataType", NATIVE_DATA_TYPE_FIELD);
        map.put("CustomProperties", CUSTOM_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Field, T> g) {
        return obj -> g.apply((Field) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Field> {
        /**
         * <p>
         * A unique identifier for the field.
         * </p>
         * 
         * @param fieldName
         *        A unique identifier for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * A readable label used for the field.
         * </p>
         * 
         * @param label
         *        A readable label used for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder label(String label);

        /**
         * <p>
         * A description of the field.
         * </p>
         * 
         * @param description
         *        A description of the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The type of data in the field.
         * </p>
         * 
         * @param fieldType
         *        The type of data in the field.
         * @see FieldDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldDataType
         */
        Builder fieldType(String fieldType);

        /**
         * <p>
         * The type of data in the field.
         * </p>
         * 
         * @param fieldType
         *        The type of data in the field.
         * @see FieldDataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FieldDataType
         */
        Builder fieldType(FieldDataType fieldType);

        /**
         * <p>
         * Indicates whether this field can used as a primary key for the given entity.
         * </p>
         * 
         * @param isPrimaryKey
         *        Indicates whether this field can used as a primary key for the given entity.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPrimaryKey(Boolean isPrimaryKey);

        /**
         * <p>
         * Indicates whether this field can be nullable or not.
         * </p>
         * 
         * @param isNullable
         *        Indicates whether this field can be nullable or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isNullable(Boolean isNullable);

        /**
         * <p>
         * Indicates whether this field can be added in Select clause of SQL query or whether it is retrievable or not.
         * </p>
         * 
         * @param isRetrievable
         *        Indicates whether this field can be added in Select clause of SQL query or whether it is retrievable
         *        or not.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isRetrievable(Boolean isRetrievable);

        /**
         * <p>
         * Indicates whether this field can used in a filter clause (<code>WHERE</code> clause) of a SQL statement when
         * querying data.
         * </p>
         * 
         * @param isFilterable
         *        Indicates whether this field can used in a filter clause (<code>WHERE</code> clause) of a SQL
         *        statement when querying data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isFilterable(Boolean isFilterable);

        /**
         * <p>
         * Indicates whether a given field can be used in partitioning the query made to SaaS.
         * </p>
         * 
         * @param isPartitionable
         *        Indicates whether a given field can be used in partitioning the query made to SaaS.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isPartitionable(Boolean isPartitionable);

        /**
         * <p>
         * Indicates whether this field can be created as part of a destination write.
         * </p>
         * 
         * @param isCreateable
         *        Indicates whether this field can be created as part of a destination write.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isCreateable(Boolean isCreateable);

        /**
         * <p>
         * Indicates whether this field can be updated as part of a destination write.
         * </p>
         * 
         * @param isUpdateable
         *        Indicates whether this field can be updated as part of a destination write.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isUpdateable(Boolean isUpdateable);

        /**
         * <p>
         * Indicates whether this field can be upserted as part of a destination write.
         * </p>
         * 
         * @param isUpsertable
         *        Indicates whether this field can be upserted as part of a destination write.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isUpsertable(Boolean isUpsertable);

        /**
         * <p>
         * Indicates whether this field is populated automatically when the object is created, such as a created at
         * timestamp.
         * </p>
         * 
         * @param isDefaultOnCreate
         *        Indicates whether this field is populated automatically when the object is created, such as a created
         *        at timestamp.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isDefaultOnCreate(Boolean isDefaultOnCreate);

        /**
         * <p>
         * A list of supported values for the field.
         * </p>
         * 
         * @param supportedValues
         *        A list of supported values for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedValues(Collection<String> supportedValues);

        /**
         * <p>
         * A list of supported values for the field.
         * </p>
         * 
         * @param supportedValues
         *        A list of supported values for the field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedValues(String... supportedValues);

        /**
         * <p>
         * Indicates the support filter operators for this field.
         * </p>
         * 
         * @param supportedFilterOperators
         *        Indicates the support filter operators for this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedFilterOperatorsWithStrings(Collection<String> supportedFilterOperators);

        /**
         * <p>
         * Indicates the support filter operators for this field.
         * </p>
         * 
         * @param supportedFilterOperators
         *        Indicates the support filter operators for this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedFilterOperatorsWithStrings(String... supportedFilterOperators);

        /**
         * <p>
         * Indicates the support filter operators for this field.
         * </p>
         * 
         * @param supportedFilterOperators
         *        Indicates the support filter operators for this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedFilterOperators(Collection<FieldFilterOperator> supportedFilterOperators);

        /**
         * <p>
         * Indicates the support filter operators for this field.
         * </p>
         * 
         * @param supportedFilterOperators
         *        Indicates the support filter operators for this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder supportedFilterOperators(FieldFilterOperator... supportedFilterOperators);

        /**
         * <p>
         * A parent field name for a nested field.
         * </p>
         * 
         * @param parentField
         *        A parent field name for a nested field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parentField(String parentField);

        /**
         * <p>
         * The data type returned by the SaaS API, such as “picklist” or “textarea” from Salesforce.
         * </p>
         * 
         * @param nativeDataType
         *        The data type returned by the SaaS API, such as “picklist” or “textarea” from Salesforce.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nativeDataType(String nativeDataType);

        /**
         * <p>
         * Optional map of keys which may be returned.
         * </p>
         * 
         * @param customProperties
         *        Optional map of keys which may be returned.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customProperties(Map<String, String> customProperties);
    }

    static final class BuilderImpl implements Builder {
        private String fieldName;

        private String label;

        private String description;

        private String fieldType;

        private Boolean isPrimaryKey;

        private Boolean isNullable;

        private Boolean isRetrievable;

        private Boolean isFilterable;

        private Boolean isPartitionable;

        private Boolean isCreateable;

        private Boolean isUpdateable;

        private Boolean isUpsertable;

        private Boolean isDefaultOnCreate;

        private List<String> supportedValues = DefaultSdkAutoConstructList.getInstance();

        private List<String> supportedFilterOperators = DefaultSdkAutoConstructList.getInstance();

        private String parentField;

        private String nativeDataType;

        private Map<String, String> customProperties = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Field model) {
            fieldName(model.fieldName);
            label(model.label);
            description(model.description);
            fieldType(model.fieldType);
            isPrimaryKey(model.isPrimaryKey);
            isNullable(model.isNullable);
            isRetrievable(model.isRetrievable);
            isFilterable(model.isFilterable);
            isPartitionable(model.isPartitionable);
            isCreateable(model.isCreateable);
            isUpdateable(model.isUpdateable);
            isUpsertable(model.isUpsertable);
            isDefaultOnCreate(model.isDefaultOnCreate);
            supportedValues(model.supportedValues);
            supportedFilterOperatorsWithStrings(model.supportedFilterOperators);
            parentField(model.parentField);
            nativeDataType(model.nativeDataType);
            customProperties(model.customProperties);
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getLabel() {
            return label;
        }

        public final void setLabel(String label) {
            this.label = label;
        }

        @Override
        public final Builder label(String label) {
            this.label = label;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFieldType() {
            return fieldType;
        }

        public final void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public final Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        @Override
        public final Builder fieldType(FieldDataType fieldType) {
            this.fieldType(fieldType == null ? null : fieldType.toString());
            return this;
        }

        public final Boolean getIsPrimaryKey() {
            return isPrimaryKey;
        }

        public final void setIsPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
        }

        @Override
        public final Builder isPrimaryKey(Boolean isPrimaryKey) {
            this.isPrimaryKey = isPrimaryKey;
            return this;
        }

        public final Boolean getIsNullable() {
            return isNullable;
        }

        public final void setIsNullable(Boolean isNullable) {
            this.isNullable = isNullable;
        }

        @Override
        public final Builder isNullable(Boolean isNullable) {
            this.isNullable = isNullable;
            return this;
        }

        public final Boolean getIsRetrievable() {
            return isRetrievable;
        }

        public final void setIsRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
        }

        @Override
        public final Builder isRetrievable(Boolean isRetrievable) {
            this.isRetrievable = isRetrievable;
            return this;
        }

        public final Boolean getIsFilterable() {
            return isFilterable;
        }

        public final void setIsFilterable(Boolean isFilterable) {
            this.isFilterable = isFilterable;
        }

        @Override
        public final Builder isFilterable(Boolean isFilterable) {
            this.isFilterable = isFilterable;
            return this;
        }

        public final Boolean getIsPartitionable() {
            return isPartitionable;
        }

        public final void setIsPartitionable(Boolean isPartitionable) {
            this.isPartitionable = isPartitionable;
        }

        @Override
        public final Builder isPartitionable(Boolean isPartitionable) {
            this.isPartitionable = isPartitionable;
            return this;
        }

        public final Boolean getIsCreateable() {
            return isCreateable;
        }

        public final void setIsCreateable(Boolean isCreateable) {
            this.isCreateable = isCreateable;
        }

        @Override
        public final Builder isCreateable(Boolean isCreateable) {
            this.isCreateable = isCreateable;
            return this;
        }

        public final Boolean getIsUpdateable() {
            return isUpdateable;
        }

        public final void setIsUpdateable(Boolean isUpdateable) {
            this.isUpdateable = isUpdateable;
        }

        @Override
        public final Builder isUpdateable(Boolean isUpdateable) {
            this.isUpdateable = isUpdateable;
            return this;
        }

        public final Boolean getIsUpsertable() {
            return isUpsertable;
        }

        public final void setIsUpsertable(Boolean isUpsertable) {
            this.isUpsertable = isUpsertable;
        }

        @Override
        public final Builder isUpsertable(Boolean isUpsertable) {
            this.isUpsertable = isUpsertable;
            return this;
        }

        public final Boolean getIsDefaultOnCreate() {
            return isDefaultOnCreate;
        }

        public final void setIsDefaultOnCreate(Boolean isDefaultOnCreate) {
            this.isDefaultOnCreate = isDefaultOnCreate;
        }

        @Override
        public final Builder isDefaultOnCreate(Boolean isDefaultOnCreate) {
            this.isDefaultOnCreate = isDefaultOnCreate;
            return this;
        }

        public final Collection<String> getSupportedValues() {
            if (supportedValues instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedValues;
        }

        public final void setSupportedValues(Collection<String> supportedValues) {
            this.supportedValues = ListOfStringCopier.copy(supportedValues);
        }

        @Override
        public final Builder supportedValues(Collection<String> supportedValues) {
            this.supportedValues = ListOfStringCopier.copy(supportedValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedValues(String... supportedValues) {
            supportedValues(Arrays.asList(supportedValues));
            return this;
        }

        public final Collection<String> getSupportedFilterOperators() {
            if (supportedFilterOperators instanceof SdkAutoConstructList) {
                return null;
            }
            return supportedFilterOperators;
        }

        public final void setSupportedFilterOperators(Collection<String> supportedFilterOperators) {
            this.supportedFilterOperators = FieldFilterOperatorsListCopier.copy(supportedFilterOperators);
        }

        @Override
        public final Builder supportedFilterOperatorsWithStrings(Collection<String> supportedFilterOperators) {
            this.supportedFilterOperators = FieldFilterOperatorsListCopier.copy(supportedFilterOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFilterOperatorsWithStrings(String... supportedFilterOperators) {
            supportedFilterOperatorsWithStrings(Arrays.asList(supportedFilterOperators));
            return this;
        }

        @Override
        public final Builder supportedFilterOperators(Collection<FieldFilterOperator> supportedFilterOperators) {
            this.supportedFilterOperators = FieldFilterOperatorsListCopier.copyEnumToString(supportedFilterOperators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedFilterOperators(FieldFilterOperator... supportedFilterOperators) {
            supportedFilterOperators(Arrays.asList(supportedFilterOperators));
            return this;
        }

        public final String getParentField() {
            return parentField;
        }

        public final void setParentField(String parentField) {
            this.parentField = parentField;
        }

        @Override
        public final Builder parentField(String parentField) {
            this.parentField = parentField;
            return this;
        }

        public final String getNativeDataType() {
            return nativeDataType;
        }

        public final void setNativeDataType(String nativeDataType) {
            this.nativeDataType = nativeDataType;
        }

        @Override
        public final Builder nativeDataType(String nativeDataType) {
            this.nativeDataType = nativeDataType;
            return this;
        }

        public final Map<String, String> getCustomProperties() {
            if (customProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return customProperties;
        }

        public final void setCustomProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
        }

        @Override
        public final Builder customProperties(Map<String, String> customProperties) {
            this.customProperties = CustomPropertiesCopier.copy(customProperties);
            return this;
        }

        @Override
        public Field build() {
            return new Field(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
