/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A policy that specifies update behavior for the crawler.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectSchemaChangePolicy implements SdkPojo, Serializable,
        ToCopyableBuilder<DirectSchemaChangePolicy.Builder, DirectSchemaChangePolicy> {
    private static final SdkField<Boolean> ENABLE_UPDATE_CATALOG_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableUpdateCatalog").getter(getter(DirectSchemaChangePolicy::enableUpdateCatalog))
            .setter(setter(Builder::enableUpdateCatalog))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableUpdateCatalog").build())
            .build();

    private static final SdkField<String> UPDATE_BEHAVIOR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("UpdateBehavior").getter(getter(DirectSchemaChangePolicy::updateBehaviorAsString))
            .setter(setter(Builder::updateBehavior))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UpdateBehavior").build()).build();

    private static final SdkField<String> TABLE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Table")
            .getter(getter(DirectSchemaChangePolicy::table)).setter(setter(Builder::table))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Table").build()).build();

    private static final SdkField<String> DATABASE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Database").getter(getter(DirectSchemaChangePolicy::database)).setter(setter(Builder::database))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Database").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLE_UPDATE_CATALOG_FIELD,
            UPDATE_BEHAVIOR_FIELD, TABLE_FIELD, DATABASE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean enableUpdateCatalog;

    private final String updateBehavior;

    private final String table;

    private final String database;

    private DirectSchemaChangePolicy(BuilderImpl builder) {
        this.enableUpdateCatalog = builder.enableUpdateCatalog;
        this.updateBehavior = builder.updateBehavior;
        this.table = builder.table;
        this.database = builder.database;
    }

    /**
     * <p>
     * Whether to use the specified update behavior when the crawler finds a changed schema.
     * </p>
     * 
     * @return Whether to use the specified update behavior when the crawler finds a changed schema.
     */
    public final Boolean enableUpdateCatalog() {
        return enableUpdateCatalog;
    }

    /**
     * <p>
     * The update behavior when the crawler finds a changed schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateBehavior}
     * will return {@link UpdateCatalogBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateBehaviorAsString}.
     * </p>
     * 
     * @return The update behavior when the crawler finds a changed schema.
     * @see UpdateCatalogBehavior
     */
    public final UpdateCatalogBehavior updateBehavior() {
        return UpdateCatalogBehavior.fromValue(updateBehavior);
    }

    /**
     * <p>
     * The update behavior when the crawler finds a changed schema.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #updateBehavior}
     * will return {@link UpdateCatalogBehavior#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #updateBehaviorAsString}.
     * </p>
     * 
     * @return The update behavior when the crawler finds a changed schema.
     * @see UpdateCatalogBehavior
     */
    public final String updateBehaviorAsString() {
        return updateBehavior;
    }

    /**
     * <p>
     * Specifies the table in the database that the schema change policy applies to.
     * </p>
     * 
     * @return Specifies the table in the database that the schema change policy applies to.
     */
    public final String table() {
        return table;
    }

    /**
     * <p>
     * Specifies the database that the schema change policy applies to.
     * </p>
     * 
     * @return Specifies the database that the schema change policy applies to.
     */
    public final String database() {
        return database;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enableUpdateCatalog());
        hashCode = 31 * hashCode + Objects.hashCode(updateBehaviorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(table());
        hashCode = 31 * hashCode + Objects.hashCode(database());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectSchemaChangePolicy)) {
            return false;
        }
        DirectSchemaChangePolicy other = (DirectSchemaChangePolicy) obj;
        return Objects.equals(enableUpdateCatalog(), other.enableUpdateCatalog())
                && Objects.equals(updateBehaviorAsString(), other.updateBehaviorAsString())
                && Objects.equals(table(), other.table()) && Objects.equals(database(), other.database());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DirectSchemaChangePolicy").add("EnableUpdateCatalog", enableUpdateCatalog())
                .add("UpdateBehavior", updateBehaviorAsString()).add("Table", table()).add("Database", database()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "EnableUpdateCatalog":
            return Optional.ofNullable(clazz.cast(enableUpdateCatalog()));
        case "UpdateBehavior":
            return Optional.ofNullable(clazz.cast(updateBehaviorAsString()));
        case "Table":
            return Optional.ofNullable(clazz.cast(table()));
        case "Database":
            return Optional.ofNullable(clazz.cast(database()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("EnableUpdateCatalog", ENABLE_UPDATE_CATALOG_FIELD);
        map.put("UpdateBehavior", UPDATE_BEHAVIOR_FIELD);
        map.put("Table", TABLE_FIELD);
        map.put("Database", DATABASE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DirectSchemaChangePolicy, T> g) {
        return obj -> g.apply((DirectSchemaChangePolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectSchemaChangePolicy> {
        /**
         * <p>
         * Whether to use the specified update behavior when the crawler finds a changed schema.
         * </p>
         * 
         * @param enableUpdateCatalog
         *        Whether to use the specified update behavior when the crawler finds a changed schema.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableUpdateCatalog(Boolean enableUpdateCatalog);

        /**
         * <p>
         * The update behavior when the crawler finds a changed schema.
         * </p>
         * 
         * @param updateBehavior
         *        The update behavior when the crawler finds a changed schema.
         * @see UpdateCatalogBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateCatalogBehavior
         */
        Builder updateBehavior(String updateBehavior);

        /**
         * <p>
         * The update behavior when the crawler finds a changed schema.
         * </p>
         * 
         * @param updateBehavior
         *        The update behavior when the crawler finds a changed schema.
         * @see UpdateCatalogBehavior
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdateCatalogBehavior
         */
        Builder updateBehavior(UpdateCatalogBehavior updateBehavior);

        /**
         * <p>
         * Specifies the table in the database that the schema change policy applies to.
         * </p>
         * 
         * @param table
         *        Specifies the table in the database that the schema change policy applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder table(String table);

        /**
         * <p>
         * Specifies the database that the schema change policy applies to.
         * </p>
         * 
         * @param database
         *        Specifies the database that the schema change policy applies to.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder database(String database);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enableUpdateCatalog;

        private String updateBehavior;

        private String table;

        private String database;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectSchemaChangePolicy model) {
            enableUpdateCatalog(model.enableUpdateCatalog);
            updateBehavior(model.updateBehavior);
            table(model.table);
            database(model.database);
        }

        public final Boolean getEnableUpdateCatalog() {
            return enableUpdateCatalog;
        }

        public final void setEnableUpdateCatalog(Boolean enableUpdateCatalog) {
            this.enableUpdateCatalog = enableUpdateCatalog;
        }

        @Override
        public final Builder enableUpdateCatalog(Boolean enableUpdateCatalog) {
            this.enableUpdateCatalog = enableUpdateCatalog;
            return this;
        }

        public final String getUpdateBehavior() {
            return updateBehavior;
        }

        public final void setUpdateBehavior(String updateBehavior) {
            this.updateBehavior = updateBehavior;
        }

        @Override
        public final Builder updateBehavior(String updateBehavior) {
            this.updateBehavior = updateBehavior;
            return this;
        }

        @Override
        public final Builder updateBehavior(UpdateCatalogBehavior updateBehavior) {
            this.updateBehavior(updateBehavior == null ? null : updateBehavior.toString());
            return this;
        }

        public final String getTable() {
            return table;
        }

        public final void setTable(String table) {
            this.table = table;
        }

        @Override
        public final Builder table(String table) {
            this.table = table;
            return this;
        }

        public final String getDatabase() {
            return database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        @Override
        public DirectSchemaChangePolicy build() {
            return new DirectSchemaChangePolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
