/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Encapsulates a <code>ColumnStatistics</code> object that failed and the reason for failure.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ColumnStatisticsError implements SdkPojo, Serializable,
        ToCopyableBuilder<ColumnStatisticsError.Builder, ColumnStatisticsError> {
    private static final SdkField<ColumnStatistics> COLUMN_STATISTICS_FIELD = SdkField
            .<ColumnStatistics> builder(MarshallingType.SDK_POJO).memberName("ColumnStatistics")
            .getter(getter(ColumnStatisticsError::columnStatistics)).setter(setter(Builder::columnStatistics))
            .constructor(ColumnStatistics::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatistics").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("Error").getter(getter(ColumnStatisticsError::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(COLUMN_STATISTICS_FIELD,
            ERROR_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ColumnStatistics columnStatistics;

    private final ErrorDetail error;

    private ColumnStatisticsError(BuilderImpl builder) {
        this.columnStatistics = builder.columnStatistics;
        this.error = builder.error;
    }

    /**
     * <p>
     * The <code>ColumnStatistics</code> of the column.
     * </p>
     * 
     * @return The <code>ColumnStatistics</code> of the column.
     */
    public final ColumnStatistics columnStatistics() {
        return columnStatistics;
    }

    /**
     * <p>
     * An error message with the reason for the failure of an operation.
     * </p>
     * 
     * @return An error message with the reason for the failure of an operation.
     */
    public final ErrorDetail error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(columnStatistics());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ColumnStatisticsError)) {
            return false;
        }
        ColumnStatisticsError other = (ColumnStatisticsError) obj;
        return Objects.equals(columnStatistics(), other.columnStatistics()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ColumnStatisticsError").add("ColumnStatistics", columnStatistics()).add("Error", error())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnStatistics":
            return Optional.ofNullable(clazz.cast(columnStatistics()));
        case "Error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ColumnStatistics", COLUMN_STATISTICS_FIELD);
        map.put("Error", ERROR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ColumnStatisticsError, T> g) {
        return obj -> g.apply((ColumnStatisticsError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ColumnStatisticsError> {
        /**
         * <p>
         * The <code>ColumnStatistics</code> of the column.
         * </p>
         * 
         * @param columnStatistics
         *        The <code>ColumnStatistics</code> of the column.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnStatistics(ColumnStatistics columnStatistics);

        /**
         * <p>
         * The <code>ColumnStatistics</code> of the column.
         * </p>
         * This is a convenience method that creates an instance of the {@link ColumnStatistics.Builder} avoiding the
         * need to create one manually via {@link ColumnStatistics#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ColumnStatistics.Builder#build()} is called immediately and its
         * result is passed to {@link #columnStatistics(ColumnStatistics)}.
         * 
         * @param columnStatistics
         *        a consumer that will call methods on {@link ColumnStatistics.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #columnStatistics(ColumnStatistics)
         */
        default Builder columnStatistics(Consumer<ColumnStatistics.Builder> columnStatistics) {
            return columnStatistics(ColumnStatistics.builder().applyMutation(columnStatistics).build());
        }

        /**
         * <p>
         * An error message with the reason for the failure of an operation.
         * </p>
         * 
         * @param error
         *        An error message with the reason for the failure of an operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * An error message with the reason for the failure of an operation.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ColumnStatistics columnStatistics;

        private ErrorDetail error;

        private BuilderImpl() {
        }

        private BuilderImpl(ColumnStatisticsError model) {
            columnStatistics(model.columnStatistics);
            error(model.error);
        }

        public final ColumnStatistics.Builder getColumnStatistics() {
            return columnStatistics != null ? columnStatistics.toBuilder() : null;
        }

        public final void setColumnStatistics(ColumnStatistics.BuilderImpl columnStatistics) {
            this.columnStatistics = columnStatistics != null ? columnStatistics.build() : null;
        }

        @Override
        public final Builder columnStatistics(ColumnStatistics columnStatistics) {
            this.columnStatistics = columnStatistics;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        @Override
        public ColumnStatisticsError build() {
            return new ColumnStatisticsError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
