/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.BlueprintDetails;
import software.amazon.awssdk.services.glue.model.WorkflowGraph;
import software.amazon.awssdk.services.glue.model.WorkflowRun;
import software.amazon.awssdk.services.glue.model.WorkflowRunPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Workflow
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Workflow> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Workflow.getter(Workflow::name)).setter(Workflow.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Workflow.getter(Workflow::description)).setter(Workflow.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<Map<String, String>> DEFAULT_RUN_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("DefaultRunProperties").getter(Workflow.getter(Workflow::defaultRunProperties)).setter(Workflow.setter(Builder::defaultRunProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DefaultRunProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedOn").getter(Workflow.getter(Workflow::createdOn)).setter(Workflow.setter(Builder::createdOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedOn").getter(Workflow.getter(Workflow::lastModifiedOn)).setter(Workflow.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()}).build();
    private static final SdkField<WorkflowRun> LAST_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("LastRun").getter(Workflow.getter(Workflow::lastRun)).setter(Workflow.setter(Builder::lastRun)).constructor(WorkflowRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastRun").build()}).build();
    private static final SdkField<WorkflowGraph> GRAPH_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Graph").getter(Workflow.getter(Workflow::graph)).setter(Workflow.setter(Builder::graph)).constructor(WorkflowGraph::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Graph").build()}).build();
    private static final SdkField<Integer> MAX_CONCURRENT_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("MaxConcurrentRuns").getter(Workflow.getter(Workflow::maxConcurrentRuns)).setter(Workflow.setter(Builder::maxConcurrentRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentRuns").build()}).build();
    private static final SdkField<BlueprintDetails> BLUEPRINT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("BlueprintDetails").getter(Workflow.getter(Workflow::blueprintDetails)).setter(Workflow.setter(Builder::blueprintDetails)).constructor(BlueprintDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BlueprintDetails").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DEFAULT_RUN_PROPERTIES_FIELD, CREATED_ON_FIELD, LAST_MODIFIED_ON_FIELD, LAST_RUN_FIELD, GRAPH_FIELD, MAX_CONCURRENT_RUNS_FIELD, BLUEPRINT_DETAILS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("DefaultRunProperties", DEFAULT_RUN_PROPERTIES_FIELD);
            this.put("CreatedOn", CREATED_ON_FIELD);
            this.put("LastModifiedOn", LAST_MODIFIED_ON_FIELD);
            this.put("LastRun", LAST_RUN_FIELD);
            this.put("Graph", GRAPH_FIELD);
            this.put("MaxConcurrentRuns", MAX_CONCURRENT_RUNS_FIELD);
            this.put("BlueprintDetails", BLUEPRINT_DETAILS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final Map<String, String> defaultRunProperties;
    private final Instant createdOn;
    private final Instant lastModifiedOn;
    private final WorkflowRun lastRun;
    private final WorkflowGraph graph;
    private final Integer maxConcurrentRuns;
    private final BlueprintDetails blueprintDetails;

    private Workflow(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.defaultRunProperties = builder.defaultRunProperties;
        this.createdOn = builder.createdOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.lastRun = builder.lastRun;
        this.graph = builder.graph;
        this.maxConcurrentRuns = builder.maxConcurrentRuns;
        this.blueprintDetails = builder.blueprintDetails;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasDefaultRunProperties() {
        return this.defaultRunProperties != null && !(this.defaultRunProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> defaultRunProperties() {
        return this.defaultRunProperties;
    }

    public final Instant createdOn() {
        return this.createdOn;
    }

    public final Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public final WorkflowRun lastRun() {
        return this.lastRun;
    }

    public final WorkflowGraph graph() {
        return this.graph;
    }

    public final Integer maxConcurrentRuns() {
        return this.maxConcurrentRuns;
    }

    public final BlueprintDetails blueprintDetails() {
        return this.blueprintDetails;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasDefaultRunProperties() ? this.defaultRunProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.graph());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxConcurrentRuns());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintDetails());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workflow)) {
            return false;
        }
        Workflow other = (Workflow)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasDefaultRunProperties() == other.hasDefaultRunProperties() && Objects.equals(this.defaultRunProperties(), other.defaultRunProperties()) && Objects.equals(this.createdOn(), other.createdOn()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.lastRun(), other.lastRun()) && Objects.equals(this.graph(), other.graph()) && Objects.equals(this.maxConcurrentRuns(), other.maxConcurrentRuns()) && Objects.equals(this.blueprintDetails(), other.blueprintDetails());
    }

    public final String toString() {
        return ToString.builder((String)"Workflow").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DefaultRunProperties", this.hasDefaultRunProperties() ? this.defaultRunProperties() : null).add("CreatedOn", (Object)this.createdOn()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("LastRun", (Object)this.lastRun()).add("Graph", (Object)this.graph()).add("MaxConcurrentRuns", (Object)this.maxConcurrentRuns()).add("BlueprintDetails", (Object)this.blueprintDetails()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DefaultRunProperties": {
                return Optional.ofNullable(clazz.cast(this.defaultRunProperties()));
            }
            case "CreatedOn": {
                return Optional.ofNullable(clazz.cast(this.createdOn()));
            }
            case "LastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
            case "LastRun": {
                return Optional.ofNullable(clazz.cast(this.lastRun()));
            }
            case "Graph": {
                return Optional.ofNullable(clazz.cast(this.graph()));
            }
            case "MaxConcurrentRuns": {
                return Optional.ofNullable(clazz.cast(this.maxConcurrentRuns()));
            }
            case "BlueprintDetails": {
                return Optional.ofNullable(clazz.cast(this.blueprintDetails()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Workflow, T> g) {
        return obj -> g.apply((Workflow)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private Map<String, String> defaultRunProperties = DefaultSdkAutoConstructMap.getInstance();
        private Instant createdOn;
        private Instant lastModifiedOn;
        private WorkflowRun lastRun;
        private WorkflowGraph graph;
        private Integer maxConcurrentRuns;
        private BlueprintDetails blueprintDetails;

        private BuilderImpl() {
        }

        private BuilderImpl(Workflow model) {
            this.name(model.name);
            this.description(model.description);
            this.defaultRunProperties(model.defaultRunProperties);
            this.createdOn(model.createdOn);
            this.lastModifiedOn(model.lastModifiedOn);
            this.lastRun(model.lastRun);
            this.graph(model.graph);
            this.maxConcurrentRuns(model.maxConcurrentRuns);
            this.blueprintDetails(model.blueprintDetails);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Map<String, String> getDefaultRunProperties() {
            if (this.defaultRunProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.defaultRunProperties;
        }

        public final void setDefaultRunProperties(Map<String, String> defaultRunProperties) {
            this.defaultRunProperties = WorkflowRunPropertiesCopier.copy(defaultRunProperties);
        }

        @Override
        public final Builder defaultRunProperties(Map<String, String> defaultRunProperties) {
            this.defaultRunProperties = WorkflowRunPropertiesCopier.copy(defaultRunProperties);
            return this;
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final WorkflowRun.Builder getLastRun() {
            return this.lastRun != null ? this.lastRun.toBuilder() : null;
        }

        public final void setLastRun(WorkflowRun.BuilderImpl lastRun) {
            this.lastRun = lastRun != null ? lastRun.build() : null;
        }

        @Override
        public final Builder lastRun(WorkflowRun lastRun) {
            this.lastRun = lastRun;
            return this;
        }

        public final WorkflowGraph.Builder getGraph() {
            return this.graph != null ? this.graph.toBuilder() : null;
        }

        public final void setGraph(WorkflowGraph.BuilderImpl graph) {
            this.graph = graph != null ? graph.build() : null;
        }

        @Override
        public final Builder graph(WorkflowGraph graph) {
            this.graph = graph;
            return this;
        }

        public final Integer getMaxConcurrentRuns() {
            return this.maxConcurrentRuns;
        }

        public final void setMaxConcurrentRuns(Integer maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
        }

        @Override
        public final Builder maxConcurrentRuns(Integer maxConcurrentRuns) {
            this.maxConcurrentRuns = maxConcurrentRuns;
            return this;
        }

        public final BlueprintDetails.Builder getBlueprintDetails() {
            return this.blueprintDetails != null ? this.blueprintDetails.toBuilder() : null;
        }

        public final void setBlueprintDetails(BlueprintDetails.BuilderImpl blueprintDetails) {
            this.blueprintDetails = blueprintDetails != null ? blueprintDetails.build() : null;
        }

        @Override
        public final Builder blueprintDetails(BlueprintDetails blueprintDetails) {
            this.blueprintDetails = blueprintDetails;
            return this;
        }

        public Workflow build() {
            return new Workflow(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Workflow> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder defaultRunProperties(Map<String, String> var1);

        public Builder createdOn(Instant var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder lastRun(WorkflowRun var1);

        default public Builder lastRun(Consumer<WorkflowRun.Builder> lastRun) {
            return this.lastRun((WorkflowRun)((WorkflowRun.Builder)WorkflowRun.builder().applyMutation(lastRun)).build());
        }

        public Builder graph(WorkflowGraph var1);

        default public Builder graph(Consumer<WorkflowGraph.Builder> graph) {
            return this.graph((WorkflowGraph)((WorkflowGraph.Builder)WorkflowGraph.builder().applyMutation(graph)).build());
        }

        public Builder maxConcurrentRuns(Integer var1);

        public Builder blueprintDetails(BlueprintDetails var1);

        default public Builder blueprintDetails(Consumer<BlueprintDetails.Builder> blueprintDetails) {
            return this.blueprintDetails((BlueprintDetails)((BlueprintDetails.Builder)BlueprintDetails.builder().applyMutation(blueprintDetails)).build());
        }
    }
}

