/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.ViewDialect;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ViewRepresentationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ViewRepresentationInput> {
    private static final SdkField<String> DIALECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Dialect").getter(ViewRepresentationInput.getter(ViewRepresentationInput::dialectAsString)).setter(ViewRepresentationInput.setter(Builder::dialect)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Dialect").build()}).build();
    private static final SdkField<String> DIALECT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DialectVersion").getter(ViewRepresentationInput.getter(ViewRepresentationInput::dialectVersion)).setter(ViewRepresentationInput.setter(Builder::dialectVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DialectVersion").build()}).build();
    private static final SdkField<String> VIEW_ORIGINAL_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewOriginalText").getter(ViewRepresentationInput.getter(ViewRepresentationInput::viewOriginalText)).setter(ViewRepresentationInput.setter(Builder::viewOriginalText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewOriginalText").build()}).build();
    private static final SdkField<String> VALIDATION_CONNECTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ValidationConnection").getter(ViewRepresentationInput.getter(ViewRepresentationInput::validationConnection)).setter(ViewRepresentationInput.setter(Builder::validationConnection)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ValidationConnection").build()}).build();
    private static final SdkField<String> VIEW_EXPANDED_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ViewExpandedText").getter(ViewRepresentationInput.getter(ViewRepresentationInput::viewExpandedText)).setter(ViewRepresentationInput.setter(Builder::viewExpandedText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewExpandedText").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIALECT_FIELD, DIALECT_VERSION_FIELD, VIEW_ORIGINAL_TEXT_FIELD, VALIDATION_CONNECTION_FIELD, VIEW_EXPANDED_TEXT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Dialect", DIALECT_FIELD);
            this.put("DialectVersion", DIALECT_VERSION_FIELD);
            this.put("ViewOriginalText", VIEW_ORIGINAL_TEXT_FIELD);
            this.put("ValidationConnection", VALIDATION_CONNECTION_FIELD);
            this.put("ViewExpandedText", VIEW_EXPANDED_TEXT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String dialect;
    private final String dialectVersion;
    private final String viewOriginalText;
    private final String validationConnection;
    private final String viewExpandedText;

    private ViewRepresentationInput(BuilderImpl builder) {
        this.dialect = builder.dialect;
        this.dialectVersion = builder.dialectVersion;
        this.viewOriginalText = builder.viewOriginalText;
        this.validationConnection = builder.validationConnection;
        this.viewExpandedText = builder.viewExpandedText;
    }

    public final ViewDialect dialect() {
        return ViewDialect.fromValue(this.dialect);
    }

    public final String dialectAsString() {
        return this.dialect;
    }

    public final String dialectVersion() {
        return this.dialectVersion;
    }

    public final String viewOriginalText() {
        return this.viewOriginalText;
    }

    public final String validationConnection() {
        return this.validationConnection;
    }

    public final String viewExpandedText() {
        return this.viewExpandedText;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dialectAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dialectVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewOriginalText());
        hashCode = 31 * hashCode + Objects.hashCode(this.validationConnection());
        hashCode = 31 * hashCode + Objects.hashCode(this.viewExpandedText());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ViewRepresentationInput)) {
            return false;
        }
        ViewRepresentationInput other = (ViewRepresentationInput)obj;
        return Objects.equals(this.dialectAsString(), other.dialectAsString()) && Objects.equals(this.dialectVersion(), other.dialectVersion()) && Objects.equals(this.viewOriginalText(), other.viewOriginalText()) && Objects.equals(this.validationConnection(), other.validationConnection()) && Objects.equals(this.viewExpandedText(), other.viewExpandedText());
    }

    public final String toString() {
        return ToString.builder((String)"ViewRepresentationInput").add("Dialect", (Object)this.dialectAsString()).add("DialectVersion", (Object)this.dialectVersion()).add("ViewOriginalText", (Object)this.viewOriginalText()).add("ValidationConnection", (Object)this.validationConnection()).add("ViewExpandedText", (Object)this.viewExpandedText()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Dialect": {
                return Optional.ofNullable(clazz.cast(this.dialectAsString()));
            }
            case "DialectVersion": {
                return Optional.ofNullable(clazz.cast(this.dialectVersion()));
            }
            case "ViewOriginalText": {
                return Optional.ofNullable(clazz.cast(this.viewOriginalText()));
            }
            case "ValidationConnection": {
                return Optional.ofNullable(clazz.cast(this.validationConnection()));
            }
            case "ViewExpandedText": {
                return Optional.ofNullable(clazz.cast(this.viewExpandedText()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ViewRepresentationInput, T> g) {
        return obj -> g.apply((ViewRepresentationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dialect;
        private String dialectVersion;
        private String viewOriginalText;
        private String validationConnection;
        private String viewExpandedText;

        private BuilderImpl() {
        }

        private BuilderImpl(ViewRepresentationInput model) {
            this.dialect(model.dialect);
            this.dialectVersion(model.dialectVersion);
            this.viewOriginalText(model.viewOriginalText);
            this.validationConnection(model.validationConnection);
            this.viewExpandedText(model.viewExpandedText);
        }

        public final String getDialect() {
            return this.dialect;
        }

        public final void setDialect(String dialect) {
            this.dialect = dialect;
        }

        @Override
        public final Builder dialect(String dialect) {
            this.dialect = dialect;
            return this;
        }

        @Override
        public final Builder dialect(ViewDialect dialect) {
            this.dialect(dialect == null ? null : dialect.toString());
            return this;
        }

        public final String getDialectVersion() {
            return this.dialectVersion;
        }

        public final void setDialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
        }

        @Override
        public final Builder dialectVersion(String dialectVersion) {
            this.dialectVersion = dialectVersion;
            return this;
        }

        public final String getViewOriginalText() {
            return this.viewOriginalText;
        }

        public final void setViewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
        }

        @Override
        public final Builder viewOriginalText(String viewOriginalText) {
            this.viewOriginalText = viewOriginalText;
            return this;
        }

        public final String getValidationConnection() {
            return this.validationConnection;
        }

        public final void setValidationConnection(String validationConnection) {
            this.validationConnection = validationConnection;
        }

        @Override
        public final Builder validationConnection(String validationConnection) {
            this.validationConnection = validationConnection;
            return this;
        }

        public final String getViewExpandedText() {
            return this.viewExpandedText;
        }

        public final void setViewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
        }

        @Override
        public final Builder viewExpandedText(String viewExpandedText) {
            this.viewExpandedText = viewExpandedText;
            return this;
        }

        public ViewRepresentationInput build() {
            return new ViewRepresentationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ViewRepresentationInput> {
        public Builder dialect(String var1);

        public Builder dialect(ViewDialect var1);

        public Builder dialectVersion(String var1);

        public Builder viewOriginalText(String var1);

        public Builder validationConnection(String var1);

        public Builder viewExpandedText(String var1);
    }
}

