/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.Table;
import software.amazon.awssdk.services.glue.model.ViewValidation;
import software.amazon.awssdk.services.glue.model.ViewValidationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StatusDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, StatusDetails> {
    private static final SdkField<Table> REQUESTED_CHANGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("RequestedChange").getter(StatusDetails.getter(StatusDetails::requestedChange)).setter(StatusDetails.setter(Builder::requestedChange)).constructor(Table::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RequestedChange").build()}).build();
    private static final SdkField<List<ViewValidation>> VIEW_VALIDATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ViewValidations").getter(StatusDetails.getter(StatusDetails::viewValidations)).setter(StatusDetails.setter(Builder::viewValidations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ViewValidations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ViewValidation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REQUESTED_CHANGE_FIELD, VIEW_VALIDATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("RequestedChange", REQUESTED_CHANGE_FIELD);
            this.put("ViewValidations", VIEW_VALIDATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Table requestedChange;
    private final List<ViewValidation> viewValidations;

    private StatusDetails(BuilderImpl builder) {
        this.requestedChange = builder.requestedChange;
        this.viewValidations = builder.viewValidations;
    }

    public final Table requestedChange() {
        return this.requestedChange;
    }

    public final boolean hasViewValidations() {
        return this.viewValidations != null && !(this.viewValidations instanceof SdkAutoConstructList);
    }

    public final List<ViewValidation> viewValidations() {
        return this.viewValidations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.requestedChange());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasViewValidations() ? this.viewValidations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StatusDetails)) {
            return false;
        }
        StatusDetails other = (StatusDetails)obj;
        return Objects.equals(this.requestedChange(), other.requestedChange()) && this.hasViewValidations() == other.hasViewValidations() && Objects.equals(this.viewValidations(), other.viewValidations());
    }

    public final String toString() {
        return ToString.builder((String)"StatusDetails").add("RequestedChange", (Object)this.requestedChange()).add("ViewValidations", this.hasViewValidations() ? this.viewValidations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "RequestedChange": {
                return Optional.ofNullable(clazz.cast(this.requestedChange()));
            }
            case "ViewValidations": {
                return Optional.ofNullable(clazz.cast(this.viewValidations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<StatusDetails, T> g) {
        return obj -> g.apply((StatusDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Table requestedChange;
        private List<ViewValidation> viewValidations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StatusDetails model) {
            this.requestedChange(model.requestedChange);
            this.viewValidations(model.viewValidations);
        }

        public final Table.Builder getRequestedChange() {
            return this.requestedChange != null ? this.requestedChange.toBuilder() : null;
        }

        public final void setRequestedChange(Table.BuilderImpl requestedChange) {
            this.requestedChange = requestedChange != null ? requestedChange.build() : null;
        }

        @Override
        public final Builder requestedChange(Table requestedChange) {
            this.requestedChange = requestedChange;
            return this;
        }

        public final List<ViewValidation.Builder> getViewValidations() {
            List<ViewValidation.Builder> result = ViewValidationListCopier.copyToBuilder(this.viewValidations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setViewValidations(Collection<ViewValidation.BuilderImpl> viewValidations) {
            this.viewValidations = ViewValidationListCopier.copyFromBuilder(viewValidations);
        }

        @Override
        public final Builder viewValidations(Collection<ViewValidation> viewValidations) {
            this.viewValidations = ViewValidationListCopier.copy(viewValidations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder viewValidations(ViewValidation ... viewValidations) {
            this.viewValidations(Arrays.asList(viewValidations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder viewValidations(Consumer<ViewValidation.Builder> ... viewValidations) {
            this.viewValidations(Stream.of(viewValidations).map(c -> (ViewValidation)((ViewValidation.Builder)ViewValidation.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public StatusDetails build() {
            return new StatusDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, StatusDetails> {
        public Builder requestedChange(Table var1);

        default public Builder requestedChange(Consumer<Table.Builder> requestedChange) {
            return this.requestedChange((Table)((Table.Builder)Table.builder().applyMutation(requestedChange)).build());
        }

        public Builder viewValidations(Collection<ViewValidation> var1);

        public Builder viewValidations(ViewValidation ... var1);

        public Builder viewValidations(Consumer<ViewValidation.Builder> ... var1);
    }
}

