/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.PathListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class S3Target
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, S3Target> {
    private static final SdkField<String> PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Path").getter(S3Target.getter(S3Target::path)).setter(S3Target.setter(Builder::path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Path").build()}).build();
    private static final SdkField<List<String>> EXCLUSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Exclusions").getter(S3Target.getter(S3Target::exclusions)).setter(S3Target.setter(Builder::exclusions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Exclusions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ConnectionName").getter(S3Target.getter(S3Target::connectionName)).setter(S3Target.setter(Builder::connectionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionName").build()}).build();
    private static final SdkField<Integer> SAMPLE_SIZE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SampleSize").getter(S3Target.getter(S3Target::sampleSize)).setter(S3Target.setter(Builder::sampleSize)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SampleSize").build()}).build();
    private static final SdkField<String> EVENT_QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EventQueueArn").getter(S3Target.getter(S3Target::eventQueueArn)).setter(S3Target.setter(Builder::eventQueueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EventQueueArn").build()}).build();
    private static final SdkField<String> DLQ_EVENT_QUEUE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DlqEventQueueArn").getter(S3Target.getter(S3Target::dlqEventQueueArn)).setter(S3Target.setter(Builder::dlqEventQueueArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DlqEventQueueArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PATH_FIELD, EXCLUSIONS_FIELD, CONNECTION_NAME_FIELD, SAMPLE_SIZE_FIELD, EVENT_QUEUE_ARN_FIELD, DLQ_EVENT_QUEUE_ARN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Path", PATH_FIELD);
            this.put("Exclusions", EXCLUSIONS_FIELD);
            this.put("ConnectionName", CONNECTION_NAME_FIELD);
            this.put("SampleSize", SAMPLE_SIZE_FIELD);
            this.put("EventQueueArn", EVENT_QUEUE_ARN_FIELD);
            this.put("DlqEventQueueArn", DLQ_EVENT_QUEUE_ARN_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String path;
    private final List<String> exclusions;
    private final String connectionName;
    private final Integer sampleSize;
    private final String eventQueueArn;
    private final String dlqEventQueueArn;

    private S3Target(BuilderImpl builder) {
        this.path = builder.path;
        this.exclusions = builder.exclusions;
        this.connectionName = builder.connectionName;
        this.sampleSize = builder.sampleSize;
        this.eventQueueArn = builder.eventQueueArn;
        this.dlqEventQueueArn = builder.dlqEventQueueArn;
    }

    public final String path() {
        return this.path;
    }

    public final boolean hasExclusions() {
        return this.exclusions != null && !(this.exclusions instanceof SdkAutoConstructList);
    }

    public final List<String> exclusions() {
        return this.exclusions;
    }

    public final String connectionName() {
        return this.connectionName;
    }

    public final Integer sampleSize() {
        return this.sampleSize;
    }

    public final String eventQueueArn() {
        return this.eventQueueArn;
    }

    public final String dlqEventQueueArn() {
        return this.dlqEventQueueArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.path());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExclusions() ? this.exclusions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.sampleSize());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventQueueArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dlqEventQueueArn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof S3Target)) {
            return false;
        }
        S3Target other = (S3Target)obj;
        return Objects.equals(this.path(), other.path()) && this.hasExclusions() == other.hasExclusions() && Objects.equals(this.exclusions(), other.exclusions()) && Objects.equals(this.connectionName(), other.connectionName()) && Objects.equals(this.sampleSize(), other.sampleSize()) && Objects.equals(this.eventQueueArn(), other.eventQueueArn()) && Objects.equals(this.dlqEventQueueArn(), other.dlqEventQueueArn());
    }

    public final String toString() {
        return ToString.builder((String)"S3Target").add("Path", (Object)this.path()).add("Exclusions", this.hasExclusions() ? this.exclusions() : null).add("ConnectionName", (Object)this.connectionName()).add("SampleSize", (Object)this.sampleSize()).add("EventQueueArn", (Object)this.eventQueueArn()).add("DlqEventQueueArn", (Object)this.dlqEventQueueArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Path": {
                return Optional.ofNullable(clazz.cast(this.path()));
            }
            case "Exclusions": {
                return Optional.ofNullable(clazz.cast(this.exclusions()));
            }
            case "ConnectionName": {
                return Optional.ofNullable(clazz.cast(this.connectionName()));
            }
            case "SampleSize": {
                return Optional.ofNullable(clazz.cast(this.sampleSize()));
            }
            case "EventQueueArn": {
                return Optional.ofNullable(clazz.cast(this.eventQueueArn()));
            }
            case "DlqEventQueueArn": {
                return Optional.ofNullable(clazz.cast(this.dlqEventQueueArn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<S3Target, T> g) {
        return obj -> g.apply((S3Target)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String path;
        private List<String> exclusions = DefaultSdkAutoConstructList.getInstance();
        private String connectionName;
        private Integer sampleSize;
        private String eventQueueArn;
        private String dlqEventQueueArn;

        private BuilderImpl() {
        }

        private BuilderImpl(S3Target model) {
            this.path(model.path);
            this.exclusions(model.exclusions);
            this.connectionName(model.connectionName);
            this.sampleSize(model.sampleSize);
            this.eventQueueArn(model.eventQueueArn);
            this.dlqEventQueueArn(model.dlqEventQueueArn);
        }

        public final String getPath() {
            return this.path;
        }

        public final void setPath(String path) {
            this.path = path;
        }

        @Override
        public final Builder path(String path) {
            this.path = path;
            return this;
        }

        public final Collection<String> getExclusions() {
            if (this.exclusions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.exclusions;
        }

        public final void setExclusions(Collection<String> exclusions) {
            this.exclusions = PathListCopier.copy(exclusions);
        }

        @Override
        public final Builder exclusions(Collection<String> exclusions) {
            this.exclusions = PathListCopier.copy(exclusions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exclusions(String ... exclusions) {
            this.exclusions(Arrays.asList(exclusions));
            return this;
        }

        public final String getConnectionName() {
            return this.connectionName;
        }

        public final void setConnectionName(String connectionName) {
            this.connectionName = connectionName;
        }

        @Override
        public final Builder connectionName(String connectionName) {
            this.connectionName = connectionName;
            return this;
        }

        public final Integer getSampleSize() {
            return this.sampleSize;
        }

        public final void setSampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
        }

        @Override
        public final Builder sampleSize(Integer sampleSize) {
            this.sampleSize = sampleSize;
            return this;
        }

        public final String getEventQueueArn() {
            return this.eventQueueArn;
        }

        public final void setEventQueueArn(String eventQueueArn) {
            this.eventQueueArn = eventQueueArn;
        }

        @Override
        public final Builder eventQueueArn(String eventQueueArn) {
            this.eventQueueArn = eventQueueArn;
            return this;
        }

        public final String getDlqEventQueueArn() {
            return this.dlqEventQueueArn;
        }

        public final void setDlqEventQueueArn(String dlqEventQueueArn) {
            this.dlqEventQueueArn = dlqEventQueueArn;
        }

        @Override
        public final Builder dlqEventQueueArn(String dlqEventQueueArn) {
            this.dlqEventQueueArn = dlqEventQueueArn;
            return this;
        }

        public S3Target build() {
            return new S3Target(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, S3Target> {
        public Builder path(String var1);

        public Builder exclusions(Collection<String> var1);

        public Builder exclusions(String ... var1);

        public Builder connectionName(String var1);

        public Builder sampleSize(Integer var1);

        public Builder eventQueueArn(String var1);

        public Builder dlqEventQueueArn(String var1);
    }
}

