/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LakeFormationConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LakeFormationConfiguration> {
    private static final SdkField<Boolean> USE_LAKE_FORMATION_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("UseLakeFormationCredentials").getter(LakeFormationConfiguration.getter(LakeFormationConfiguration::useLakeFormationCredentials)).setter(LakeFormationConfiguration.setter(Builder::useLakeFormationCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UseLakeFormationCredentials").build()}).build();
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccountId").getter(LakeFormationConfiguration.getter(LakeFormationConfiguration::accountId)).setter(LakeFormationConfiguration.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USE_LAKE_FORMATION_CREDENTIALS_FIELD, ACCOUNT_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("UseLakeFormationCredentials", USE_LAKE_FORMATION_CREDENTIALS_FIELD);
            this.put("AccountId", ACCOUNT_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Boolean useLakeFormationCredentials;
    private final String accountId;

    private LakeFormationConfiguration(BuilderImpl builder) {
        this.useLakeFormationCredentials = builder.useLakeFormationCredentials;
        this.accountId = builder.accountId;
    }

    public final Boolean useLakeFormationCredentials() {
        return this.useLakeFormationCredentials;
    }

    public final String accountId() {
        return this.accountId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.useLakeFormationCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LakeFormationConfiguration)) {
            return false;
        }
        LakeFormationConfiguration other = (LakeFormationConfiguration)obj;
        return Objects.equals(this.useLakeFormationCredentials(), other.useLakeFormationCredentials()) && Objects.equals(this.accountId(), other.accountId());
    }

    public final String toString() {
        return ToString.builder((String)"LakeFormationConfiguration").add("UseLakeFormationCredentials", (Object)this.useLakeFormationCredentials()).add("AccountId", (Object)this.accountId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "UseLakeFormationCredentials": {
                return Optional.ofNullable(clazz.cast(this.useLakeFormationCredentials()));
            }
            case "AccountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LakeFormationConfiguration, T> g) {
        return obj -> g.apply((LakeFormationConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean useLakeFormationCredentials;
        private String accountId;

        private BuilderImpl() {
        }

        private BuilderImpl(LakeFormationConfiguration model) {
            this.useLakeFormationCredentials(model.useLakeFormationCredentials);
            this.accountId(model.accountId);
        }

        public final Boolean getUseLakeFormationCredentials() {
            return this.useLakeFormationCredentials;
        }

        public final void setUseLakeFormationCredentials(Boolean useLakeFormationCredentials) {
            this.useLakeFormationCredentials = useLakeFormationCredentials;
        }

        @Override
        public final Builder useLakeFormationCredentials(Boolean useLakeFormationCredentials) {
            this.useLakeFormationCredentials = useLakeFormationCredentials;
            return this;
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public LakeFormationConfiguration build() {
            return new LakeFormationConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LakeFormationConfiguration> {
        public Builder useLakeFormationCredentials(Boolean var1);

        public Builder accountId(String var1);
    }
}

