/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class IcebergRetentionConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, IcebergRetentionConfiguration> {
    private static final SdkField<Integer> SNAPSHOT_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("snapshotRetentionPeriodInDays").getter(IcebergRetentionConfiguration.getter(IcebergRetentionConfiguration::snapshotRetentionPeriodInDays)).setter(IcebergRetentionConfiguration.setter(Builder::snapshotRetentionPeriodInDays)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("snapshotRetentionPeriodInDays").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_SNAPSHOTS_TO_RETAIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("numberOfSnapshotsToRetain").getter(IcebergRetentionConfiguration.getter(IcebergRetentionConfiguration::numberOfSnapshotsToRetain)).setter(IcebergRetentionConfiguration.setter(Builder::numberOfSnapshotsToRetain)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("numberOfSnapshotsToRetain").build()}).build();
    private static final SdkField<Boolean> CLEAN_EXPIRED_FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("cleanExpiredFiles").getter(IcebergRetentionConfiguration.getter(IcebergRetentionConfiguration::cleanExpiredFiles)).setter(IcebergRetentionConfiguration.setter(Builder::cleanExpiredFiles)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cleanExpiredFiles").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SNAPSHOT_RETENTION_PERIOD_IN_DAYS_FIELD, NUMBER_OF_SNAPSHOTS_TO_RETAIN_FIELD, CLEAN_EXPIRED_FILES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("snapshotRetentionPeriodInDays", SNAPSHOT_RETENTION_PERIOD_IN_DAYS_FIELD);
            this.put("numberOfSnapshotsToRetain", NUMBER_OF_SNAPSHOTS_TO_RETAIN_FIELD);
            this.put("cleanExpiredFiles", CLEAN_EXPIRED_FILES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Integer snapshotRetentionPeriodInDays;
    private final Integer numberOfSnapshotsToRetain;
    private final Boolean cleanExpiredFiles;

    private IcebergRetentionConfiguration(BuilderImpl builder) {
        this.snapshotRetentionPeriodInDays = builder.snapshotRetentionPeriodInDays;
        this.numberOfSnapshotsToRetain = builder.numberOfSnapshotsToRetain;
        this.cleanExpiredFiles = builder.cleanExpiredFiles;
    }

    public final Integer snapshotRetentionPeriodInDays() {
        return this.snapshotRetentionPeriodInDays;
    }

    public final Integer numberOfSnapshotsToRetain() {
        return this.numberOfSnapshotsToRetain;
    }

    public final Boolean cleanExpiredFiles() {
        return this.cleanExpiredFiles;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfSnapshotsToRetain());
        hashCode = 31 * hashCode + Objects.hashCode(this.cleanExpiredFiles());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergRetentionConfiguration)) {
            return false;
        }
        IcebergRetentionConfiguration other = (IcebergRetentionConfiguration)obj;
        return Objects.equals(this.snapshotRetentionPeriodInDays(), other.snapshotRetentionPeriodInDays()) && Objects.equals(this.numberOfSnapshotsToRetain(), other.numberOfSnapshotsToRetain()) && Objects.equals(this.cleanExpiredFiles(), other.cleanExpiredFiles());
    }

    public final String toString() {
        return ToString.builder((String)"IcebergRetentionConfiguration").add("SnapshotRetentionPeriodInDays", (Object)this.snapshotRetentionPeriodInDays()).add("NumberOfSnapshotsToRetain", (Object)this.numberOfSnapshotsToRetain()).add("CleanExpiredFiles", (Object)this.cleanExpiredFiles()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "snapshotRetentionPeriodInDays": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionPeriodInDays()));
            }
            case "numberOfSnapshotsToRetain": {
                return Optional.ofNullable(clazz.cast(this.numberOfSnapshotsToRetain()));
            }
            case "cleanExpiredFiles": {
                return Optional.ofNullable(clazz.cast(this.cleanExpiredFiles()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<IcebergRetentionConfiguration, T> g) {
        return obj -> g.apply((IcebergRetentionConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer snapshotRetentionPeriodInDays;
        private Integer numberOfSnapshotsToRetain;
        private Boolean cleanExpiredFiles;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergRetentionConfiguration model) {
            this.snapshotRetentionPeriodInDays(model.snapshotRetentionPeriodInDays);
            this.numberOfSnapshotsToRetain(model.numberOfSnapshotsToRetain);
            this.cleanExpiredFiles(model.cleanExpiredFiles);
        }

        public final Integer getSnapshotRetentionPeriodInDays() {
            return this.snapshotRetentionPeriodInDays;
        }

        public final void setSnapshotRetentionPeriodInDays(Integer snapshotRetentionPeriodInDays) {
            this.snapshotRetentionPeriodInDays = snapshotRetentionPeriodInDays;
        }

        @Override
        public final Builder snapshotRetentionPeriodInDays(Integer snapshotRetentionPeriodInDays) {
            this.snapshotRetentionPeriodInDays = snapshotRetentionPeriodInDays;
            return this;
        }

        public final Integer getNumberOfSnapshotsToRetain() {
            return this.numberOfSnapshotsToRetain;
        }

        public final void setNumberOfSnapshotsToRetain(Integer numberOfSnapshotsToRetain) {
            this.numberOfSnapshotsToRetain = numberOfSnapshotsToRetain;
        }

        @Override
        public final Builder numberOfSnapshotsToRetain(Integer numberOfSnapshotsToRetain) {
            this.numberOfSnapshotsToRetain = numberOfSnapshotsToRetain;
            return this;
        }

        public final Boolean getCleanExpiredFiles() {
            return this.cleanExpiredFiles;
        }

        public final void setCleanExpiredFiles(Boolean cleanExpiredFiles) {
            this.cleanExpiredFiles = cleanExpiredFiles;
        }

        @Override
        public final Builder cleanExpiredFiles(Boolean cleanExpiredFiles) {
            this.cleanExpiredFiles = cleanExpiredFiles;
            return this;
        }

        public IcebergRetentionConfiguration build() {
            return new IcebergRetentionConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, IcebergRetentionConfiguration> {
        public Builder snapshotRetentionPeriodInDays(Integer var1);

        public Builder numberOfSnapshotsToRetain(Integer var1);

        public Builder cleanExpiredFiles(Boolean var1);
    }
}

