/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DataQualityTargetTable;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDataQualityRulesetResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, GetDataQualityRulesetResponse> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(GetDataQualityRulesetResponse.getter(GetDataQualityRulesetResponse::name)).setter(GetDataQualityRulesetResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(GetDataQualityRulesetResponse.getter(GetDataQualityRulesetResponse::description)).setter(GetDataQualityRulesetResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> RULESET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Ruleset").getter(GetDataQualityRulesetResponse.getter(GetDataQualityRulesetResponse::ruleset)).setter(GetDataQualityRulesetResponse.setter(Builder::ruleset)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Ruleset").build()}).build();
    private static final SdkField<DataQualityTargetTable> TARGET_TABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("TargetTable").getter(GetDataQualityRulesetResponse.getter(GetDataQualityRulesetResponse::targetTable)).setter(GetDataQualityRulesetResponse.setter(Builder::targetTable)).constructor(DataQualityTargetTable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetTable").build()}).build();
    private static final SdkField<Instant> CREATED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("CreatedOn").getter(GetDataQualityRulesetResponse.getter(GetDataQualityRulesetResponse::createdOn)).setter(GetDataQualityRulesetResponse.setter(Builder::createdOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedOn").build()}).build();
    private static final SdkField<Instant> LAST_MODIFIED_ON_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("LastModifiedOn").getter(GetDataQualityRulesetResponse.getter(GetDataQualityRulesetResponse::lastModifiedOn)).setter(GetDataQualityRulesetResponse.setter(Builder::lastModifiedOn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LastModifiedOn").build()}).build();
    private static final SdkField<String> RECOMMENDATION_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("RecommendationRunId").getter(GetDataQualityRulesetResponse.getter(GetDataQualityRulesetResponse::recommendationRunId)).setter(GetDataQualityRulesetResponse.setter(Builder::recommendationRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecommendationRunId").build()}).build();
    private static final SdkField<String> DATA_QUALITY_SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataQualitySecurityConfiguration").getter(GetDataQualityRulesetResponse.getter(GetDataQualityRulesetResponse::dataQualitySecurityConfiguration)).setter(GetDataQualityRulesetResponse.setter(Builder::dataQualitySecurityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataQualitySecurityConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, RULESET_FIELD, TARGET_TABLE_FIELD, CREATED_ON_FIELD, LAST_MODIFIED_ON_FIELD, RECOMMENDATION_RUN_ID_FIELD, DATA_QUALITY_SECURITY_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("Ruleset", RULESET_FIELD);
            this.put("TargetTable", TARGET_TABLE_FIELD);
            this.put("CreatedOn", CREATED_ON_FIELD);
            this.put("LastModifiedOn", LAST_MODIFIED_ON_FIELD);
            this.put("RecommendationRunId", RECOMMENDATION_RUN_ID_FIELD);
            this.put("DataQualitySecurityConfiguration", DATA_QUALITY_SECURITY_CONFIGURATION_FIELD);
        }
    });
    private final String name;
    private final String description;
    private final String ruleset;
    private final DataQualityTargetTable targetTable;
    private final Instant createdOn;
    private final Instant lastModifiedOn;
    private final String recommendationRunId;
    private final String dataQualitySecurityConfiguration;

    private GetDataQualityRulesetResponse(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.ruleset = builder.ruleset;
        this.targetTable = builder.targetTable;
        this.createdOn = builder.createdOn;
        this.lastModifiedOn = builder.lastModifiedOn;
        this.recommendationRunId = builder.recommendationRunId;
        this.dataQualitySecurityConfiguration = builder.dataQualitySecurityConfiguration;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String ruleset() {
        return this.ruleset;
    }

    public final DataQualityTargetTable targetTable() {
        return this.targetTable;
    }

    public final Instant createdOn() {
        return this.createdOn;
    }

    public final Instant lastModifiedOn() {
        return this.lastModifiedOn;
    }

    public final String recommendationRunId() {
        return this.recommendationRunId;
    }

    public final String dataQualitySecurityConfiguration() {
        return this.dataQualitySecurityConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleset());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTable());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastModifiedOn());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendationRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataQualitySecurityConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDataQualityRulesetResponse)) {
            return false;
        }
        GetDataQualityRulesetResponse other = (GetDataQualityRulesetResponse)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.ruleset(), other.ruleset()) && Objects.equals(this.targetTable(), other.targetTable()) && Objects.equals(this.createdOn(), other.createdOn()) && Objects.equals(this.lastModifiedOn(), other.lastModifiedOn()) && Objects.equals(this.recommendationRunId(), other.recommendationRunId()) && Objects.equals(this.dataQualitySecurityConfiguration(), other.dataQualitySecurityConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetDataQualityRulesetResponse").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Ruleset", (Object)this.ruleset()).add("TargetTable", (Object)this.targetTable()).add("CreatedOn", (Object)this.createdOn()).add("LastModifiedOn", (Object)this.lastModifiedOn()).add("RecommendationRunId", (Object)this.recommendationRunId()).add("DataQualitySecurityConfiguration", (Object)this.dataQualitySecurityConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Ruleset": {
                return Optional.ofNullable(clazz.cast(this.ruleset()));
            }
            case "TargetTable": {
                return Optional.ofNullable(clazz.cast(this.targetTable()));
            }
            case "CreatedOn": {
                return Optional.ofNullable(clazz.cast(this.createdOn()));
            }
            case "LastModifiedOn": {
                return Optional.ofNullable(clazz.cast(this.lastModifiedOn()));
            }
            case "RecommendationRunId": {
                return Optional.ofNullable(clazz.cast(this.recommendationRunId()));
            }
            case "DataQualitySecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.dataQualitySecurityConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GetDataQualityRulesetResponse, T> g) {
        return obj -> g.apply((GetDataQualityRulesetResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String ruleset;
        private DataQualityTargetTable targetTable;
        private Instant createdOn;
        private Instant lastModifiedOn;
        private String recommendationRunId;
        private String dataQualitySecurityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDataQualityRulesetResponse model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.ruleset(model.ruleset);
            this.targetTable(model.targetTable);
            this.createdOn(model.createdOn);
            this.lastModifiedOn(model.lastModifiedOn);
            this.recommendationRunId(model.recommendationRunId);
            this.dataQualitySecurityConfiguration(model.dataQualitySecurityConfiguration);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getRuleset() {
            return this.ruleset;
        }

        public final void setRuleset(String ruleset) {
            this.ruleset = ruleset;
        }

        @Override
        public final Builder ruleset(String ruleset) {
            this.ruleset = ruleset;
            return this;
        }

        public final DataQualityTargetTable.Builder getTargetTable() {
            return this.targetTable != null ? this.targetTable.toBuilder() : null;
        }

        public final void setTargetTable(DataQualityTargetTable.BuilderImpl targetTable) {
            this.targetTable = targetTable != null ? targetTable.build() : null;
        }

        @Override
        public final Builder targetTable(DataQualityTargetTable targetTable) {
            this.targetTable = targetTable;
            return this;
        }

        public final Instant getCreatedOn() {
            return this.createdOn;
        }

        public final void setCreatedOn(Instant createdOn) {
            this.createdOn = createdOn;
        }

        @Override
        public final Builder createdOn(Instant createdOn) {
            this.createdOn = createdOn;
            return this;
        }

        public final Instant getLastModifiedOn() {
            return this.lastModifiedOn;
        }

        public final void setLastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
        }

        @Override
        public final Builder lastModifiedOn(Instant lastModifiedOn) {
            this.lastModifiedOn = lastModifiedOn;
            return this;
        }

        public final String getRecommendationRunId() {
            return this.recommendationRunId;
        }

        public final void setRecommendationRunId(String recommendationRunId) {
            this.recommendationRunId = recommendationRunId;
        }

        @Override
        public final Builder recommendationRunId(String recommendationRunId) {
            this.recommendationRunId = recommendationRunId;
            return this;
        }

        public final String getDataQualitySecurityConfiguration() {
            return this.dataQualitySecurityConfiguration;
        }

        public final void setDataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
        }

        @Override
        public final Builder dataQualitySecurityConfiguration(String dataQualitySecurityConfiguration) {
            this.dataQualitySecurityConfiguration = dataQualitySecurityConfiguration;
            return this;
        }

        @Override
        public GetDataQualityRulesetResponse build() {
            return new GetDataQualityRulesetResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDataQualityRulesetResponse> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder ruleset(String var1);

        public Builder targetTable(DataQualityTargetTable var1);

        default public Builder targetTable(Consumer<DataQualityTargetTable.Builder> targetTable) {
            return this.targetTable((DataQualityTargetTable)((DataQualityTargetTable.Builder)DataQualityTargetTable.builder().applyMutation(targetTable)).build());
        }

        public Builder createdOn(Instant var1);

        public Builder lastModifiedOn(Instant var1);

        public Builder recommendationRunId(String var1);

        public Builder dataQualitySecurityConfiguration(String var1);
    }
}

