/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.NullCheckBoxList;
import software.amazon.awssdk.services.glue.model.NullValueField;
import software.amazon.awssdk.services.glue.model.NullValueFieldsCopier;
import software.amazon.awssdk.services.glue.model.OneInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DropNullFields
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DropNullFields> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DropNullFields.getter(DropNullFields::name)).setter(DropNullFields.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<List<String>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Inputs").getter(DropNullFields.getter(DropNullFields::inputs)).setter(DropNullFields.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<NullCheckBoxList> NULL_CHECK_BOX_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NullCheckBoxList").getter(DropNullFields.getter(DropNullFields::nullCheckBoxList)).setter(DropNullFields.setter(Builder::nullCheckBoxList)).constructor(NullCheckBoxList::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullCheckBoxList").build()}).build();
    private static final SdkField<List<NullValueField>> NULL_TEXT_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("NullTextList").getter(DropNullFields.getter(DropNullFields::nullTextList)).setter(DropNullFields.setter(Builder::nullTextList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NullTextList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NullValueField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD, NULL_CHECK_BOX_LIST_FIELD, NULL_TEXT_LIST_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Inputs", INPUTS_FIELD);
            this.put("NullCheckBoxList", NULL_CHECK_BOX_LIST_FIELD);
            this.put("NullTextList", NULL_TEXT_LIST_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final List<String> inputs;
    private final NullCheckBoxList nullCheckBoxList;
    private final List<NullValueField> nullTextList;

    private DropNullFields(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.nullCheckBoxList = builder.nullCheckBoxList;
        this.nullTextList = builder.nullTextList;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<String> inputs() {
        return this.inputs;
    }

    public final NullCheckBoxList nullCheckBoxList() {
        return this.nullCheckBoxList;
    }

    public final boolean hasNullTextList() {
        return this.nullTextList != null && !(this.nullTextList instanceof SdkAutoConstructList);
    }

    public final List<NullValueField> nullTextList() {
        return this.nullTextList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nullCheckBoxList());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNullTextList() ? this.nullTextList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DropNullFields)) {
            return false;
        }
        DropNullFields other = (DropNullFields)obj;
        return Objects.equals(this.name(), other.name()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.nullCheckBoxList(), other.nullCheckBoxList()) && this.hasNullTextList() == other.hasNullTextList() && Objects.equals(this.nullTextList(), other.nullTextList());
    }

    public final String toString() {
        return ToString.builder((String)"DropNullFields").add("Name", (Object)this.name()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("NullCheckBoxList", (Object)this.nullCheckBoxList()).add("NullTextList", this.hasNullTextList() ? this.nullTextList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "NullCheckBoxList": {
                return Optional.ofNullable(clazz.cast(this.nullCheckBoxList()));
            }
            case "NullTextList": {
                return Optional.ofNullable(clazz.cast(this.nullTextList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DropNullFields, T> g) {
        return obj -> g.apply((DropNullFields)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();
        private NullCheckBoxList nullCheckBoxList;
        private List<NullValueField> nullTextList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DropNullFields model) {
            this.name(model.name);
            this.inputs(model.inputs);
            this.nullCheckBoxList(model.nullCheckBoxList);
            this.nullTextList(model.nullTextList);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (this.inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        public final NullCheckBoxList.Builder getNullCheckBoxList() {
            return this.nullCheckBoxList != null ? this.nullCheckBoxList.toBuilder() : null;
        }

        public final void setNullCheckBoxList(NullCheckBoxList.BuilderImpl nullCheckBoxList) {
            this.nullCheckBoxList = nullCheckBoxList != null ? nullCheckBoxList.build() : null;
        }

        @Override
        public final Builder nullCheckBoxList(NullCheckBoxList nullCheckBoxList) {
            this.nullCheckBoxList = nullCheckBoxList;
            return this;
        }

        public final List<NullValueField.Builder> getNullTextList() {
            List<NullValueField.Builder> result = NullValueFieldsCopier.copyToBuilder(this.nullTextList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNullTextList(Collection<NullValueField.BuilderImpl> nullTextList) {
            this.nullTextList = NullValueFieldsCopier.copyFromBuilder(nullTextList);
        }

        @Override
        public final Builder nullTextList(Collection<NullValueField> nullTextList) {
            this.nullTextList = NullValueFieldsCopier.copy(nullTextList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nullTextList(NullValueField ... nullTextList) {
            this.nullTextList(Arrays.asList(nullTextList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nullTextList(Consumer<NullValueField.Builder> ... nullTextList) {
            this.nullTextList(Stream.of(nullTextList).map(c -> (NullValueField)((NullValueField.Builder)NullValueField.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public DropNullFields build() {
            return new DropNullFields(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DropNullFields> {
        public Builder name(String var1);

        public Builder inputs(Collection<String> var1);

        public Builder inputs(String ... var1);

        public Builder nullCheckBoxList(NullCheckBoxList var1);

        default public Builder nullCheckBoxList(Consumer<NullCheckBoxList.Builder> nullCheckBoxList) {
            return this.nullCheckBoxList((NullCheckBoxList)((NullCheckBoxList.Builder)NullCheckBoxList.builder().applyMutation(nullCheckBoxList)).build());
        }

        public Builder nullTextList(Collection<NullValueField> var1);

        public Builder nullTextList(NullValueField ... var1);

        public Builder nullTextList(Consumer<NullValueField.Builder> ... var1);
    }
}

