/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.EvaluatedMetricsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualityAnalyzerResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualityAnalyzerResult> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(DataQualityAnalyzerResult.getter(DataQualityAnalyzerResult::name)).setter(DataQualityAnalyzerResult.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(DataQualityAnalyzerResult.getter(DataQualityAnalyzerResult::description)).setter(DataQualityAnalyzerResult.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> EVALUATION_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EvaluationMessage").getter(DataQualityAnalyzerResult.getter(DataQualityAnalyzerResult::evaluationMessage)).setter(DataQualityAnalyzerResult.setter(Builder::evaluationMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluationMessage").build()}).build();
    private static final SdkField<Map<String, Double>> EVALUATED_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("EvaluatedMetrics").getter(DataQualityAnalyzerResult.getter(DataQualityAnalyzerResult::evaluatedMetrics)).setter(DataQualityAnalyzerResult.setter(Builder::evaluatedMetrics)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EvaluatedMetrics").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.DOUBLE).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, EVALUATION_MESSAGE_FIELD, EVALUATED_METRICS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Name", NAME_FIELD);
            this.put("Description", DESCRIPTION_FIELD);
            this.put("EvaluationMessage", EVALUATION_MESSAGE_FIELD);
            this.put("EvaluatedMetrics", EVALUATED_METRICS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String evaluationMessage;
    private final Map<String, Double> evaluatedMetrics;

    private DataQualityAnalyzerResult(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.evaluationMessage = builder.evaluationMessage;
        this.evaluatedMetrics = builder.evaluatedMetrics;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String evaluationMessage() {
        return this.evaluationMessage;
    }

    public final boolean hasEvaluatedMetrics() {
        return this.evaluatedMetrics != null && !(this.evaluatedMetrics instanceof SdkAutoConstructMap);
    }

    public final Map<String, Double> evaluatedMetrics() {
        return this.evaluatedMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluationMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluatedMetrics() ? this.evaluatedMetrics() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityAnalyzerResult)) {
            return false;
        }
        DataQualityAnalyzerResult other = (DataQualityAnalyzerResult)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.evaluationMessage(), other.evaluationMessage()) && this.hasEvaluatedMetrics() == other.hasEvaluatedMetrics() && Objects.equals(this.evaluatedMetrics(), other.evaluatedMetrics());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualityAnalyzerResult").add("Name", (Object)this.name()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EvaluationMessage", (Object)(this.evaluationMessage() == null ? null : "*** Sensitive Data Redacted ***")).add("EvaluatedMetrics", (Object)(this.evaluatedMetrics() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "EvaluationMessage": {
                return Optional.ofNullable(clazz.cast(this.evaluationMessage()));
            }
            case "EvaluatedMetrics": {
                return Optional.ofNullable(clazz.cast(this.evaluatedMetrics()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataQualityAnalyzerResult, T> g) {
        return obj -> g.apply((DataQualityAnalyzerResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String evaluationMessage;
        private Map<String, Double> evaluatedMetrics = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityAnalyzerResult model) {
            this.name(model.name);
            this.description(model.description);
            this.evaluationMessage(model.evaluationMessage);
            this.evaluatedMetrics(model.evaluatedMetrics);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEvaluationMessage() {
            return this.evaluationMessage;
        }

        public final void setEvaluationMessage(String evaluationMessage) {
            this.evaluationMessage = evaluationMessage;
        }

        @Override
        public final Builder evaluationMessage(String evaluationMessage) {
            this.evaluationMessage = evaluationMessage;
            return this;
        }

        public final Map<String, Double> getEvaluatedMetrics() {
            if (this.evaluatedMetrics instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.evaluatedMetrics;
        }

        public final void setEvaluatedMetrics(Map<String, Double> evaluatedMetrics) {
            this.evaluatedMetrics = EvaluatedMetricsMapCopier.copy(evaluatedMetrics);
        }

        @Override
        public final Builder evaluatedMetrics(Map<String, Double> evaluatedMetrics) {
            this.evaluatedMetrics = EvaluatedMetricsMapCopier.copy(evaluatedMetrics);
            return this;
        }

        public DataQualityAnalyzerResult build() {
            return new DataQualityAnalyzerResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualityAnalyzerResult> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder evaluationMessage(String var1);

        public Builder evaluatedMetrics(Map<String, Double> var1);
    }
}

