/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.CrawlState;
import software.amazon.awssdk.services.glue.model.JobRunState;
import software.amazon.awssdk.services.glue.model.LogicalOperator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Condition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Condition> {
    private static final SdkField<String> LOGICAL_OPERATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("LogicalOperator").getter(Condition.getter(Condition::logicalOperatorAsString)).setter(Condition.setter(Builder::logicalOperator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogicalOperator").build()}).build();
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(Condition.getter(Condition::jobName)).setter(Condition.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("State").getter(Condition.getter(Condition::stateAsString)).setter(Condition.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()}).build();
    private static final SdkField<String> CRAWLER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CrawlerName").getter(Condition.getter(Condition::crawlerName)).setter(Condition.setter(Builder::crawlerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerName").build()}).build();
    private static final SdkField<String> CRAWL_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CrawlState").getter(Condition.getter(Condition::crawlStateAsString)).setter(Condition.setter(Builder::crawlState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlState").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOGICAL_OPERATOR_FIELD, JOB_NAME_FIELD, STATE_FIELD, CRAWLER_NAME_FIELD, CRAWL_STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("LogicalOperator", LOGICAL_OPERATOR_FIELD);
            this.put("JobName", JOB_NAME_FIELD);
            this.put("State", STATE_FIELD);
            this.put("CrawlerName", CRAWLER_NAME_FIELD);
            this.put("CrawlState", CRAWL_STATE_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String logicalOperator;
    private final String jobName;
    private final String state;
    private final String crawlerName;
    private final String crawlState;

    private Condition(BuilderImpl builder) {
        this.logicalOperator = builder.logicalOperator;
        this.jobName = builder.jobName;
        this.state = builder.state;
        this.crawlerName = builder.crawlerName;
        this.crawlState = builder.crawlState;
    }

    public final LogicalOperator logicalOperator() {
        return LogicalOperator.fromValue(this.logicalOperator);
    }

    public final String logicalOperatorAsString() {
        return this.logicalOperator;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final JobRunState state() {
        return JobRunState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    public final String crawlerName() {
        return this.crawlerName;
    }

    public final CrawlState crawlState() {
        return CrawlState.fromValue(this.crawlState);
    }

    public final String crawlStateAsString() {
        return this.crawlState;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.logicalOperatorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerName());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlStateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Condition)) {
            return false;
        }
        Condition other = (Condition)obj;
        return Objects.equals(this.logicalOperatorAsString(), other.logicalOperatorAsString()) && Objects.equals(this.jobName(), other.jobName()) && Objects.equals(this.stateAsString(), other.stateAsString()) && Objects.equals(this.crawlerName(), other.crawlerName()) && Objects.equals(this.crawlStateAsString(), other.crawlStateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Condition").add("LogicalOperator", (Object)this.logicalOperatorAsString()).add("JobName", (Object)this.jobName()).add("State", (Object)this.stateAsString()).add("CrawlerName", (Object)this.crawlerName()).add("CrawlState", (Object)this.crawlStateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "LogicalOperator": {
                return Optional.ofNullable(clazz.cast(this.logicalOperatorAsString()));
            }
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "State": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
            case "CrawlerName": {
                return Optional.ofNullable(clazz.cast(this.crawlerName()));
            }
            case "CrawlState": {
                return Optional.ofNullable(clazz.cast(this.crawlStateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Condition, T> g) {
        return obj -> g.apply((Condition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String logicalOperator;
        private String jobName;
        private String state;
        private String crawlerName;
        private String crawlState;

        private BuilderImpl() {
        }

        private BuilderImpl(Condition model) {
            this.logicalOperator(model.logicalOperator);
            this.jobName(model.jobName);
            this.state(model.state);
            this.crawlerName(model.crawlerName);
            this.crawlState(model.crawlState);
        }

        public final String getLogicalOperator() {
            return this.logicalOperator;
        }

        public final void setLogicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
        }

        @Override
        public final Builder logicalOperator(String logicalOperator) {
            this.logicalOperator = logicalOperator;
            return this;
        }

        @Override
        public final Builder logicalOperator(LogicalOperator logicalOperator) {
            this.logicalOperator(logicalOperator == null ? null : logicalOperator.toString());
            return this;
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(JobRunState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final String getCrawlerName() {
            return this.crawlerName;
        }

        public final void setCrawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
        }

        @Override
        public final Builder crawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
            return this;
        }

        public final String getCrawlState() {
            return this.crawlState;
        }

        public final void setCrawlState(String crawlState) {
            this.crawlState = crawlState;
        }

        @Override
        public final Builder crawlState(String crawlState) {
            this.crawlState = crawlState;
            return this;
        }

        @Override
        public final Builder crawlState(CrawlState crawlState) {
            this.crawlState(crawlState == null ? null : crawlState.toString());
            return this;
        }

        public Condition build() {
            return new Condition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Condition> {
        public Builder logicalOperator(String var1);

        public Builder logicalOperator(LogicalOperator var1);

        public Builder jobName(String var1);

        public Builder state(String var1);

        public Builder state(JobRunState var1);

        public Builder crawlerName(String var1);

        public Builder crawlState(String var1);

        public Builder crawlState(CrawlState var1);
    }
}

