/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.DataQualityResultIdsCopier;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetDataQualityResultRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, BatchGetDataQualityResultRequest> {
    private static final SdkField<List<String>> RESULT_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ResultIds").getter(BatchGetDataQualityResultRequest.getter(BatchGetDataQualityResultRequest::resultIds)).setter(BatchGetDataQualityResultRequest.setter(Builder::resultIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESULT_IDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("ResultIds", RESULT_IDS_FIELD);
        }
    });
    private final List<String> resultIds;

    private BatchGetDataQualityResultRequest(BuilderImpl builder) {
        super(builder);
        this.resultIds = builder.resultIds;
    }

    public final boolean hasResultIds() {
        return this.resultIds != null && !(this.resultIds instanceof SdkAutoConstructList);
    }

    public final List<String> resultIds() {
        return this.resultIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResultIds() ? this.resultIds() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetDataQualityResultRequest)) {
            return false;
        }
        BatchGetDataQualityResultRequest other = (BatchGetDataQualityResultRequest)((Object)obj);
        return this.hasResultIds() == other.hasResultIds() && Objects.equals(this.resultIds(), other.resultIds());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetDataQualityResultRequest").add("ResultIds", this.hasResultIds() ? this.resultIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ResultIds": {
                return Optional.ofNullable(clazz.cast(this.resultIds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<BatchGetDataQualityResultRequest, T> g) {
        return obj -> g.apply((BatchGetDataQualityResultRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private List<String> resultIds = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetDataQualityResultRequest model) {
            super(model);
            this.resultIds(model.resultIds);
        }

        public final Collection<String> getResultIds() {
            if (this.resultIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.resultIds;
        }

        public final void setResultIds(Collection<String> resultIds) {
            this.resultIds = DataQualityResultIdsCopier.copy(resultIds);
        }

        @Override
        public final Builder resultIds(Collection<String> resultIds) {
            this.resultIds = DataQualityResultIdsCopier.copy(resultIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resultIds(String ... resultIds) {
            this.resultIds(Arrays.asList(resultIds));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public BatchGetDataQualityResultRequest build() {
            return new BatchGetDataQualityResultRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetDataQualityResultRequest> {
        public Builder resultIds(Collection<String> var1);

        public Builder resultIds(String ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

