/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.GlueResponse;
import software.amazon.awssdk.services.glue.model.TableOptimizerRun;
import software.amazon.awssdk.services.glue.model.TableOptimizerRunsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTableOptimizerRunsResponse
extends GlueResponse
implements ToCopyableBuilder<Builder, ListTableOptimizerRunsResponse> {
    private static final SdkField<String> CATALOG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CatalogId").getter(ListTableOptimizerRunsResponse.getter(ListTableOptimizerRunsResponse::catalogId)).setter(ListTableOptimizerRunsResponse.setter(Builder::catalogId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CatalogId").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DatabaseName").getter(ListTableOptimizerRunsResponse.getter(ListTableOptimizerRunsResponse::databaseName)).setter(ListTableOptimizerRunsResponse.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DatabaseName").build()}).build();
    private static final SdkField<String> TABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TableName").getter(ListTableOptimizerRunsResponse.getter(ListTableOptimizerRunsResponse::tableName)).setter(ListTableOptimizerRunsResponse.setter(Builder::tableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableName").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(ListTableOptimizerRunsResponse.getter(ListTableOptimizerRunsResponse::nextToken)).setter(ListTableOptimizerRunsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final SdkField<List<TableOptimizerRun>> TABLE_OPTIMIZER_RUNS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TableOptimizerRuns").getter(ListTableOptimizerRunsResponse.getter(ListTableOptimizerRunsResponse::tableOptimizerRuns)).setter(ListTableOptimizerRunsResponse.setter(Builder::tableOptimizerRuns)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TableOptimizerRuns").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TableOptimizerRun::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CATALOG_ID_FIELD, DATABASE_NAME_FIELD, TABLE_NAME_FIELD, NEXT_TOKEN_FIELD, TABLE_OPTIMIZER_RUNS_FIELD));
    private final String catalogId;
    private final String databaseName;
    private final String tableName;
    private final String nextToken;
    private final List<TableOptimizerRun> tableOptimizerRuns;

    private ListTableOptimizerRunsResponse(BuilderImpl builder) {
        super(builder);
        this.catalogId = builder.catalogId;
        this.databaseName = builder.databaseName;
        this.tableName = builder.tableName;
        this.nextToken = builder.nextToken;
        this.tableOptimizerRuns = builder.tableOptimizerRuns;
    }

    public final String catalogId() {
        return this.catalogId;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final String tableName() {
        return this.tableName;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasTableOptimizerRuns() {
        return this.tableOptimizerRuns != null && !(this.tableOptimizerRuns instanceof SdkAutoConstructList);
    }

    public final List<TableOptimizerRun> tableOptimizerRuns() {
        return this.tableOptimizerRuns;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogId());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTableOptimizerRuns() ? this.tableOptimizerRuns() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTableOptimizerRunsResponse)) {
            return false;
        }
        ListTableOptimizerRunsResponse other = (ListTableOptimizerRunsResponse)((Object)obj);
        return Objects.equals(this.catalogId(), other.catalogId()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.tableName(), other.tableName()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasTableOptimizerRuns() == other.hasTableOptimizerRuns() && Objects.equals(this.tableOptimizerRuns(), other.tableOptimizerRuns());
    }

    public final String toString() {
        return ToString.builder((String)"ListTableOptimizerRunsResponse").add("CatalogId", (Object)this.catalogId()).add("DatabaseName", (Object)this.databaseName()).add("TableName", (Object)this.tableName()).add("NextToken", (Object)this.nextToken()).add("TableOptimizerRuns", this.hasTableOptimizerRuns() ? this.tableOptimizerRuns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CatalogId": {
                return Optional.ofNullable(clazz.cast(this.catalogId()));
            }
            case "DatabaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "TableName": {
                return Optional.ofNullable(clazz.cast(this.tableName()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "TableOptimizerRuns": {
                return Optional.ofNullable(clazz.cast(this.tableOptimizerRuns()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTableOptimizerRunsResponse, T> g) {
        return obj -> g.apply((ListTableOptimizerRunsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueResponse.BuilderImpl
    implements Builder {
        private String catalogId;
        private String databaseName;
        private String tableName;
        private String nextToken;
        private List<TableOptimizerRun> tableOptimizerRuns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListTableOptimizerRunsResponse model) {
            super(model);
            this.catalogId(model.catalogId);
            this.databaseName(model.databaseName);
            this.tableName(model.tableName);
            this.nextToken(model.nextToken);
            this.tableOptimizerRuns(model.tableOptimizerRuns);
        }

        public final String getCatalogId() {
            return this.catalogId;
        }

        public final void setCatalogId(String catalogId) {
            this.catalogId = catalogId;
        }

        @Override
        public final Builder catalogId(String catalogId) {
            this.catalogId = catalogId;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final String getTableName() {
            return this.tableName;
        }

        public final void setTableName(String tableName) {
            this.tableName = tableName;
        }

        @Override
        public final Builder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<TableOptimizerRun.Builder> getTableOptimizerRuns() {
            List<TableOptimizerRun.Builder> result = TableOptimizerRunsCopier.copyToBuilder(this.tableOptimizerRuns);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTableOptimizerRuns(Collection<TableOptimizerRun.BuilderImpl> tableOptimizerRuns) {
            this.tableOptimizerRuns = TableOptimizerRunsCopier.copyFromBuilder(tableOptimizerRuns);
        }

        @Override
        public final Builder tableOptimizerRuns(Collection<TableOptimizerRun> tableOptimizerRuns) {
            this.tableOptimizerRuns = TableOptimizerRunsCopier.copy(tableOptimizerRuns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableOptimizerRuns(TableOptimizerRun ... tableOptimizerRuns) {
            this.tableOptimizerRuns(Arrays.asList(tableOptimizerRuns));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tableOptimizerRuns(Consumer<TableOptimizerRun.Builder> ... tableOptimizerRuns) {
            this.tableOptimizerRuns(Stream.of(tableOptimizerRuns).map(c -> (TableOptimizerRun)((TableOptimizerRun.Builder)TableOptimizerRun.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListTableOptimizerRunsResponse build() {
            return new ListTableOptimizerRunsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTableOptimizerRunsResponse> {
        public Builder catalogId(String var1);

        public Builder databaseName(String var1);

        public Builder tableName(String var1);

        public Builder nextToken(String var1);

        public Builder tableOptimizerRuns(Collection<TableOptimizerRun> var1);

        public Builder tableOptimizerRuns(TableOptimizerRun ... var1);

        public Builder tableOptimizerRuns(Consumer<TableOptimizerRun.Builder> ... var1);
    }
}

