/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class WorkflowRunsCopier {
    static List<WorkflowRun> copy(Collection<? extends WorkflowRun> workflowRunsParam) {
        List<WorkflowRun> list;
        if (workflowRunsParam == null || workflowRunsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<WorkflowRun> modifiableList = new ArrayList<>(workflowRunsParam.size());
            workflowRunsParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<WorkflowRun> copyFromBuilder(Collection<? extends WorkflowRun.Builder> workflowRunsParam) {
        List<WorkflowRun> list;
        if (workflowRunsParam == null || workflowRunsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<WorkflowRun> modifiableList = new ArrayList<>(workflowRunsParam.size());
            workflowRunsParam.forEach(entry -> {
                WorkflowRun member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<WorkflowRun.Builder> copyToBuilder(Collection<? extends WorkflowRun> workflowRunsParam) {
        List<WorkflowRun.Builder> list;
        if (workflowRunsParam == null || workflowRunsParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<WorkflowRun.Builder> modifiableList = new ArrayList<>(workflowRunsParam.size());
            workflowRunsParam.forEach(entry -> {
                WorkflowRun.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
