/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A Glue Studio node that uses a Glue DataBrew recipe in Glue jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Recipe implements SdkPojo, Serializable, ToCopyableBuilder<Recipe.Builder, Recipe> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Recipe::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<List<String>> INPUTS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("Inputs")
            .getter(getter(Recipe::inputs))
            .setter(setter(Builder::inputs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Inputs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<RecipeReference> RECIPE_REFERENCE_FIELD = SdkField
            .<RecipeReference> builder(MarshallingType.SDK_POJO).memberName("RecipeReference")
            .getter(getter(Recipe::recipeReference)).setter(setter(Builder::recipeReference))
            .constructor(RecipeReference::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeReference").build()).build();

    private static final SdkField<List<RecipeStep>> RECIPE_STEPS_FIELD = SdkField
            .<List<RecipeStep>> builder(MarshallingType.LIST)
            .memberName("RecipeSteps")
            .getter(getter(Recipe::recipeSteps))
            .setter(setter(Builder::recipeSteps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RecipeSteps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RecipeStep> builder(MarshallingType.SDK_POJO)
                                            .constructor(RecipeStep::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, INPUTS_FIELD,
            RECIPE_REFERENCE_FIELD, RECIPE_STEPS_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final List<String> inputs;

    private final RecipeReference recipeReference;

    private final List<RecipeStep> recipeSteps;

    private Recipe(BuilderImpl builder) {
        this.name = builder.name;
        this.inputs = builder.inputs;
        this.recipeReference = builder.recipeReference;
        this.recipeSteps = builder.recipeSteps;
    }

    /**
     * <p>
     * The name of the Glue Studio node.
     * </p>
     * 
     * @return The name of the Glue Studio node.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Inputs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInputs() {
        return inputs != null && !(inputs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The nodes that are inputs to the recipe node, identified by id.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInputs} method.
     * </p>
     * 
     * @return The nodes that are inputs to the recipe node, identified by id.
     */
    public final List<String> inputs() {
        return inputs;
    }

    /**
     * <p>
     * A reference to the DataBrew recipe used by the node.
     * </p>
     * 
     * @return A reference to the DataBrew recipe used by the node.
     */
    public final RecipeReference recipeReference() {
        return recipeReference;
    }

    /**
     * For responses, this returns true if the service returned a value for the RecipeSteps property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasRecipeSteps() {
        return recipeSteps != null && !(recipeSteps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Transform steps used in the recipe node.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRecipeSteps} method.
     * </p>
     * 
     * @return Transform steps used in the recipe node.
     */
    public final List<RecipeStep> recipeSteps() {
        return recipeSteps;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasInputs() ? inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recipeReference());
        hashCode = 31 * hashCode + Objects.hashCode(hasRecipeSteps() ? recipeSteps() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Recipe)) {
            return false;
        }
        Recipe other = (Recipe) obj;
        return Objects.equals(name(), other.name()) && hasInputs() == other.hasInputs()
                && Objects.equals(inputs(), other.inputs()) && Objects.equals(recipeReference(), other.recipeReference())
                && hasRecipeSteps() == other.hasRecipeSteps() && Objects.equals(recipeSteps(), other.recipeSteps());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Recipe").add("Name", name()).add("Inputs", hasInputs() ? inputs() : null)
                .add("RecipeReference", recipeReference()).add("RecipeSteps", hasRecipeSteps() ? recipeSteps() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Inputs":
            return Optional.ofNullable(clazz.cast(inputs()));
        case "RecipeReference":
            return Optional.ofNullable(clazz.cast(recipeReference()));
        case "RecipeSteps":
            return Optional.ofNullable(clazz.cast(recipeSteps()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Recipe, T> g) {
        return obj -> g.apply((Recipe) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Recipe> {
        /**
         * <p>
         * The name of the Glue Studio node.
         * </p>
         * 
         * @param name
         *        The name of the Glue Studio node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The nodes that are inputs to the recipe node, identified by id.
         * </p>
         * 
         * @param inputs
         *        The nodes that are inputs to the recipe node, identified by id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(Collection<String> inputs);

        /**
         * <p>
         * The nodes that are inputs to the recipe node, identified by id.
         * </p>
         * 
         * @param inputs
         *        The nodes that are inputs to the recipe node, identified by id.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputs(String... inputs);

        /**
         * <p>
         * A reference to the DataBrew recipe used by the node.
         * </p>
         * 
         * @param recipeReference
         *        A reference to the DataBrew recipe used by the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeReference(RecipeReference recipeReference);

        /**
         * <p>
         * A reference to the DataBrew recipe used by the node.
         * </p>
         * This is a convenience method that creates an instance of the {@link RecipeReference.Builder} avoiding the
         * need to create one manually via {@link RecipeReference#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RecipeReference.Builder#build()} is called immediately and its
         * result is passed to {@link #recipeReference(RecipeReference)}.
         * 
         * @param recipeReference
         *        a consumer that will call methods on {@link RecipeReference.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recipeReference(RecipeReference)
         */
        default Builder recipeReference(Consumer<RecipeReference.Builder> recipeReference) {
            return recipeReference(RecipeReference.builder().applyMutation(recipeReference).build());
        }

        /**
         * <p>
         * Transform steps used in the recipe node.
         * </p>
         * 
         * @param recipeSteps
         *        Transform steps used in the recipe node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeSteps(Collection<RecipeStep> recipeSteps);

        /**
         * <p>
         * Transform steps used in the recipe node.
         * </p>
         * 
         * @param recipeSteps
         *        Transform steps used in the recipe node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recipeSteps(RecipeStep... recipeSteps);

        /**
         * <p>
         * Transform steps used in the recipe node.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.glue.model.RecipeStep.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.glue.model.RecipeStep#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.glue.model.RecipeStep.Builder#build()} is called immediately and its
         * result is passed to {@link #recipeSteps(List<RecipeStep>)}.
         * 
         * @param recipeSteps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.glue.model.RecipeStep.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #recipeSteps(java.util.Collection<RecipeStep>)
         */
        Builder recipeSteps(Consumer<RecipeStep.Builder>... recipeSteps);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private List<String> inputs = DefaultSdkAutoConstructList.getInstance();

        private RecipeReference recipeReference;

        private List<RecipeStep> recipeSteps = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Recipe model) {
            name(model.name);
            inputs(model.inputs);
            recipeReference(model.recipeReference);
            recipeSteps(model.recipeSteps);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getInputs() {
            if (inputs instanceof SdkAutoConstructList) {
                return null;
            }
            return inputs;
        }

        public final void setInputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
        }

        @Override
        public final Builder inputs(Collection<String> inputs) {
            this.inputs = OneInputCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(String... inputs) {
            inputs(Arrays.asList(inputs));
            return this;
        }

        public final RecipeReference.Builder getRecipeReference() {
            return recipeReference != null ? recipeReference.toBuilder() : null;
        }

        public final void setRecipeReference(RecipeReference.BuilderImpl recipeReference) {
            this.recipeReference = recipeReference != null ? recipeReference.build() : null;
        }

        @Override
        public final Builder recipeReference(RecipeReference recipeReference) {
            this.recipeReference = recipeReference;
            return this;
        }

        public final List<RecipeStep.Builder> getRecipeSteps() {
            List<RecipeStep.Builder> result = RecipeStepsCopier.copyToBuilder(this.recipeSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRecipeSteps(Collection<RecipeStep.BuilderImpl> recipeSteps) {
            this.recipeSteps = RecipeStepsCopier.copyFromBuilder(recipeSteps);
        }

        @Override
        public final Builder recipeSteps(Collection<RecipeStep> recipeSteps) {
            this.recipeSteps = RecipeStepsCopier.copy(recipeSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipeSteps(RecipeStep... recipeSteps) {
            recipeSteps(Arrays.asList(recipeSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder recipeSteps(Consumer<RecipeStep.Builder>... recipeSteps) {
            recipeSteps(Stream.of(recipeSteps).map(c -> RecipeStep.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public Recipe build() {
            return new Recipe(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
