/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Snapshot retention metrics for Iceberg for the optimizer run.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergRetentionMetrics implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergRetentionMetrics.Builder, IcebergRetentionMetrics> {
    private static final SdkField<Long> NUMBER_OF_DATA_FILES_DELETED_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfDataFilesDeleted").getter(getter(IcebergRetentionMetrics::numberOfDataFilesDeleted))
            .setter(setter(Builder::numberOfDataFilesDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDataFilesDeleted").build())
            .build();

    private static final SdkField<Long> NUMBER_OF_MANIFEST_FILES_DELETED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfManifestFilesDeleted")
            .getter(getter(IcebergRetentionMetrics::numberOfManifestFilesDeleted))
            .setter(setter(Builder::numberOfManifestFilesDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfManifestFilesDeleted")
                    .build()).build();

    private static final SdkField<Long> NUMBER_OF_MANIFEST_LISTS_DELETED_FIELD = SdkField
            .<Long> builder(MarshallingType.LONG)
            .memberName("NumberOfManifestListsDeleted")
            .getter(getter(IcebergRetentionMetrics::numberOfManifestListsDeleted))
            .setter(setter(Builder::numberOfManifestListsDeleted))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfManifestListsDeleted")
                    .build()).build();

    private static final SdkField<Integer> NUMBER_OF_DPUS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("NumberOfDpus").getter(getter(IcebergRetentionMetrics::numberOfDpus))
            .setter(setter(Builder::numberOfDpus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfDpus").build()).build();

    private static final SdkField<Double> JOB_DURATION_IN_HOUR_FIELD = SdkField.<Double> builder(MarshallingType.DOUBLE)
            .memberName("JobDurationInHour").getter(getter(IcebergRetentionMetrics::jobDurationInHour))
            .setter(setter(Builder::jobDurationInHour))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobDurationInHour").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            NUMBER_OF_DATA_FILES_DELETED_FIELD, NUMBER_OF_MANIFEST_FILES_DELETED_FIELD, NUMBER_OF_MANIFEST_LISTS_DELETED_FIELD,
            NUMBER_OF_DPUS_FIELD, JOB_DURATION_IN_HOUR_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long numberOfDataFilesDeleted;

    private final Long numberOfManifestFilesDeleted;

    private final Long numberOfManifestListsDeleted;

    private final Integer numberOfDpus;

    private final Double jobDurationInHour;

    private IcebergRetentionMetrics(BuilderImpl builder) {
        this.numberOfDataFilesDeleted = builder.numberOfDataFilesDeleted;
        this.numberOfManifestFilesDeleted = builder.numberOfManifestFilesDeleted;
        this.numberOfManifestListsDeleted = builder.numberOfManifestListsDeleted;
        this.numberOfDpus = builder.numberOfDpus;
        this.jobDurationInHour = builder.jobDurationInHour;
    }

    /**
     * <p>
     * The number of data files deleted by the retention job run.
     * </p>
     * 
     * @return The number of data files deleted by the retention job run.
     */
    public final Long numberOfDataFilesDeleted() {
        return numberOfDataFilesDeleted;
    }

    /**
     * <p>
     * The number of manifest files deleted by the retention job run.
     * </p>
     * 
     * @return The number of manifest files deleted by the retention job run.
     */
    public final Long numberOfManifestFilesDeleted() {
        return numberOfManifestFilesDeleted;
    }

    /**
     * <p>
     * The number of manifest lists deleted by the retention job run.
     * </p>
     * 
     * @return The number of manifest lists deleted by the retention job run.
     */
    public final Long numberOfManifestListsDeleted() {
        return numberOfManifestListsDeleted;
    }

    /**
     * <p>
     * The number of DPU hours consumed by the job.
     * </p>
     * 
     * @return The number of DPU hours consumed by the job.
     */
    public final Integer numberOfDpus() {
        return numberOfDpus;
    }

    /**
     * <p>
     * The duration of the job in hours.
     * </p>
     * 
     * @return The duration of the job in hours.
     */
    public final Double jobDurationInHour() {
        return jobDurationInHour;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDataFilesDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfManifestFilesDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfManifestListsDeleted());
        hashCode = 31 * hashCode + Objects.hashCode(numberOfDpus());
        hashCode = 31 * hashCode + Objects.hashCode(jobDurationInHour());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergRetentionMetrics)) {
            return false;
        }
        IcebergRetentionMetrics other = (IcebergRetentionMetrics) obj;
        return Objects.equals(numberOfDataFilesDeleted(), other.numberOfDataFilesDeleted())
                && Objects.equals(numberOfManifestFilesDeleted(), other.numberOfManifestFilesDeleted())
                && Objects.equals(numberOfManifestListsDeleted(), other.numberOfManifestListsDeleted())
                && Objects.equals(numberOfDpus(), other.numberOfDpus())
                && Objects.equals(jobDurationInHour(), other.jobDurationInHour());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergRetentionMetrics").add("NumberOfDataFilesDeleted", numberOfDataFilesDeleted())
                .add("NumberOfManifestFilesDeleted", numberOfManifestFilesDeleted())
                .add("NumberOfManifestListsDeleted", numberOfManifestListsDeleted()).add("NumberOfDpus", numberOfDpus())
                .add("JobDurationInHour", jobDurationInHour()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NumberOfDataFilesDeleted":
            return Optional.ofNullable(clazz.cast(numberOfDataFilesDeleted()));
        case "NumberOfManifestFilesDeleted":
            return Optional.ofNullable(clazz.cast(numberOfManifestFilesDeleted()));
        case "NumberOfManifestListsDeleted":
            return Optional.ofNullable(clazz.cast(numberOfManifestListsDeleted()));
        case "NumberOfDpus":
            return Optional.ofNullable(clazz.cast(numberOfDpus()));
        case "JobDurationInHour":
            return Optional.ofNullable(clazz.cast(jobDurationInHour()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IcebergRetentionMetrics, T> g) {
        return obj -> g.apply((IcebergRetentionMetrics) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergRetentionMetrics> {
        /**
         * <p>
         * The number of data files deleted by the retention job run.
         * </p>
         * 
         * @param numberOfDataFilesDeleted
         *        The number of data files deleted by the retention job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDataFilesDeleted(Long numberOfDataFilesDeleted);

        /**
         * <p>
         * The number of manifest files deleted by the retention job run.
         * </p>
         * 
         * @param numberOfManifestFilesDeleted
         *        The number of manifest files deleted by the retention job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfManifestFilesDeleted(Long numberOfManifestFilesDeleted);

        /**
         * <p>
         * The number of manifest lists deleted by the retention job run.
         * </p>
         * 
         * @param numberOfManifestListsDeleted
         *        The number of manifest lists deleted by the retention job run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfManifestListsDeleted(Long numberOfManifestListsDeleted);

        /**
         * <p>
         * The number of DPU hours consumed by the job.
         * </p>
         * 
         * @param numberOfDpus
         *        The number of DPU hours consumed by the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder numberOfDpus(Integer numberOfDpus);

        /**
         * <p>
         * The duration of the job in hours.
         * </p>
         * 
         * @param jobDurationInHour
         *        The duration of the job in hours.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobDurationInHour(Double jobDurationInHour);
    }

    static final class BuilderImpl implements Builder {
        private Long numberOfDataFilesDeleted;

        private Long numberOfManifestFilesDeleted;

        private Long numberOfManifestListsDeleted;

        private Integer numberOfDpus;

        private Double jobDurationInHour;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergRetentionMetrics model) {
            numberOfDataFilesDeleted(model.numberOfDataFilesDeleted);
            numberOfManifestFilesDeleted(model.numberOfManifestFilesDeleted);
            numberOfManifestListsDeleted(model.numberOfManifestListsDeleted);
            numberOfDpus(model.numberOfDpus);
            jobDurationInHour(model.jobDurationInHour);
        }

        public final Long getNumberOfDataFilesDeleted() {
            return numberOfDataFilesDeleted;
        }

        public final void setNumberOfDataFilesDeleted(Long numberOfDataFilesDeleted) {
            this.numberOfDataFilesDeleted = numberOfDataFilesDeleted;
        }

        @Override
        public final Builder numberOfDataFilesDeleted(Long numberOfDataFilesDeleted) {
            this.numberOfDataFilesDeleted = numberOfDataFilesDeleted;
            return this;
        }

        public final Long getNumberOfManifestFilesDeleted() {
            return numberOfManifestFilesDeleted;
        }

        public final void setNumberOfManifestFilesDeleted(Long numberOfManifestFilesDeleted) {
            this.numberOfManifestFilesDeleted = numberOfManifestFilesDeleted;
        }

        @Override
        public final Builder numberOfManifestFilesDeleted(Long numberOfManifestFilesDeleted) {
            this.numberOfManifestFilesDeleted = numberOfManifestFilesDeleted;
            return this;
        }

        public final Long getNumberOfManifestListsDeleted() {
            return numberOfManifestListsDeleted;
        }

        public final void setNumberOfManifestListsDeleted(Long numberOfManifestListsDeleted) {
            this.numberOfManifestListsDeleted = numberOfManifestListsDeleted;
        }

        @Override
        public final Builder numberOfManifestListsDeleted(Long numberOfManifestListsDeleted) {
            this.numberOfManifestListsDeleted = numberOfManifestListsDeleted;
            return this;
        }

        public final Integer getNumberOfDpus() {
            return numberOfDpus;
        }

        public final void setNumberOfDpus(Integer numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
        }

        @Override
        public final Builder numberOfDpus(Integer numberOfDpus) {
            this.numberOfDpus = numberOfDpus;
            return this;
        }

        public final Double getJobDurationInHour() {
            return jobDurationInHour;
        }

        public final void setJobDurationInHour(Double jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
        }

        @Override
        public final Builder jobDurationInHour(Double jobDurationInHour) {
            this.jobDurationInHour = jobDurationInHour;
            return this;
        }

        @Override
        public IcebergRetentionMetrics build() {
            return new IcebergRetentionMetrics(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
