/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration for an Iceberg orphan file deletion optimizer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class IcebergOrphanFileDeletionConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<IcebergOrphanFileDeletionConfiguration.Builder, IcebergOrphanFileDeletionConfiguration> {
    private static final SdkField<Integer> ORPHAN_FILE_RETENTION_PERIOD_IN_DAYS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("orphanFileRetentionPeriodInDays")
            .getter(getter(IcebergOrphanFileDeletionConfiguration::orphanFileRetentionPeriodInDays))
            .setter(setter(Builder::orphanFileRetentionPeriodInDays))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orphanFileRetentionPeriodInDays")
                    .build()).build();

    private static final SdkField<String> LOCATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("location").getter(getter(IcebergOrphanFileDeletionConfiguration::location))
            .setter(setter(Builder::location))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            ORPHAN_FILE_RETENTION_PERIOD_IN_DAYS_FIELD, LOCATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer orphanFileRetentionPeriodInDays;

    private final String location;

    private IcebergOrphanFileDeletionConfiguration(BuilderImpl builder) {
        this.orphanFileRetentionPeriodInDays = builder.orphanFileRetentionPeriodInDays;
        this.location = builder.location;
    }

    /**
     * <p>
     * The number of days that orphan files should be retained before file deletion. If an input is not provided, the
     * default value 3 will be used.
     * </p>
     * 
     * @return The number of days that orphan files should be retained before file deletion. If an input is not
     *         provided, the default value 3 will be used.
     */
    public final Integer orphanFileRetentionPeriodInDays() {
        return orphanFileRetentionPeriodInDays;
    }

    /**
     * <p>
     * Specifies a directory in which to look for files (defaults to the table's location). You may choose a
     * sub-directory rather than the top-level table location.
     * </p>
     * 
     * @return Specifies a directory in which to look for files (defaults to the table's location). You may choose a
     *         sub-directory rather than the top-level table location.
     */
    public final String location() {
        return location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(orphanFileRetentionPeriodInDays());
        hashCode = 31 * hashCode + Objects.hashCode(location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IcebergOrphanFileDeletionConfiguration)) {
            return false;
        }
        IcebergOrphanFileDeletionConfiguration other = (IcebergOrphanFileDeletionConfiguration) obj;
        return Objects.equals(orphanFileRetentionPeriodInDays(), other.orphanFileRetentionPeriodInDays())
                && Objects.equals(location(), other.location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("IcebergOrphanFileDeletionConfiguration")
                .add("OrphanFileRetentionPeriodInDays", orphanFileRetentionPeriodInDays()).add("Location", location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "orphanFileRetentionPeriodInDays":
            return Optional.ofNullable(clazz.cast(orphanFileRetentionPeriodInDays()));
        case "location":
            return Optional.ofNullable(clazz.cast(location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<IcebergOrphanFileDeletionConfiguration, T> g) {
        return obj -> g.apply((IcebergOrphanFileDeletionConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, IcebergOrphanFileDeletionConfiguration> {
        /**
         * <p>
         * The number of days that orphan files should be retained before file deletion. If an input is not provided,
         * the default value 3 will be used.
         * </p>
         * 
         * @param orphanFileRetentionPeriodInDays
         *        The number of days that orphan files should be retained before file deletion. If an input is not
         *        provided, the default value 3 will be used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder orphanFileRetentionPeriodInDays(Integer orphanFileRetentionPeriodInDays);

        /**
         * <p>
         * Specifies a directory in which to look for files (defaults to the table's location). You may choose a
         * sub-directory rather than the top-level table location.
         * </p>
         * 
         * @param location
         *        Specifies a directory in which to look for files (defaults to the table's location). You may choose a
         *        sub-directory rather than the top-level table location.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder location(String location);
    }

    static final class BuilderImpl implements Builder {
        private Integer orphanFileRetentionPeriodInDays;

        private String location;

        private BuilderImpl() {
        }

        private BuilderImpl(IcebergOrphanFileDeletionConfiguration model) {
            orphanFileRetentionPeriodInDays(model.orphanFileRetentionPeriodInDays);
            location(model.location);
        }

        public final Integer getOrphanFileRetentionPeriodInDays() {
            return orphanFileRetentionPeriodInDays;
        }

        public final void setOrphanFileRetentionPeriodInDays(Integer orphanFileRetentionPeriodInDays) {
            this.orphanFileRetentionPeriodInDays = orphanFileRetentionPeriodInDays;
        }

        @Override
        public final Builder orphanFileRetentionPeriodInDays(Integer orphanFileRetentionPeriodInDays) {
            this.orphanFileRetentionPeriodInDays = orphanFileRetentionPeriodInDays;
            return this;
        }

        public final String getLocation() {
            return location;
        }

        public final void setLocation(String location) {
            this.location = location;
        }

        @Override
        public final Builder location(String location) {
            this.location = location;
            return this;
        }

        @Override
        public IcebergOrphanFileDeletionConfiguration build() {
            return new IcebergOrphanFileDeletionConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
