/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetColumnStatisticsTaskRunRequest extends GlueRequest implements
        ToCopyableBuilder<GetColumnStatisticsTaskRunRequest.Builder, GetColumnStatisticsTaskRunRequest> {
    private static final SdkField<String> COLUMN_STATISTICS_TASK_RUN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ColumnStatisticsTaskRunId").getter(getter(GetColumnStatisticsTaskRunRequest::columnStatisticsTaskRunId))
            .setter(setter(Builder::columnStatisticsTaskRunId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ColumnStatisticsTaskRunId").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(COLUMN_STATISTICS_TASK_RUN_ID_FIELD));

    private final String columnStatisticsTaskRunId;

    private GetColumnStatisticsTaskRunRequest(BuilderImpl builder) {
        super(builder);
        this.columnStatisticsTaskRunId = builder.columnStatisticsTaskRunId;
    }

    /**
     * <p>
     * The identifier for the particular column statistics task run.
     * </p>
     * 
     * @return The identifier for the particular column statistics task run.
     */
    public final String columnStatisticsTaskRunId() {
        return columnStatisticsTaskRunId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(columnStatisticsTaskRunId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetColumnStatisticsTaskRunRequest)) {
            return false;
        }
        GetColumnStatisticsTaskRunRequest other = (GetColumnStatisticsTaskRunRequest) obj;
        return Objects.equals(columnStatisticsTaskRunId(), other.columnStatisticsTaskRunId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetColumnStatisticsTaskRunRequest")
                .add("ColumnStatisticsTaskRunId", columnStatisticsTaskRunId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ColumnStatisticsTaskRunId":
            return Optional.ofNullable(clazz.cast(columnStatisticsTaskRunId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetColumnStatisticsTaskRunRequest, T> g) {
        return obj -> g.apply((GetColumnStatisticsTaskRunRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends GlueRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetColumnStatisticsTaskRunRequest> {
        /**
         * <p>
         * The identifier for the particular column statistics task run.
         * </p>
         * 
         * @param columnStatisticsTaskRunId
         *        The identifier for the particular column statistics task run.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder columnStatisticsTaskRunId(String columnStatisticsTaskRunId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends GlueRequest.BuilderImpl implements Builder {
        private String columnStatisticsTaskRunId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetColumnStatisticsTaskRunRequest model) {
            super(model);
            columnStatisticsTaskRunId(model.columnStatisticsTaskRunId);
        }

        public final String getColumnStatisticsTaskRunId() {
            return columnStatisticsTaskRunId;
        }

        public final void setColumnStatisticsTaskRunId(String columnStatisticsTaskRunId) {
            this.columnStatisticsTaskRunId = columnStatisticsTaskRunId;
        }

        @Override
        public final Builder columnStatisticsTaskRunId(String columnStatisticsTaskRunId) {
            this.columnStatisticsTaskRunId = columnStatisticsTaskRunId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetColumnStatisticsTaskRunRequest build() {
            return new GetColumnStatisticsTaskRunRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
