/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Condition expression defined in the Glue Studio data preparation recipe node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConditionExpression implements SdkPojo, Serializable,
        ToCopyableBuilder<ConditionExpression.Builder, ConditionExpression> {
    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Condition").getter(getter(ConditionExpression::condition)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Condition").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Value")
            .getter(getter(ConditionExpression::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Value").build()).build();

    private static final SdkField<String> TARGET_COLUMN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TargetColumn").getter(getter(ConditionExpression::targetColumn)).setter(setter(Builder::targetColumn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TargetColumn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONDITION_FIELD, VALUE_FIELD,
            TARGET_COLUMN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String condition;

    private final String value;

    private final String targetColumn;

    private ConditionExpression(BuilderImpl builder) {
        this.condition = builder.condition;
        this.value = builder.value;
        this.targetColumn = builder.targetColumn;
    }

    /**
     * <p>
     * The condition of the condition expression.
     * </p>
     * 
     * @return The condition of the condition expression.
     */
    public final String condition() {
        return condition;
    }

    /**
     * <p>
     * The value of the condition expression.
     * </p>
     * 
     * @return The value of the condition expression.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The target column of the condition expressions.
     * </p>
     * 
     * @return The target column of the condition expressions.
     */
    public final String targetColumn() {
        return targetColumn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(condition());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(targetColumn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConditionExpression)) {
            return false;
        }
        ConditionExpression other = (ConditionExpression) obj;
        return Objects.equals(condition(), other.condition()) && Objects.equals(value(), other.value())
                && Objects.equals(targetColumn(), other.targetColumn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConditionExpression").add("Condition", condition()).add("Value", value())
                .add("TargetColumn", targetColumn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Condition":
            return Optional.ofNullable(clazz.cast(condition()));
        case "Value":
            return Optional.ofNullable(clazz.cast(value()));
        case "TargetColumn":
            return Optional.ofNullable(clazz.cast(targetColumn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConditionExpression, T> g) {
        return obj -> g.apply((ConditionExpression) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConditionExpression> {
        /**
         * <p>
         * The condition of the condition expression.
         * </p>
         * 
         * @param condition
         *        The condition of the condition expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder condition(String condition);

        /**
         * <p>
         * The value of the condition expression.
         * </p>
         * 
         * @param value
         *        The value of the condition expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The target column of the condition expressions.
         * </p>
         * 
         * @param targetColumn
         *        The target column of the condition expressions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetColumn(String targetColumn);
    }

    static final class BuilderImpl implements Builder {
        private String condition;

        private String value;

        private String targetColumn;

        private BuilderImpl() {
        }

        private BuilderImpl(ConditionExpression model) {
            condition(model.condition);
            value(model.value);
            targetColumn(model.targetColumn);
        }

        public final String getCondition() {
            return condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getTargetColumn() {
            return targetColumn;
        }

        public final void setTargetColumn(String targetColumn) {
            this.targetColumn = targetColumn;
        }

        @Override
        public final Builder targetColumn(String targetColumn) {
            this.targetColumn = targetColumn;
            return this;
        }

        @Override
        public ConditionExpression build() {
            return new ConditionExpression(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
