/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies an Amazon Redshift source.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AmazonRedshiftSource implements SdkPojo, Serializable,
        ToCopyableBuilder<AmazonRedshiftSource.Builder, AmazonRedshiftSource> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(AmazonRedshiftSource::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<AmazonRedshiftNodeData> DATA_FIELD = SdkField
            .<AmazonRedshiftNodeData> builder(MarshallingType.SDK_POJO).memberName("Data")
            .getter(getter(AmazonRedshiftSource::data)).setter(setter(Builder::data))
            .constructor(AmazonRedshiftNodeData::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Data").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final AmazonRedshiftNodeData data;

    private AmazonRedshiftSource(BuilderImpl builder) {
        this.name = builder.name;
        this.data = builder.data;
    }

    /**
     * <p>
     * The name of the Amazon Redshift source.
     * </p>
     * 
     * @return The name of the Amazon Redshift source.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * Specifies the data of the Amazon Reshift source node.
     * </p>
     * 
     * @return Specifies the data of the Amazon Reshift source node.
     */
    public final AmazonRedshiftNodeData data() {
        return data;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(data());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AmazonRedshiftSource)) {
            return false;
        }
        AmazonRedshiftSource other = (AmazonRedshiftSource) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(data(), other.data());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AmazonRedshiftSource").add("Name", name()).add("Data", data()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Data":
            return Optional.ofNullable(clazz.cast(data()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AmazonRedshiftSource, T> g) {
        return obj -> g.apply((AmazonRedshiftSource) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AmazonRedshiftSource> {
        /**
         * <p>
         * The name of the Amazon Redshift source.
         * </p>
         * 
         * @param name
         *        The name of the Amazon Redshift source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * Specifies the data of the Amazon Reshift source node.
         * </p>
         * 
         * @param data
         *        Specifies the data of the Amazon Reshift source node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder data(AmazonRedshiftNodeData data);

        /**
         * <p>
         * Specifies the data of the Amazon Reshift source node.
         * </p>
         * This is a convenience method that creates an instance of the {@link AmazonRedshiftNodeData.Builder} avoiding
         * the need to create one manually via {@link AmazonRedshiftNodeData#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AmazonRedshiftNodeData.Builder#build()} is called immediately and
         * its result is passed to {@link #data(AmazonRedshiftNodeData)}.
         * 
         * @param data
         *        a consumer that will call methods on {@link AmazonRedshiftNodeData.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #data(AmazonRedshiftNodeData)
         */
        default Builder data(Consumer<AmazonRedshiftNodeData.Builder> data) {
            return data(AmazonRedshiftNodeData.builder().applyMutation(data).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private AmazonRedshiftNodeData data;

        private BuilderImpl() {
        }

        private BuilderImpl(AmazonRedshiftSource model) {
            name(model.name);
            data(model.data);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final AmazonRedshiftNodeData.Builder getData() {
            return data != null ? data.toBuilder() : null;
        }

        public final void setData(AmazonRedshiftNodeData.BuilderImpl data) {
            this.data = data != null ? data.build() : null;
        }

        @Override
        public final Builder data(AmazonRedshiftNodeData data) {
            this.data = data;
            return this;
        }

        @Override
        public AmazonRedshiftSource build() {
            return new AmazonRedshiftSource(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
