/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.DQCompositeRuleEvaluationMethod;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataQualityEvaluationRunAdditionalRunOptions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataQualityEvaluationRunAdditionalRunOptions> {
    private static final SdkField<Boolean> CLOUD_WATCH_METRICS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("CloudWatchMetricsEnabled").getter(DataQualityEvaluationRunAdditionalRunOptions.getter(DataQualityEvaluationRunAdditionalRunOptions::cloudWatchMetricsEnabled)).setter(DataQualityEvaluationRunAdditionalRunOptions.setter(Builder::cloudWatchMetricsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CloudWatchMetricsEnabled").build()}).build();
    private static final SdkField<String> RESULTS_S3_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ResultsS3Prefix").getter(DataQualityEvaluationRunAdditionalRunOptions.getter(DataQualityEvaluationRunAdditionalRunOptions::resultsS3Prefix)).setter(DataQualityEvaluationRunAdditionalRunOptions.setter(Builder::resultsS3Prefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ResultsS3Prefix").build()}).build();
    private static final SdkField<String> COMPOSITE_RULE_EVALUATION_METHOD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CompositeRuleEvaluationMethod").getter(DataQualityEvaluationRunAdditionalRunOptions.getter(DataQualityEvaluationRunAdditionalRunOptions::compositeRuleEvaluationMethodAsString)).setter(DataQualityEvaluationRunAdditionalRunOptions.setter(Builder::compositeRuleEvaluationMethod)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CompositeRuleEvaluationMethod").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_METRICS_ENABLED_FIELD, RESULTS_S3_PREFIX_FIELD, COMPOSITE_RULE_EVALUATION_METHOD_FIELD));
    private static final long serialVersionUID = 1L;
    private final Boolean cloudWatchMetricsEnabled;
    private final String resultsS3Prefix;
    private final String compositeRuleEvaluationMethod;

    private DataQualityEvaluationRunAdditionalRunOptions(BuilderImpl builder) {
        this.cloudWatchMetricsEnabled = builder.cloudWatchMetricsEnabled;
        this.resultsS3Prefix = builder.resultsS3Prefix;
        this.compositeRuleEvaluationMethod = builder.compositeRuleEvaluationMethod;
    }

    public final Boolean cloudWatchMetricsEnabled() {
        return this.cloudWatchMetricsEnabled;
    }

    public final String resultsS3Prefix() {
        return this.resultsS3Prefix;
    }

    public final DQCompositeRuleEvaluationMethod compositeRuleEvaluationMethod() {
        return DQCompositeRuleEvaluationMethod.fromValue(this.compositeRuleEvaluationMethod);
    }

    public final String compositeRuleEvaluationMethodAsString() {
        return this.compositeRuleEvaluationMethod;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchMetricsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultsS3Prefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.compositeRuleEvaluationMethodAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataQualityEvaluationRunAdditionalRunOptions)) {
            return false;
        }
        DataQualityEvaluationRunAdditionalRunOptions other = (DataQualityEvaluationRunAdditionalRunOptions)obj;
        return Objects.equals(this.cloudWatchMetricsEnabled(), other.cloudWatchMetricsEnabled()) && Objects.equals(this.resultsS3Prefix(), other.resultsS3Prefix()) && Objects.equals(this.compositeRuleEvaluationMethodAsString(), other.compositeRuleEvaluationMethodAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DataQualityEvaluationRunAdditionalRunOptions").add("CloudWatchMetricsEnabled", (Object)this.cloudWatchMetricsEnabled()).add("ResultsS3Prefix", (Object)this.resultsS3Prefix()).add("CompositeRuleEvaluationMethod", (Object)this.compositeRuleEvaluationMethodAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "CloudWatchMetricsEnabled": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchMetricsEnabled()));
            }
            case "ResultsS3Prefix": {
                return Optional.ofNullable(clazz.cast(this.resultsS3Prefix()));
            }
            case "CompositeRuleEvaluationMethod": {
                return Optional.ofNullable(clazz.cast(this.compositeRuleEvaluationMethodAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataQualityEvaluationRunAdditionalRunOptions, T> g) {
        return obj -> g.apply((DataQualityEvaluationRunAdditionalRunOptions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Boolean cloudWatchMetricsEnabled;
        private String resultsS3Prefix;
        private String compositeRuleEvaluationMethod;

        private BuilderImpl() {
        }

        private BuilderImpl(DataQualityEvaluationRunAdditionalRunOptions model) {
            this.cloudWatchMetricsEnabled(model.cloudWatchMetricsEnabled);
            this.resultsS3Prefix(model.resultsS3Prefix);
            this.compositeRuleEvaluationMethod(model.compositeRuleEvaluationMethod);
        }

        public final Boolean getCloudWatchMetricsEnabled() {
            return this.cloudWatchMetricsEnabled;
        }

        public final void setCloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
        }

        @Override
        public final Builder cloudWatchMetricsEnabled(Boolean cloudWatchMetricsEnabled) {
            this.cloudWatchMetricsEnabled = cloudWatchMetricsEnabled;
            return this;
        }

        public final String getResultsS3Prefix() {
            return this.resultsS3Prefix;
        }

        public final void setResultsS3Prefix(String resultsS3Prefix) {
            this.resultsS3Prefix = resultsS3Prefix;
        }

        @Override
        public final Builder resultsS3Prefix(String resultsS3Prefix) {
            this.resultsS3Prefix = resultsS3Prefix;
            return this;
        }

        public final String getCompositeRuleEvaluationMethod() {
            return this.compositeRuleEvaluationMethod;
        }

        public final void setCompositeRuleEvaluationMethod(String compositeRuleEvaluationMethod) {
            this.compositeRuleEvaluationMethod = compositeRuleEvaluationMethod;
        }

        @Override
        public final Builder compositeRuleEvaluationMethod(String compositeRuleEvaluationMethod) {
            this.compositeRuleEvaluationMethod = compositeRuleEvaluationMethod;
            return this;
        }

        @Override
        public final Builder compositeRuleEvaluationMethod(DQCompositeRuleEvaluationMethod compositeRuleEvaluationMethod) {
            this.compositeRuleEvaluationMethod(compositeRuleEvaluationMethod == null ? null : compositeRuleEvaluationMethod.toString());
            return this;
        }

        public DataQualityEvaluationRunAdditionalRunOptions build() {
            return new DataQualityEvaluationRunAdditionalRunOptions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataQualityEvaluationRunAdditionalRunOptions> {
        public Builder cloudWatchMetricsEnabled(Boolean var1);

        public Builder resultsS3Prefix(String var1);

        public Builder compositeRuleEvaluationMethod(String var1);

        public Builder compositeRuleEvaluationMethod(DQCompositeRuleEvaluationMethod var1);
    }
}

