/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.GenericMapCopier;
import software.amazon.awssdk.services.glue.model.NotificationProperty;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Action
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Action> {
    private static final SdkField<String> JOB_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("JobName").getter(Action.getter(Action::jobName)).setter(Action.setter(Builder::jobName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("JobName").build()}).build();
    private static final SdkField<Map<String, String>> ARGUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("Arguments").getter(Action.getter(Action::arguments)).setter(Action.setter(Builder::arguments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arguments").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Timeout").getter(Action.getter(Action::timeout)).setter(Action.setter(Builder::timeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Timeout").build()}).build();
    private static final SdkField<String> SECURITY_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SecurityConfiguration").getter(Action.getter(Action::securityConfiguration)).setter(Action.setter(Builder::securityConfiguration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityConfiguration").build()}).build();
    private static final SdkField<NotificationProperty> NOTIFICATION_PROPERTY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("NotificationProperty").getter(Action.getter(Action::notificationProperty)).setter(Action.setter(Builder::notificationProperty)).constructor(NotificationProperty::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NotificationProperty").build()}).build();
    private static final SdkField<String> CRAWLER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CrawlerName").getter(Action.getter(Action::crawlerName)).setter(Action.setter(Builder::crawlerName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CrawlerName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_NAME_FIELD, ARGUMENTS_FIELD, TIMEOUT_FIELD, SECURITY_CONFIGURATION_FIELD, NOTIFICATION_PROPERTY_FIELD, CRAWLER_NAME_FIELD));
    private static final long serialVersionUID = 1L;
    private final String jobName;
    private final Map<String, String> arguments;
    private final Integer timeout;
    private final String securityConfiguration;
    private final NotificationProperty notificationProperty;
    private final String crawlerName;

    private Action(BuilderImpl builder) {
        this.jobName = builder.jobName;
        this.arguments = builder.arguments;
        this.timeout = builder.timeout;
        this.securityConfiguration = builder.securityConfiguration;
        this.notificationProperty = builder.notificationProperty;
        this.crawlerName = builder.crawlerName;
    }

    public final String jobName() {
        return this.jobName;
    }

    public final boolean hasArguments() {
        return this.arguments != null && !(this.arguments instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> arguments() {
        return this.arguments;
    }

    public final Integer timeout() {
        return this.timeout;
    }

    public final String securityConfiguration() {
        return this.securityConfiguration;
    }

    public final NotificationProperty notificationProperty() {
        return this.notificationProperty;
    }

    public final String crawlerName() {
        return this.crawlerName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.jobName());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasArguments() ? this.arguments() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.securityConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.notificationProperty());
        hashCode = 31 * hashCode + Objects.hashCode(this.crawlerName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Action)) {
            return false;
        }
        Action other = (Action)obj;
        return Objects.equals(this.jobName(), other.jobName()) && this.hasArguments() == other.hasArguments() && Objects.equals(this.arguments(), other.arguments()) && Objects.equals(this.timeout(), other.timeout()) && Objects.equals(this.securityConfiguration(), other.securityConfiguration()) && Objects.equals(this.notificationProperty(), other.notificationProperty()) && Objects.equals(this.crawlerName(), other.crawlerName());
    }

    public final String toString() {
        return ToString.builder((String)"Action").add("JobName", (Object)this.jobName()).add("Arguments", this.hasArguments() ? this.arguments() : null).add("Timeout", (Object)this.timeout()).add("SecurityConfiguration", (Object)this.securityConfiguration()).add("NotificationProperty", (Object)this.notificationProperty()).add("CrawlerName", (Object)this.crawlerName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "JobName": {
                return Optional.ofNullable(clazz.cast(this.jobName()));
            }
            case "Arguments": {
                return Optional.ofNullable(clazz.cast(this.arguments()));
            }
            case "Timeout": {
                return Optional.ofNullable(clazz.cast(this.timeout()));
            }
            case "SecurityConfiguration": {
                return Optional.ofNullable(clazz.cast(this.securityConfiguration()));
            }
            case "NotificationProperty": {
                return Optional.ofNullable(clazz.cast(this.notificationProperty()));
            }
            case "CrawlerName": {
                return Optional.ofNullable(clazz.cast(this.crawlerName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Action, T> g) {
        return obj -> g.apply((Action)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String jobName;
        private Map<String, String> arguments = DefaultSdkAutoConstructMap.getInstance();
        private Integer timeout;
        private String securityConfiguration;
        private NotificationProperty notificationProperty;
        private String crawlerName;

        private BuilderImpl() {
        }

        private BuilderImpl(Action model) {
            this.jobName(model.jobName);
            this.arguments(model.arguments);
            this.timeout(model.timeout);
            this.securityConfiguration(model.securityConfiguration);
            this.notificationProperty(model.notificationProperty);
            this.crawlerName(model.crawlerName);
        }

        public final String getJobName() {
            return this.jobName;
        }

        public final void setJobName(String jobName) {
            this.jobName = jobName;
        }

        @Override
        public final Builder jobName(String jobName) {
            this.jobName = jobName;
            return this;
        }

        public final Map<String, String> getArguments() {
            if (this.arguments instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.arguments;
        }

        public final void setArguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
        }

        @Override
        public final Builder arguments(Map<String, String> arguments) {
            this.arguments = GenericMapCopier.copy(arguments);
            return this;
        }

        public final Integer getTimeout() {
            return this.timeout;
        }

        public final void setTimeout(Integer timeout) {
            this.timeout = timeout;
        }

        @Override
        public final Builder timeout(Integer timeout) {
            this.timeout = timeout;
            return this;
        }

        public final String getSecurityConfiguration() {
            return this.securityConfiguration;
        }

        public final void setSecurityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
        }

        @Override
        public final Builder securityConfiguration(String securityConfiguration) {
            this.securityConfiguration = securityConfiguration;
            return this;
        }

        public final NotificationProperty.Builder getNotificationProperty() {
            return this.notificationProperty != null ? this.notificationProperty.toBuilder() : null;
        }

        public final void setNotificationProperty(NotificationProperty.BuilderImpl notificationProperty) {
            this.notificationProperty = notificationProperty != null ? notificationProperty.build() : null;
        }

        @Override
        public final Builder notificationProperty(NotificationProperty notificationProperty) {
            this.notificationProperty = notificationProperty;
            return this;
        }

        public final String getCrawlerName() {
            return this.crawlerName;
        }

        public final void setCrawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
        }

        @Override
        public final Builder crawlerName(String crawlerName) {
            this.crawlerName = crawlerName;
            return this;
        }

        public Action build() {
            return new Action(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Action> {
        public Builder jobName(String var1);

        public Builder arguments(Map<String, String> var1);

        public Builder timeout(Integer var1);

        public Builder securityConfiguration(String var1);

        public Builder notificationProperty(NotificationProperty var1);

        default public Builder notificationProperty(Consumer<NotificationProperty.Builder> notificationProperty) {
            return this.notificationProperty((NotificationProperty)((NotificationProperty.Builder)NotificationProperty.builder().applyMutation(notificationProperty)).build());
        }

        public Builder crawlerName(String var1);
    }
}

