/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.paginators;

import java.util.Iterator;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.ListDataQualityResultsRequest;
import software.amazon.awssdk.services.glue.model.ListDataQualityResultsResponse;

public class ListDataQualityResultsIterable
implements SdkIterable<ListDataQualityResultsResponse> {
    private final GlueClient client;
    private final ListDataQualityResultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataQualityResultsIterable(GlueClient client, ListDataQualityResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListDataQualityResultsResponseFetcher();
    }

    public Iterator<ListDataQualityResultsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    private class ListDataQualityResultsResponseFetcher
    implements SyncPageFetcher<ListDataQualityResultsResponse> {
        private ListDataQualityResultsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataQualityResultsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataQualityResultsResponse nextPage(ListDataQualityResultsResponse previousPage) {
            if (previousPage == null) {
                return ListDataQualityResultsIterable.this.client.listDataQualityResults(ListDataQualityResultsIterable.this.firstRequest);
            }
            return ListDataQualityResultsIterable.this.client.listDataQualityResults((ListDataQualityResultsRequest)((Object)ListDataQualityResultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

