/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SourceControlProvider {
    GITHUB("GITHUB"),
    AWS_CODE_COMMIT("AWS_CODE_COMMIT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SourceControlProvider> VALUE_MAP;
    private final String value;

    private SourceControlProvider(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SourceControlProvider fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SourceControlProvider> knownValues() {
        EnumSet<SourceControlProvider> knownValues = EnumSet.allOf(SourceControlProvider.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SourceControlProvider.class, SourceControlProvider::toString);
    }
}

