/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.glue.model.OtherMetadataValueListCopier;
import software.amazon.awssdk.services.glue.model.OtherMetadataValueListItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MetadataInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, MetadataInfo> {
    private static final SdkField<String> METADATA_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MetadataValue").getter(MetadataInfo.getter(MetadataInfo::metadataValue)).setter(MetadataInfo.setter(Builder::metadataValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MetadataValue").build()}).build();
    private static final SdkField<String> CREATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("CreatedTime").getter(MetadataInfo.getter(MetadataInfo::createdTime)).setter(MetadataInfo.setter(Builder::createdTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()}).build();
    private static final SdkField<List<OtherMetadataValueListItem>> OTHER_METADATA_VALUE_LIST_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("OtherMetadataValueList").getter(MetadataInfo.getter(MetadataInfo::otherMetadataValueList)).setter(MetadataInfo.setter(Builder::otherMetadataValueList)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OtherMetadataValueList").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OtherMetadataValueListItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(METADATA_VALUE_FIELD, CREATED_TIME_FIELD, OTHER_METADATA_VALUE_LIST_FIELD));
    private static final long serialVersionUID = 1L;
    private final String metadataValue;
    private final String createdTime;
    private final List<OtherMetadataValueListItem> otherMetadataValueList;

    private MetadataInfo(BuilderImpl builder) {
        this.metadataValue = builder.metadataValue;
        this.createdTime = builder.createdTime;
        this.otherMetadataValueList = builder.otherMetadataValueList;
    }

    public final String metadataValue() {
        return this.metadataValue;
    }

    public final String createdTime() {
        return this.createdTime;
    }

    public final boolean hasOtherMetadataValueList() {
        return this.otherMetadataValueList != null && !(this.otherMetadataValueList instanceof SdkAutoConstructList);
    }

    public final List<OtherMetadataValueListItem> otherMetadataValueList() {
        return this.otherMetadataValueList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.metadataValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOtherMetadataValueList() ? this.otherMetadataValueList() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MetadataInfo)) {
            return false;
        }
        MetadataInfo other = (MetadataInfo)obj;
        return Objects.equals(this.metadataValue(), other.metadataValue()) && Objects.equals(this.createdTime(), other.createdTime()) && this.hasOtherMetadataValueList() == other.hasOtherMetadataValueList() && Objects.equals(this.otherMetadataValueList(), other.otherMetadataValueList());
    }

    public final String toString() {
        return ToString.builder((String)"MetadataInfo").add("MetadataValue", (Object)this.metadataValue()).add("CreatedTime", (Object)this.createdTime()).add("OtherMetadataValueList", this.hasOtherMetadataValueList() ? this.otherMetadataValueList() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MetadataValue": {
                return Optional.ofNullable(clazz.cast(this.metadataValue()));
            }
            case "CreatedTime": {
                return Optional.ofNullable(clazz.cast(this.createdTime()));
            }
            case "OtherMetadataValueList": {
                return Optional.ofNullable(clazz.cast(this.otherMetadataValueList()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MetadataInfo, T> g) {
        return obj -> g.apply((MetadataInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String metadataValue;
        private String createdTime;
        private List<OtherMetadataValueListItem> otherMetadataValueList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MetadataInfo model) {
            this.metadataValue(model.metadataValue);
            this.createdTime(model.createdTime);
            this.otherMetadataValueList(model.otherMetadataValueList);
        }

        public final String getMetadataValue() {
            return this.metadataValue;
        }

        public final void setMetadataValue(String metadataValue) {
            this.metadataValue = metadataValue;
        }

        @Override
        @Transient
        public final Builder metadataValue(String metadataValue) {
            this.metadataValue = metadataValue;
            return this;
        }

        public final String getCreatedTime() {
            return this.createdTime;
        }

        public final void setCreatedTime(String createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        @Transient
        public final Builder createdTime(String createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final List<OtherMetadataValueListItem.Builder> getOtherMetadataValueList() {
            List<OtherMetadataValueListItem.Builder> result = OtherMetadataValueListCopier.copyToBuilder(this.otherMetadataValueList);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOtherMetadataValueList(Collection<OtherMetadataValueListItem.BuilderImpl> otherMetadataValueList) {
            this.otherMetadataValueList = OtherMetadataValueListCopier.copyFromBuilder(otherMetadataValueList);
        }

        @Override
        @Transient
        public final Builder otherMetadataValueList(Collection<OtherMetadataValueListItem> otherMetadataValueList) {
            this.otherMetadataValueList = OtherMetadataValueListCopier.copy(otherMetadataValueList);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder otherMetadataValueList(OtherMetadataValueListItem ... otherMetadataValueList) {
            this.otherMetadataValueList(Arrays.asList(otherMetadataValueList));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder otherMetadataValueList(Consumer<OtherMetadataValueListItem.Builder> ... otherMetadataValueList) {
            this.otherMetadataValueList(Stream.of(otherMetadataValueList).map(c -> (OtherMetadataValueListItem)((OtherMetadataValueListItem.Builder)OtherMetadataValueListItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public MetadataInfo build() {
            return new MetadataInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, MetadataInfo> {
        public Builder metadataValue(String var1);

        public Builder createdTime(String var1);

        public Builder otherMetadataValueList(Collection<OtherMetadataValueListItem> var1);

        public Builder otherMetadataValueList(OtherMetadataValueListItem ... var1);

        public Builder otherMetadataValueList(Consumer<OtherMetadataValueListItem.Builder> ... var1);
    }
}

