/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.GlueRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class StartMlLabelingSetGenerationTaskRunRequest
extends GlueRequest
implements ToCopyableBuilder<Builder, StartMlLabelingSetGenerationTaskRunRequest> {
    private static final SdkField<String> TRANSFORM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TransformId").getter(StartMlLabelingSetGenerationTaskRunRequest.getter(StartMlLabelingSetGenerationTaskRunRequest::transformId)).setter(StartMlLabelingSetGenerationTaskRunRequest.setter(Builder::transformId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TransformId").build()}).build();
    private static final SdkField<String> OUTPUT_S3_PATH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OutputS3Path").getter(StartMlLabelingSetGenerationTaskRunRequest.getter(StartMlLabelingSetGenerationTaskRunRequest::outputS3Path)).setter(StartMlLabelingSetGenerationTaskRunRequest.setter(Builder::outputS3Path)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OutputS3Path").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSFORM_ID_FIELD, OUTPUT_S3_PATH_FIELD));
    private final String transformId;
    private final String outputS3Path;

    private StartMlLabelingSetGenerationTaskRunRequest(BuilderImpl builder) {
        super(builder);
        this.transformId = builder.transformId;
        this.outputS3Path = builder.outputS3Path;
    }

    public String transformId() {
        return this.transformId;
    }

    public String outputS3Path() {
        return this.outputS3Path;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transformId());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputS3Path());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartMlLabelingSetGenerationTaskRunRequest)) {
            return false;
        }
        StartMlLabelingSetGenerationTaskRunRequest other = (StartMlLabelingSetGenerationTaskRunRequest)((Object)obj);
        return Objects.equals(this.transformId(), other.transformId()) && Objects.equals(this.outputS3Path(), other.outputS3Path());
    }

    public String toString() {
        return ToString.builder((String)"StartMlLabelingSetGenerationTaskRunRequest").add("TransformId", (Object)this.transformId()).add("OutputS3Path", (Object)this.outputS3Path()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TransformId": {
                return Optional.ofNullable(clazz.cast(this.transformId()));
            }
            case "OutputS3Path": {
                return Optional.ofNullable(clazz.cast(this.outputS3Path()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<StartMlLabelingSetGenerationTaskRunRequest, T> g) {
        return obj -> g.apply((StartMlLabelingSetGenerationTaskRunRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends GlueRequest.BuilderImpl
    implements Builder {
        private String transformId;
        private String outputS3Path;

        private BuilderImpl() {
        }

        private BuilderImpl(StartMlLabelingSetGenerationTaskRunRequest model) {
            super(model);
            this.transformId(model.transformId);
            this.outputS3Path(model.outputS3Path);
        }

        public final String getTransformId() {
            return this.transformId;
        }

        @Override
        public final Builder transformId(String transformId) {
            this.transformId = transformId;
            return this;
        }

        public final void setTransformId(String transformId) {
            this.transformId = transformId;
        }

        public final String getOutputS3Path() {
            return this.outputS3Path;
        }

        @Override
        public final Builder outputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
            return this;
        }

        public final void setOutputS3Path(String outputS3Path) {
            this.outputS3Path = outputS3Path;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartMlLabelingSetGenerationTaskRunRequest build() {
            return new StartMlLabelingSetGenerationTaskRunRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends GlueRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, StartMlLabelingSetGenerationTaskRunRequest> {
        public Builder transformId(String var1);

        public Builder outputS3Path(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

