/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.glue.model.ColumnValueStringListCopier;
import software.amazon.awssdk.services.glue.model.LocationMapCopier;
import software.amazon.awssdk.services.glue.model.NameStringListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SkewedInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SkewedInfo> {
    private static final SdkField<List<String>> SKEWED_COLUMN_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SkewedColumnNames").getter(SkewedInfo.getter(SkewedInfo::skewedColumnNames)).setter(SkewedInfo.setter(Builder::skewedColumnNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkewedColumnNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SKEWED_COLUMN_VALUES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SkewedColumnValues").getter(SkewedInfo.getter(SkewedInfo::skewedColumnValues)).setter(SkewedInfo.setter(Builder::skewedColumnValues)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkewedColumnValues").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SKEWED_COLUMN_VALUE_LOCATION_MAPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("SkewedColumnValueLocationMaps").getter(SkewedInfo.getter(SkewedInfo::skewedColumnValueLocationMaps)).setter(SkewedInfo.setter(Builder::skewedColumnValueLocationMaps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SkewedColumnValueLocationMaps").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SKEWED_COLUMN_NAMES_FIELD, SKEWED_COLUMN_VALUES_FIELD, SKEWED_COLUMN_VALUE_LOCATION_MAPS_FIELD));
    private static final long serialVersionUID = 1L;
    private final List<String> skewedColumnNames;
    private final List<String> skewedColumnValues;
    private final Map<String, String> skewedColumnValueLocationMaps;

    private SkewedInfo(BuilderImpl builder) {
        this.skewedColumnNames = builder.skewedColumnNames;
        this.skewedColumnValues = builder.skewedColumnValues;
        this.skewedColumnValueLocationMaps = builder.skewedColumnValueLocationMaps;
    }

    public boolean hasSkewedColumnNames() {
        return this.skewedColumnNames != null && !(this.skewedColumnNames instanceof SdkAutoConstructList);
    }

    public List<String> skewedColumnNames() {
        return this.skewedColumnNames;
    }

    public boolean hasSkewedColumnValues() {
        return this.skewedColumnValues != null && !(this.skewedColumnValues instanceof SdkAutoConstructList);
    }

    public List<String> skewedColumnValues() {
        return this.skewedColumnValues;
    }

    public boolean hasSkewedColumnValueLocationMaps() {
        return this.skewedColumnValueLocationMaps != null && !(this.skewedColumnValueLocationMaps instanceof SdkAutoConstructMap);
    }

    public Map<String, String> skewedColumnValueLocationMaps() {
        return this.skewedColumnValueLocationMaps;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSkewedColumnNames() ? this.skewedColumnNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSkewedColumnValues() ? this.skewedColumnValues() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSkewedColumnValueLocationMaps() ? this.skewedColumnValueLocationMaps() : null);
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SkewedInfo)) {
            return false;
        }
        SkewedInfo other = (SkewedInfo)obj;
        return this.hasSkewedColumnNames() == other.hasSkewedColumnNames() && Objects.equals(this.skewedColumnNames(), other.skewedColumnNames()) && this.hasSkewedColumnValues() == other.hasSkewedColumnValues() && Objects.equals(this.skewedColumnValues(), other.skewedColumnValues()) && this.hasSkewedColumnValueLocationMaps() == other.hasSkewedColumnValueLocationMaps() && Objects.equals(this.skewedColumnValueLocationMaps(), other.skewedColumnValueLocationMaps());
    }

    public String toString() {
        return ToString.builder((String)"SkewedInfo").add("SkewedColumnNames", this.hasSkewedColumnNames() ? this.skewedColumnNames() : null).add("SkewedColumnValues", this.hasSkewedColumnValues() ? this.skewedColumnValues() : null).add("SkewedColumnValueLocationMaps", this.hasSkewedColumnValueLocationMaps() ? this.skewedColumnValueLocationMaps() : null).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SkewedColumnNames": {
                return Optional.ofNullable(clazz.cast(this.skewedColumnNames()));
            }
            case "SkewedColumnValues": {
                return Optional.ofNullable(clazz.cast(this.skewedColumnValues()));
            }
            case "SkewedColumnValueLocationMaps": {
                return Optional.ofNullable(clazz.cast(this.skewedColumnValueLocationMaps()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SkewedInfo, T> g) {
        return obj -> g.apply((SkewedInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> skewedColumnNames = DefaultSdkAutoConstructList.getInstance();
        private List<String> skewedColumnValues = DefaultSdkAutoConstructList.getInstance();
        private Map<String, String> skewedColumnValueLocationMaps = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SkewedInfo model) {
            this.skewedColumnNames(model.skewedColumnNames);
            this.skewedColumnValues(model.skewedColumnValues);
            this.skewedColumnValueLocationMaps(model.skewedColumnValueLocationMaps);
        }

        public final Collection<String> getSkewedColumnNames() {
            if (this.skewedColumnNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.skewedColumnNames;
        }

        @Override
        public final Builder skewedColumnNames(Collection<String> skewedColumnNames) {
            this.skewedColumnNames = NameStringListCopier.copy(skewedColumnNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skewedColumnNames(String ... skewedColumnNames) {
            this.skewedColumnNames(Arrays.asList(skewedColumnNames));
            return this;
        }

        public final void setSkewedColumnNames(Collection<String> skewedColumnNames) {
            this.skewedColumnNames = NameStringListCopier.copy(skewedColumnNames);
        }

        public final Collection<String> getSkewedColumnValues() {
            if (this.skewedColumnValues instanceof SdkAutoConstructList) {
                return null;
            }
            return this.skewedColumnValues;
        }

        @Override
        public final Builder skewedColumnValues(Collection<String> skewedColumnValues) {
            this.skewedColumnValues = ColumnValueStringListCopier.copy(skewedColumnValues);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder skewedColumnValues(String ... skewedColumnValues) {
            this.skewedColumnValues(Arrays.asList(skewedColumnValues));
            return this;
        }

        public final void setSkewedColumnValues(Collection<String> skewedColumnValues) {
            this.skewedColumnValues = ColumnValueStringListCopier.copy(skewedColumnValues);
        }

        public final Map<String, String> getSkewedColumnValueLocationMaps() {
            if (this.skewedColumnValueLocationMaps instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.skewedColumnValueLocationMaps;
        }

        @Override
        public final Builder skewedColumnValueLocationMaps(Map<String, String> skewedColumnValueLocationMaps) {
            this.skewedColumnValueLocationMaps = LocationMapCopier.copy(skewedColumnValueLocationMaps);
            return this;
        }

        public final void setSkewedColumnValueLocationMaps(Map<String, String> skewedColumnValueLocationMaps) {
            this.skewedColumnValueLocationMaps = LocationMapCopier.copy(skewedColumnValueLocationMaps);
        }

        public SkewedInfo build() {
            return new SkewedInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SkewedInfo> {
        public Builder skewedColumnNames(Collection<String> var1);

        public Builder skewedColumnNames(String ... var1);

        public Builder skewedColumnValues(Collection<String> var1);

        public Builder skewedColumnValues(String ... var1);

        public Builder skewedColumnValueLocationMaps(Map<String, String> var1);
    }
}

