/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.glue.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.glue.model.SchemaId;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaReference
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaReference> {
    private static final SdkField<SchemaId> SCHEMA_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("SchemaId").getter(SchemaReference.getter(SchemaReference::schemaId)).setter(SchemaReference.setter(Builder::schemaId)).constructor(SchemaId::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaId").build()}).build();
    private static final SdkField<String> SCHEMA_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SchemaVersionId").getter(SchemaReference.getter(SchemaReference::schemaVersionId)).setter(SchemaReference.setter(Builder::schemaVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionId").build()}).build();
    private static final SdkField<Long> SCHEMA_VERSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("SchemaVersionNumber").getter(SchemaReference.getter(SchemaReference::schemaVersionNumber)).setter(SchemaReference.setter(Builder::schemaVersionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SchemaVersionNumber").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCHEMA_ID_FIELD, SCHEMA_VERSION_ID_FIELD, SCHEMA_VERSION_NUMBER_FIELD));
    private static final long serialVersionUID = 1L;
    private final SchemaId schemaId;
    private final String schemaVersionId;
    private final Long schemaVersionNumber;

    private SchemaReference(BuilderImpl builder) {
        this.schemaId = builder.schemaId;
        this.schemaVersionId = builder.schemaVersionId;
        this.schemaVersionNumber = builder.schemaVersionNumber;
    }

    public SchemaId schemaId() {
        return this.schemaId;
    }

    public String schemaVersionId() {
        return this.schemaVersionId;
    }

    public Long schemaVersionNumber() {
        return this.schemaVersionNumber;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.schemaVersionNumber());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaReference)) {
            return false;
        }
        SchemaReference other = (SchemaReference)obj;
        return Objects.equals(this.schemaId(), other.schemaId()) && Objects.equals(this.schemaVersionId(), other.schemaVersionId()) && Objects.equals(this.schemaVersionNumber(), other.schemaVersionNumber());
    }

    public String toString() {
        return ToString.builder((String)"SchemaReference").add("SchemaId", (Object)this.schemaId()).add("SchemaVersionId", (Object)this.schemaVersionId()).add("SchemaVersionNumber", (Object)this.schemaVersionNumber()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "SchemaId": {
                return Optional.ofNullable(clazz.cast(this.schemaId()));
            }
            case "SchemaVersionId": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionId()));
            }
            case "SchemaVersionNumber": {
                return Optional.ofNullable(clazz.cast(this.schemaVersionNumber()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SchemaReference, T> g) {
        return obj -> g.apply((SchemaReference)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private SchemaId schemaId;
        private String schemaVersionId;
        private Long schemaVersionNumber;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaReference model) {
            this.schemaId(model.schemaId);
            this.schemaVersionId(model.schemaVersionId);
            this.schemaVersionNumber(model.schemaVersionNumber);
        }

        public final SchemaId.Builder getSchemaId() {
            return this.schemaId != null ? this.schemaId.toBuilder() : null;
        }

        @Override
        public final Builder schemaId(SchemaId schemaId) {
            this.schemaId = schemaId;
            return this;
        }

        public final void setSchemaId(SchemaId.BuilderImpl schemaId) {
            this.schemaId = schemaId != null ? schemaId.build() : null;
        }

        public final String getSchemaVersionId() {
            return this.schemaVersionId;
        }

        @Override
        public final Builder schemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
            return this;
        }

        public final void setSchemaVersionId(String schemaVersionId) {
            this.schemaVersionId = schemaVersionId;
        }

        public final Long getSchemaVersionNumber() {
            return this.schemaVersionNumber;
        }

        @Override
        public final Builder schemaVersionNumber(Long schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber;
            return this;
        }

        public final void setSchemaVersionNumber(Long schemaVersionNumber) {
            this.schemaVersionNumber = schemaVersionNumber;
        }

        public SchemaReference build() {
            return new SchemaReference(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaReference> {
        public Builder schemaId(SchemaId var1);

        default public Builder schemaId(Consumer<SchemaId.Builder> schemaId) {
            return this.schemaId((SchemaId)((SchemaId.Builder)SchemaId.builder().applyMutation(schemaId)).build());
        }

        public Builder schemaVersionId(String var1);

        public Builder schemaVersionNumber(Long var1);
    }
}

