/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableError;
import software.amazon.awssdk.services.frauddetector.model.BatchGetVariableErrorListCopier;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.Variable;
import software.amazon.awssdk.services.frauddetector.model.VariableListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetVariableResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, BatchGetVariableResponse> {
    private static final SdkField<List<Variable>> VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("variables").getter(BatchGetVariableResponse.getter(BatchGetVariableResponse::variables)).setter(BatchGetVariableResponse.setter(Builder::variables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Variable::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<BatchGetVariableError>> ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("errors").getter(BatchGetVariableResponse.getter(BatchGetVariableResponse::errors)).setter(BatchGetVariableResponse.setter(Builder::errors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchGetVariableError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLES_FIELD, ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetVariableResponse.memberNameToFieldInitializer();
    private final List<Variable> variables;
    private final List<BatchGetVariableError> errors;

    private BatchGetVariableResponse(BuilderImpl builder) {
        super(builder);
        this.variables = builder.variables;
        this.errors = builder.errors;
    }

    public final boolean hasVariables() {
        return this.variables != null && !(this.variables instanceof SdkAutoConstructList);
    }

    public final List<Variable> variables() {
        return this.variables;
    }

    public final boolean hasErrors() {
        return this.errors != null && !(this.errors instanceof SdkAutoConstructList);
    }

    public final List<BatchGetVariableError> errors() {
        return this.errors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVariables() ? this.variables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasErrors() ? this.errors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetVariableResponse)) {
            return false;
        }
        BatchGetVariableResponse other = (BatchGetVariableResponse)((Object)obj);
        return this.hasVariables() == other.hasVariables() && Objects.equals(this.variables(), other.variables()) && this.hasErrors() == other.hasErrors() && Objects.equals(this.errors(), other.errors());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetVariableResponse").add("Variables", this.hasVariables() ? this.variables() : null).add("Errors", this.hasErrors() ? this.errors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "variables": {
                return Optional.ofNullable(clazz.cast(this.variables()));
            }
            case "errors": {
                return Optional.ofNullable(clazz.cast(this.errors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("variables", VARIABLES_FIELD);
        map.put("errors", ERRORS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetVariableResponse, T> g) {
        return obj -> g.apply((BatchGetVariableResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<Variable> variables = DefaultSdkAutoConstructList.getInstance();
        private List<BatchGetVariableError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetVariableResponse model) {
            super(model);
            this.variables(model.variables);
            this.errors(model.errors);
        }

        public final List<Variable.Builder> getVariables() {
            List<Variable.Builder> result = VariableListCopier.copyToBuilder(this.variables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVariables(Collection<Variable.BuilderImpl> variables) {
            this.variables = VariableListCopier.copyFromBuilder(variables);
        }

        @Override
        public final Builder variables(Collection<Variable> variables) {
            this.variables = VariableListCopier.copy(variables);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Variable ... variables) {
            this.variables(Arrays.asList(variables));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder variables(Consumer<Variable.Builder> ... variables) {
            this.variables(Stream.of(variables).map(c -> (Variable)((Variable.Builder)Variable.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<BatchGetVariableError.Builder> getErrors() {
            List<BatchGetVariableError.Builder> result = BatchGetVariableErrorListCopier.copyToBuilder(this.errors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setErrors(Collection<BatchGetVariableError.BuilderImpl> errors) {
            this.errors = BatchGetVariableErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public final Builder errors(Collection<BatchGetVariableError> errors) {
            this.errors = BatchGetVariableErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(BatchGetVariableError ... errors) {
            this.errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<BatchGetVariableError.Builder> ... errors) {
            this.errors(Stream.of(errors).map(c -> (BatchGetVariableError)((BatchGetVariableError.Builder)BatchGetVariableError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public BatchGetVariableResponse build() {
            return new BatchGetVariableResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, BatchGetVariableResponse> {
        public Builder variables(Collection<Variable> var1);

        public Builder variables(Variable ... var1);

        public Builder variables(Consumer<Variable.Builder> ... var1);

        public Builder errors(Collection<BatchGetVariableError> var1);

        public Builder errors(BatchGetVariableError ... var1);

        public Builder errors(Consumer<BatchGetVariableError.Builder> ... var1);
    }
}

