/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.frauddetector.model.Entity;
import software.amazon.awssdk.services.frauddetector.model.EventAttributeMapCopier;
import software.amazon.awssdk.services.frauddetector.model._listOfEntitiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Event
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Event> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(Event.getter(Event::eventId)).setter(Event.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeName").getter(Event.getter(Event::eventTypeName)).setter(Event.setter(Builder::eventTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()}).build();
    private static final SdkField<String> EVENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTimestamp").getter(Event.getter(Event::eventTimestamp)).setter(Event.setter(Builder::eventTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()}).build();
    private static final SdkField<Map<String, String>> EVENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("eventVariables").getter(Event.getter(Event::eventVariables)).setter(Event.setter(Builder::eventVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CURRENT_LABEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("currentLabel").getter(Event.getter(Event::currentLabel)).setter(Event.setter(Builder::currentLabel)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currentLabel").build()}).build();
    private static final SdkField<String> LABEL_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("labelTimestamp").getter(Event.getter(Event::labelTimestamp)).setter(Event.setter(Builder::labelTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("labelTimestamp").build()}).build();
    private static final SdkField<List<Entity>> ENTITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("entities").getter(Event.getter(Event::entities)).setter(Event.setter(Builder::entities)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entities").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Entity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_TYPE_NAME_FIELD, EVENT_TIMESTAMP_FIELD, EVENT_VARIABLES_FIELD, CURRENT_LABEL_FIELD, LABEL_TIMESTAMP_FIELD, ENTITIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eventId", EVENT_ID_FIELD);
            this.put("eventTypeName", EVENT_TYPE_NAME_FIELD);
            this.put("eventTimestamp", EVENT_TIMESTAMP_FIELD);
            this.put("eventVariables", EVENT_VARIABLES_FIELD);
            this.put("currentLabel", CURRENT_LABEL_FIELD);
            this.put("labelTimestamp", LABEL_TIMESTAMP_FIELD);
            this.put("entities", ENTITIES_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String eventId;
    private final String eventTypeName;
    private final String eventTimestamp;
    private final Map<String, String> eventVariables;
    private final String currentLabel;
    private final String labelTimestamp;
    private final List<Entity> entities;

    private Event(BuilderImpl builder) {
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.eventTimestamp = builder.eventTimestamp;
        this.eventVariables = builder.eventVariables;
        this.currentLabel = builder.currentLabel;
        this.labelTimestamp = builder.labelTimestamp;
        this.entities = builder.entities;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String eventTypeName() {
        return this.eventTypeName;
    }

    public final String eventTimestamp() {
        return this.eventTimestamp;
    }

    public final boolean hasEventVariables() {
        return this.eventVariables != null && !(this.eventVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> eventVariables() {
        return this.eventVariables;
    }

    public final String currentLabel() {
        return this.currentLabel;
    }

    public final String labelTimestamp() {
        return this.labelTimestamp;
    }

    public final boolean hasEntities() {
        return this.entities != null && !(this.entities instanceof SdkAutoConstructList);
    }

    public final List<Entity> entities() {
        return this.entities;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventVariables() ? this.eventVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.currentLabel());
        hashCode = 31 * hashCode + Objects.hashCode(this.labelTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEntities() ? this.entities() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Event)) {
            return false;
        }
        Event other = (Event)obj;
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventTypeName(), other.eventTypeName()) && Objects.equals(this.eventTimestamp(), other.eventTimestamp()) && this.hasEventVariables() == other.hasEventVariables() && Objects.equals(this.eventVariables(), other.eventVariables()) && Objects.equals(this.currentLabel(), other.currentLabel()) && Objects.equals(this.labelTimestamp(), other.labelTimestamp()) && this.hasEntities() == other.hasEntities() && Objects.equals(this.entities(), other.entities());
    }

    public final String toString() {
        return ToString.builder((String)"Event").add("EventId", (Object)this.eventId()).add("EventTypeName", (Object)this.eventTypeName()).add("EventTimestamp", (Object)this.eventTimestamp()).add("EventVariables", (Object)(this.eventVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("CurrentLabel", (Object)this.currentLabel()).add("LabelTimestamp", (Object)this.labelTimestamp()).add("Entities", (Object)(this.entities() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventTypeName": {
                return Optional.ofNullable(clazz.cast(this.eventTypeName()));
            }
            case "eventTimestamp": {
                return Optional.ofNullable(clazz.cast(this.eventTimestamp()));
            }
            case "eventVariables": {
                return Optional.ofNullable(clazz.cast(this.eventVariables()));
            }
            case "currentLabel": {
                return Optional.ofNullable(clazz.cast(this.currentLabel()));
            }
            case "labelTimestamp": {
                return Optional.ofNullable(clazz.cast(this.labelTimestamp()));
            }
            case "entities": {
                return Optional.ofNullable(clazz.cast(this.entities()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<Event, T> g) {
        return obj -> g.apply((Event)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventId;
        private String eventTypeName;
        private String eventTimestamp;
        private Map<String, String> eventVariables = DefaultSdkAutoConstructMap.getInstance();
        private String currentLabel;
        private String labelTimestamp;
        private List<Entity> entities = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Event model) {
            this.eventId(model.eventId);
            this.eventTypeName(model.eventTypeName);
            this.eventTimestamp(model.eventTimestamp);
            this.eventVariables(model.eventVariables);
            this.currentLabel(model.currentLabel);
            this.labelTimestamp(model.labelTimestamp);
            this.entities(model.entities);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return this.eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getEventTimestamp() {
            return this.eventTimestamp;
        }

        public final void setEventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        public final Builder eventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final Map<String, String> getEventVariables() {
            if (this.eventVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.eventVariables;
        }

        public final void setEventVariables(Map<String, String> eventVariables) {
            this.eventVariables = EventAttributeMapCopier.copy(eventVariables);
        }

        @Override
        public final Builder eventVariables(Map<String, String> eventVariables) {
            this.eventVariables = EventAttributeMapCopier.copy(eventVariables);
            return this;
        }

        public final String getCurrentLabel() {
            return this.currentLabel;
        }

        public final void setCurrentLabel(String currentLabel) {
            this.currentLabel = currentLabel;
        }

        @Override
        public final Builder currentLabel(String currentLabel) {
            this.currentLabel = currentLabel;
            return this;
        }

        public final String getLabelTimestamp() {
            return this.labelTimestamp;
        }

        public final void setLabelTimestamp(String labelTimestamp) {
            this.labelTimestamp = labelTimestamp;
        }

        @Override
        public final Builder labelTimestamp(String labelTimestamp) {
            this.labelTimestamp = labelTimestamp;
            return this;
        }

        public final List<Entity.Builder> getEntities() {
            List<Entity.Builder> result = _listOfEntitiesCopier.copyToBuilder(this.entities);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEntities(Collection<Entity.BuilderImpl> entities) {
            this.entities = _listOfEntitiesCopier.copyFromBuilder(entities);
        }

        @Override
        public final Builder entities(Collection<Entity> entities) {
            this.entities = _listOfEntitiesCopier.copy(entities);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Entity ... entities) {
            this.entities(Arrays.asList(entities));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder entities(Consumer<Entity.Builder> ... entities) {
            this.entities(Stream.of(entities).map(c -> (Entity)((Entity.Builder)Entity.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public Event build() {
            return new Event(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Event> {
        public Builder eventId(String var1);

        public Builder eventTypeName(String var1);

        public Builder eventTimestamp(String var1);

        public Builder eventVariables(Map<String, String> var1);

        public Builder currentLabel(String var1);

        public Builder labelTimestamp(String var1);

        public Builder entities(Collection<Entity> var1);

        public Builder entities(Entity ... var1);

        public Builder entities(Consumer<Entity.Builder> ... var1);
    }
}

