/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.ATITrainingMetricsValue;
import software.amazon.awssdk.services.frauddetector.model.OFITrainingMetricsValue;
import software.amazon.awssdk.services.frauddetector.model.TFITrainingMetricsValue;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingMetricsV2
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingMetricsV2> {
    private static final SdkField<OFITrainingMetricsValue> OFI_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ofi").getter(TrainingMetricsV2.getter(TrainingMetricsV2::ofi)).setter(TrainingMetricsV2.setter(Builder::ofi)).constructor(OFITrainingMetricsValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ofi").build()}).build();
    private static final SdkField<TFITrainingMetricsValue> TFI_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tfi").getter(TrainingMetricsV2.getter(TrainingMetricsV2::tfi)).setter(TrainingMetricsV2.setter(Builder::tfi)).constructor(TFITrainingMetricsValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tfi").build()}).build();
    private static final SdkField<ATITrainingMetricsValue> ATI_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ati").getter(TrainingMetricsV2.getter(TrainingMetricsV2::ati)).setter(TrainingMetricsV2.setter(Builder::ati)).constructor(ATITrainingMetricsValue::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ati").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OFI_FIELD, TFI_FIELD, ATI_FIELD));
    private static final long serialVersionUID = 1L;
    private final OFITrainingMetricsValue ofi;
    private final TFITrainingMetricsValue tfi;
    private final ATITrainingMetricsValue ati;

    private TrainingMetricsV2(BuilderImpl builder) {
        this.ofi = builder.ofi;
        this.tfi = builder.tfi;
        this.ati = builder.ati;
    }

    public final OFITrainingMetricsValue ofi() {
        return this.ofi;
    }

    public final TFITrainingMetricsValue tfi() {
        return this.tfi;
    }

    public final ATITrainingMetricsValue ati() {
        return this.ati;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ofi());
        hashCode = 31 * hashCode + Objects.hashCode(this.tfi());
        hashCode = 31 * hashCode + Objects.hashCode(this.ati());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingMetricsV2)) {
            return false;
        }
        TrainingMetricsV2 other = (TrainingMetricsV2)obj;
        return Objects.equals(this.ofi(), other.ofi()) && Objects.equals(this.tfi(), other.tfi()) && Objects.equals(this.ati(), other.ati());
    }

    public final String toString() {
        return ToString.builder((String)"TrainingMetricsV2").add("Ofi", (Object)this.ofi()).add("Tfi", (Object)this.tfi()).add("Ati", (Object)this.ati()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ofi": {
                return Optional.ofNullable(clazz.cast(this.ofi()));
            }
            case "tfi": {
                return Optional.ofNullable(clazz.cast(this.tfi()));
            }
            case "ati": {
                return Optional.ofNullable(clazz.cast(this.ati()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingMetricsV2, T> g) {
        return obj -> g.apply((TrainingMetricsV2)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OFITrainingMetricsValue ofi;
        private TFITrainingMetricsValue tfi;
        private ATITrainingMetricsValue ati;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingMetricsV2 model) {
            this.ofi(model.ofi);
            this.tfi(model.tfi);
            this.ati(model.ati);
        }

        public final OFITrainingMetricsValue.Builder getOfi() {
            return this.ofi != null ? this.ofi.toBuilder() : null;
        }

        public final void setOfi(OFITrainingMetricsValue.BuilderImpl ofi) {
            this.ofi = ofi != null ? ofi.build() : null;
        }

        @Override
        public final Builder ofi(OFITrainingMetricsValue ofi) {
            this.ofi = ofi;
            return this;
        }

        public final TFITrainingMetricsValue.Builder getTfi() {
            return this.tfi != null ? this.tfi.toBuilder() : null;
        }

        public final void setTfi(TFITrainingMetricsValue.BuilderImpl tfi) {
            this.tfi = tfi != null ? tfi.build() : null;
        }

        @Override
        public final Builder tfi(TFITrainingMetricsValue tfi) {
            this.tfi = tfi;
            return this;
        }

        public final ATITrainingMetricsValue.Builder getAti() {
            return this.ati != null ? this.ati.toBuilder() : null;
        }

        public final void setAti(ATITrainingMetricsValue.BuilderImpl ati) {
            this.ati = ati != null ? ati.build() : null;
        }

        @Override
        public final Builder ati(ATITrainingMetricsValue ati) {
            this.ati = ati;
            return this;
        }

        public TrainingMetricsV2 build() {
            return new TrainingMetricsV2(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingMetricsV2> {
        public Builder ofi(OFITrainingMetricsValue var1);

        default public Builder ofi(Consumer<OFITrainingMetricsValue.Builder> ofi) {
            return this.ofi((OFITrainingMetricsValue)((OFITrainingMetricsValue.Builder)OFITrainingMetricsValue.builder().applyMutation(ofi)).build());
        }

        public Builder tfi(TFITrainingMetricsValue var1);

        default public Builder tfi(Consumer<TFITrainingMetricsValue.Builder> tfi) {
            return this.tfi((TFITrainingMetricsValue)((TFITrainingMetricsValue.Builder)TFITrainingMetricsValue.builder().applyMutation(tfi)).build());
        }

        public Builder ati(ATITrainingMetricsValue var1);

        default public Builder ati(Consumer<ATITrainingMetricsValue.Builder> ati) {
            return this.ati((ATITrainingMetricsValue)((ATITrainingMetricsValue.Builder)ATITrainingMetricsValue.builder().applyMutation(ati)).build());
        }
    }
}

