/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LogOddsMetric
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LogOddsMetric> {
    private static final SdkField<String> VARIABLE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("variableName").getter(LogOddsMetric.getter(LogOddsMetric::variableName)).setter(LogOddsMetric.setter(Builder::variableName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableName").build()}).build();
    private static final SdkField<String> VARIABLE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("variableType").getter(LogOddsMetric.getter(LogOddsMetric::variableType)).setter(LogOddsMetric.setter(Builder::variableType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableType").build()}).build();
    private static final SdkField<Float> VARIABLE_IMPORTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.FLOAT).memberName("variableImportance").getter(LogOddsMetric.getter(LogOddsMetric::variableImportance)).setter(LogOddsMetric.setter(Builder::variableImportance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("variableImportance").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VARIABLE_NAME_FIELD, VARIABLE_TYPE_FIELD, VARIABLE_IMPORTANCE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String variableName;
    private final String variableType;
    private final Float variableImportance;

    private LogOddsMetric(BuilderImpl builder) {
        this.variableName = builder.variableName;
        this.variableType = builder.variableType;
        this.variableImportance = builder.variableImportance;
    }

    public final String variableName() {
        return this.variableName;
    }

    public final String variableType() {
        return this.variableType;
    }

    public final Float variableImportance() {
        return this.variableImportance;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.variableName());
        hashCode = 31 * hashCode + Objects.hashCode(this.variableType());
        hashCode = 31 * hashCode + Objects.hashCode(this.variableImportance());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogOddsMetric)) {
            return false;
        }
        LogOddsMetric other = (LogOddsMetric)obj;
        return Objects.equals(this.variableName(), other.variableName()) && Objects.equals(this.variableType(), other.variableType()) && Objects.equals(this.variableImportance(), other.variableImportance());
    }

    public final String toString() {
        return ToString.builder((String)"LogOddsMetric").add("VariableName", (Object)this.variableName()).add("VariableType", (Object)this.variableType()).add("VariableImportance", (Object)this.variableImportance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "variableName": {
                return Optional.ofNullable(clazz.cast(this.variableName()));
            }
            case "variableType": {
                return Optional.ofNullable(clazz.cast(this.variableType()));
            }
            case "variableImportance": {
                return Optional.ofNullable(clazz.cast(this.variableImportance()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LogOddsMetric, T> g) {
        return obj -> g.apply((LogOddsMetric)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String variableName;
        private String variableType;
        private Float variableImportance;

        private BuilderImpl() {
        }

        private BuilderImpl(LogOddsMetric model) {
            this.variableName(model.variableName);
            this.variableType(model.variableType);
            this.variableImportance(model.variableImportance);
        }

        public final String getVariableName() {
            return this.variableName;
        }

        public final void setVariableName(String variableName) {
            this.variableName = variableName;
        }

        @Override
        public final Builder variableName(String variableName) {
            this.variableName = variableName;
            return this;
        }

        public final String getVariableType() {
            return this.variableType;
        }

        public final void setVariableType(String variableType) {
            this.variableType = variableType;
        }

        @Override
        public final Builder variableType(String variableType) {
            this.variableType = variableType;
            return this;
        }

        public final Float getVariableImportance() {
            return this.variableImportance;
        }

        public final void setVariableImportance(Float variableImportance) {
            this.variableImportance = variableImportance;
        }

        @Override
        public final Builder variableImportance(Float variableImportance) {
            this.variableImportance = variableImportance;
            return this;
        }

        public LogOddsMetric build() {
            return new LogOddsMetric(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LogOddsMetric> {
        public Builder variableName(String var1);

        public Builder variableType(String var1);

        public Builder variableImportance(Float var1);
    }
}

