/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum TrainingDataSourceEnum {
    EXTERNAL_EVENTS("EXTERNAL_EVENTS"),
    INGESTED_EVENTS("INGESTED_EVENTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, TrainingDataSourceEnum> VALUE_MAP;
    private final String value;

    private TrainingDataSourceEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrainingDataSourceEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrainingDataSourceEnum> knownValues() {
        EnumSet<TrainingDataSourceEnum> knownValues = EnumSet.allOf(TrainingDataSourceEnum.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(TrainingDataSourceEnum.class, TrainingDataSourceEnum::toString);
    }
}

