/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.EvaluatedExternalModel;
import software.amazon.awssdk.services.frauddetector.model.EvaluatedModelVersion;
import software.amazon.awssdk.services.frauddetector.model.EvaluatedRule;
import software.amazon.awssdk.services.frauddetector.model.EvaluatedRuleListCopier;
import software.amazon.awssdk.services.frauddetector.model.EventVariableSummary;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.services.frauddetector.model.ListOfEvaluatedExternalModelsCopier;
import software.amazon.awssdk.services.frauddetector.model.ListOfEvaluatedModelVersionsCopier;
import software.amazon.awssdk.services.frauddetector.model.ListOfEventVariableSummariesCopier;
import software.amazon.awssdk.services.frauddetector.model.ListOfStringsCopier;
import software.amazon.awssdk.services.frauddetector.model.RuleExecutionMode;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEventPredictionMetadataResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetEventPredictionMetadataResponse> {
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::eventId)).setter(GetEventPredictionMetadataResponse.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_TYPE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTypeName").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::eventTypeName)).setter(GetEventPredictionMetadataResponse.setter(Builder::eventTypeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTypeName").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::entityId)).setter(GetEventPredictionMetadataResponse.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityType").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::entityType)).setter(GetEventPredictionMetadataResponse.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()}).build();
    private static final SdkField<String> EVENT_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventTimestamp").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::eventTimestamp)).setter(GetEventPredictionMetadataResponse.setter(Builder::eventTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTimestamp").build()}).build();
    private static final SdkField<String> DETECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorId").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::detectorId)).setter(GetEventPredictionMetadataResponse.setter(Builder::detectorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorId").build()}).build();
    private static final SdkField<String> DETECTOR_VERSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorVersionId").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::detectorVersionId)).setter(GetEventPredictionMetadataResponse.setter(Builder::detectorVersionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionId").build()}).build();
    private static final SdkField<String> DETECTOR_VERSION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("detectorVersionStatus").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::detectorVersionStatus)).setter(GetEventPredictionMetadataResponse.setter(Builder::detectorVersionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("detectorVersionStatus").build()}).build();
    private static final SdkField<List<EventVariableSummary>> EVENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("eventVariables").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::eventVariables)).setter(GetEventPredictionMetadataResponse.setter(Builder::eventVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventVariables").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EventVariableSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EvaluatedRule>> RULES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rules").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::rules)).setter(GetEventPredictionMetadataResponse.setter(Builder::rules)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rules").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluatedRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RULE_EXECUTION_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ruleExecutionMode").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::ruleExecutionModeAsString)).setter(GetEventPredictionMetadataResponse.setter(Builder::ruleExecutionMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ruleExecutionMode").build()}).build();
    private static final SdkField<List<String>> OUTCOMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outcomes").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::outcomes)).setter(GetEventPredictionMetadataResponse.setter(Builder::outcomes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EvaluatedModelVersion>> EVALUATED_MODEL_VERSIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluatedModelVersions").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::evaluatedModelVersions)).setter(GetEventPredictionMetadataResponse.setter(Builder::evaluatedModelVersions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatedModelVersions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluatedModelVersion::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<EvaluatedExternalModel>> EVALUATED_EXTERNAL_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluatedExternalModels").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::evaluatedExternalModels)).setter(GetEventPredictionMetadataResponse.setter(Builder::evaluatedExternalModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatedExternalModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluatedExternalModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PREDICTION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("predictionTimestamp").getter(GetEventPredictionMetadataResponse.getter(GetEventPredictionMetadataResponse::predictionTimestamp)).setter(GetEventPredictionMetadataResponse.setter(Builder::predictionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionTimestamp").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_ID_FIELD, EVENT_TYPE_NAME_FIELD, ENTITY_ID_FIELD, ENTITY_TYPE_FIELD, EVENT_TIMESTAMP_FIELD, DETECTOR_ID_FIELD, DETECTOR_VERSION_ID_FIELD, DETECTOR_VERSION_STATUS_FIELD, EVENT_VARIABLES_FIELD, RULES_FIELD, RULE_EXECUTION_MODE_FIELD, OUTCOMES_FIELD, EVALUATED_MODEL_VERSIONS_FIELD, EVALUATED_EXTERNAL_MODELS_FIELD, PREDICTION_TIMESTAMP_FIELD));
    private final String eventId;
    private final String eventTypeName;
    private final String entityId;
    private final String entityType;
    private final String eventTimestamp;
    private final String detectorId;
    private final String detectorVersionId;
    private final String detectorVersionStatus;
    private final List<EventVariableSummary> eventVariables;
    private final List<EvaluatedRule> rules;
    private final String ruleExecutionMode;
    private final List<String> outcomes;
    private final List<EvaluatedModelVersion> evaluatedModelVersions;
    private final List<EvaluatedExternalModel> evaluatedExternalModels;
    private final String predictionTimestamp;

    private GetEventPredictionMetadataResponse(BuilderImpl builder) {
        super(builder);
        this.eventId = builder.eventId;
        this.eventTypeName = builder.eventTypeName;
        this.entityId = builder.entityId;
        this.entityType = builder.entityType;
        this.eventTimestamp = builder.eventTimestamp;
        this.detectorId = builder.detectorId;
        this.detectorVersionId = builder.detectorVersionId;
        this.detectorVersionStatus = builder.detectorVersionStatus;
        this.eventVariables = builder.eventVariables;
        this.rules = builder.rules;
        this.ruleExecutionMode = builder.ruleExecutionMode;
        this.outcomes = builder.outcomes;
        this.evaluatedModelVersions = builder.evaluatedModelVersions;
        this.evaluatedExternalModels = builder.evaluatedExternalModels;
        this.predictionTimestamp = builder.predictionTimestamp;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final String eventTypeName() {
        return this.eventTypeName;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String entityType() {
        return this.entityType;
    }

    public final String eventTimestamp() {
        return this.eventTimestamp;
    }

    public final String detectorId() {
        return this.detectorId;
    }

    public final String detectorVersionId() {
        return this.detectorVersionId;
    }

    public final String detectorVersionStatus() {
        return this.detectorVersionStatus;
    }

    public final boolean hasEventVariables() {
        return this.eventVariables != null && !(this.eventVariables instanceof SdkAutoConstructList);
    }

    public final List<EventVariableSummary> eventVariables() {
        return this.eventVariables;
    }

    public final boolean hasRules() {
        return this.rules != null && !(this.rules instanceof SdkAutoConstructList);
    }

    public final List<EvaluatedRule> rules() {
        return this.rules;
    }

    public final RuleExecutionMode ruleExecutionMode() {
        return RuleExecutionMode.fromValue(this.ruleExecutionMode);
    }

    public final String ruleExecutionModeAsString() {
        return this.ruleExecutionMode;
    }

    public final boolean hasOutcomes() {
        return this.outcomes != null && !(this.outcomes instanceof SdkAutoConstructList);
    }

    public final List<String> outcomes() {
        return this.outcomes;
    }

    public final boolean hasEvaluatedModelVersions() {
        return this.evaluatedModelVersions != null && !(this.evaluatedModelVersions instanceof SdkAutoConstructList);
    }

    public final List<EvaluatedModelVersion> evaluatedModelVersions() {
        return this.evaluatedModelVersions;
    }

    public final boolean hasEvaluatedExternalModels() {
        return this.evaluatedExternalModels != null && !(this.evaluatedExternalModels instanceof SdkAutoConstructList);
    }

    public final List<EvaluatedExternalModel> evaluatedExternalModels() {
        return this.evaluatedExternalModels;
    }

    public final String predictionTimestamp() {
        return this.predictionTimestamp;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorVersionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.detectorVersionStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEventVariables() ? this.eventVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRules() ? this.rules() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ruleExecutionModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutcomes() ? this.outcomes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluatedModelVersions() ? this.evaluatedModelVersions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluatedExternalModels() ? this.evaluatedExternalModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionTimestamp());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEventPredictionMetadataResponse)) {
            return false;
        }
        GetEventPredictionMetadataResponse other = (GetEventPredictionMetadataResponse)((Object)obj);
        return Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventTypeName(), other.eventTypeName()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityType(), other.entityType()) && Objects.equals(this.eventTimestamp(), other.eventTimestamp()) && Objects.equals(this.detectorId(), other.detectorId()) && Objects.equals(this.detectorVersionId(), other.detectorVersionId()) && Objects.equals(this.detectorVersionStatus(), other.detectorVersionStatus()) && this.hasEventVariables() == other.hasEventVariables() && Objects.equals(this.eventVariables(), other.eventVariables()) && this.hasRules() == other.hasRules() && Objects.equals(this.rules(), other.rules()) && Objects.equals(this.ruleExecutionModeAsString(), other.ruleExecutionModeAsString()) && this.hasOutcomes() == other.hasOutcomes() && Objects.equals(this.outcomes(), other.outcomes()) && this.hasEvaluatedModelVersions() == other.hasEvaluatedModelVersions() && Objects.equals(this.evaluatedModelVersions(), other.evaluatedModelVersions()) && this.hasEvaluatedExternalModels() == other.hasEvaluatedExternalModels() && Objects.equals(this.evaluatedExternalModels(), other.evaluatedExternalModels()) && Objects.equals(this.predictionTimestamp(), other.predictionTimestamp());
    }

    public final String toString() {
        return ToString.builder((String)"GetEventPredictionMetadataResponse").add("EventId", (Object)this.eventId()).add("EventTypeName", (Object)this.eventTypeName()).add("EntityId", (Object)this.entityId()).add("EntityType", (Object)this.entityType()).add("EventTimestamp", (Object)this.eventTimestamp()).add("DetectorId", (Object)this.detectorId()).add("DetectorVersionId", (Object)this.detectorVersionId()).add("DetectorVersionStatus", (Object)this.detectorVersionStatus()).add("EventVariables", this.hasEventVariables() ? this.eventVariables() : null).add("Rules", this.hasRules() ? this.rules() : null).add("RuleExecutionMode", (Object)this.ruleExecutionModeAsString()).add("Outcomes", this.hasOutcomes() ? this.outcomes() : null).add("EvaluatedModelVersions", this.hasEvaluatedModelVersions() ? this.evaluatedModelVersions() : null).add("EvaluatedExternalModels", this.hasEvaluatedExternalModels() ? this.evaluatedExternalModels() : null).add("PredictionTimestamp", (Object)this.predictionTimestamp()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventTypeName": {
                return Optional.ofNullable(clazz.cast(this.eventTypeName()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityType()));
            }
            case "eventTimestamp": {
                return Optional.ofNullable(clazz.cast(this.eventTimestamp()));
            }
            case "detectorId": {
                return Optional.ofNullable(clazz.cast(this.detectorId()));
            }
            case "detectorVersionId": {
                return Optional.ofNullable(clazz.cast(this.detectorVersionId()));
            }
            case "detectorVersionStatus": {
                return Optional.ofNullable(clazz.cast(this.detectorVersionStatus()));
            }
            case "eventVariables": {
                return Optional.ofNullable(clazz.cast(this.eventVariables()));
            }
            case "rules": {
                return Optional.ofNullable(clazz.cast(this.rules()));
            }
            case "ruleExecutionMode": {
                return Optional.ofNullable(clazz.cast(this.ruleExecutionModeAsString()));
            }
            case "outcomes": {
                return Optional.ofNullable(clazz.cast(this.outcomes()));
            }
            case "evaluatedModelVersions": {
                return Optional.ofNullable(clazz.cast(this.evaluatedModelVersions()));
            }
            case "evaluatedExternalModels": {
                return Optional.ofNullable(clazz.cast(this.evaluatedExternalModels()));
            }
            case "predictionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.predictionTimestamp()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEventPredictionMetadataResponse, T> g) {
        return obj -> g.apply((GetEventPredictionMetadataResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private String eventId;
        private String eventTypeName;
        private String entityId;
        private String entityType;
        private String eventTimestamp;
        private String detectorId;
        private String detectorVersionId;
        private String detectorVersionStatus;
        private List<EventVariableSummary> eventVariables = DefaultSdkAutoConstructList.getInstance();
        private List<EvaluatedRule> rules = DefaultSdkAutoConstructList.getInstance();
        private String ruleExecutionMode;
        private List<String> outcomes = DefaultSdkAutoConstructList.getInstance();
        private List<EvaluatedModelVersion> evaluatedModelVersions = DefaultSdkAutoConstructList.getInstance();
        private List<EvaluatedExternalModel> evaluatedExternalModels = DefaultSdkAutoConstructList.getInstance();
        private String predictionTimestamp;

        private BuilderImpl() {
        }

        private BuilderImpl(GetEventPredictionMetadataResponse model) {
            super(model);
            this.eventId(model.eventId);
            this.eventTypeName(model.eventTypeName);
            this.entityId(model.entityId);
            this.entityType(model.entityType);
            this.eventTimestamp(model.eventTimestamp);
            this.detectorId(model.detectorId);
            this.detectorVersionId(model.detectorVersionId);
            this.detectorVersionStatus(model.detectorVersionStatus);
            this.eventVariables(model.eventVariables);
            this.rules(model.rules);
            this.ruleExecutionMode(model.ruleExecutionMode);
            this.outcomes(model.outcomes);
            this.evaluatedModelVersions(model.evaluatedModelVersions);
            this.evaluatedExternalModels(model.evaluatedExternalModels);
            this.predictionTimestamp(model.predictionTimestamp);
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        @Transient
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventTypeName() {
            return this.eventTypeName;
        }

        public final void setEventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
        }

        @Override
        @Transient
        public final Builder eventTypeName(String eventTypeName) {
            this.eventTypeName = eventTypeName;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        @Transient
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        @Transient
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getEventTimestamp() {
            return this.eventTimestamp;
        }

        public final void setEventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
        }

        @Override
        @Transient
        public final Builder eventTimestamp(String eventTimestamp) {
            this.eventTimestamp = eventTimestamp;
            return this;
        }

        public final String getDetectorId() {
            return this.detectorId;
        }

        public final void setDetectorId(String detectorId) {
            this.detectorId = detectorId;
        }

        @Override
        @Transient
        public final Builder detectorId(String detectorId) {
            this.detectorId = detectorId;
            return this;
        }

        public final String getDetectorVersionId() {
            return this.detectorVersionId;
        }

        public final void setDetectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
        }

        @Override
        @Transient
        public final Builder detectorVersionId(String detectorVersionId) {
            this.detectorVersionId = detectorVersionId;
            return this;
        }

        public final String getDetectorVersionStatus() {
            return this.detectorVersionStatus;
        }

        public final void setDetectorVersionStatus(String detectorVersionStatus) {
            this.detectorVersionStatus = detectorVersionStatus;
        }

        @Override
        @Transient
        public final Builder detectorVersionStatus(String detectorVersionStatus) {
            this.detectorVersionStatus = detectorVersionStatus;
            return this;
        }

        public final List<EventVariableSummary.Builder> getEventVariables() {
            List<EventVariableSummary.Builder> result = ListOfEventVariableSummariesCopier.copyToBuilder(this.eventVariables);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEventVariables(Collection<EventVariableSummary.BuilderImpl> eventVariables) {
            this.eventVariables = ListOfEventVariableSummariesCopier.copyFromBuilder(eventVariables);
        }

        @Override
        @Transient
        public final Builder eventVariables(Collection<EventVariableSummary> eventVariables) {
            this.eventVariables = ListOfEventVariableSummariesCopier.copy(eventVariables);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventVariables(EventVariableSummary ... eventVariables) {
            this.eventVariables(Arrays.asList(eventVariables));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder eventVariables(Consumer<EventVariableSummary.Builder> ... eventVariables) {
            this.eventVariables(Stream.of(eventVariables).map(c -> (EventVariableSummary)((EventVariableSummary.Builder)EventVariableSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EvaluatedRule.Builder> getRules() {
            List<EvaluatedRule.Builder> result = EvaluatedRuleListCopier.copyToBuilder(this.rules);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRules(Collection<EvaluatedRule.BuilderImpl> rules) {
            this.rules = EvaluatedRuleListCopier.copyFromBuilder(rules);
        }

        @Override
        @Transient
        public final Builder rules(Collection<EvaluatedRule> rules) {
            this.rules = EvaluatedRuleListCopier.copy(rules);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rules(EvaluatedRule ... rules) {
            this.rules(Arrays.asList(rules));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder rules(Consumer<EvaluatedRule.Builder> ... rules) {
            this.rules(Stream.of(rules).map(c -> (EvaluatedRule)((EvaluatedRule.Builder)EvaluatedRule.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRuleExecutionMode() {
            return this.ruleExecutionMode;
        }

        public final void setRuleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
        }

        @Override
        @Transient
        public final Builder ruleExecutionMode(String ruleExecutionMode) {
            this.ruleExecutionMode = ruleExecutionMode;
            return this;
        }

        @Override
        @Transient
        public final Builder ruleExecutionMode(RuleExecutionMode ruleExecutionMode) {
            this.ruleExecutionMode(ruleExecutionMode == null ? null : ruleExecutionMode.toString());
            return this;
        }

        public final Collection<String> getOutcomes() {
            if (this.outcomes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.outcomes;
        }

        public final void setOutcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
        }

        @Override
        @Transient
        public final Builder outcomes(Collection<String> outcomes) {
            this.outcomes = ListOfStringsCopier.copy(outcomes);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder outcomes(String ... outcomes) {
            this.outcomes(Arrays.asList(outcomes));
            return this;
        }

        public final List<EvaluatedModelVersion.Builder> getEvaluatedModelVersions() {
            List<EvaluatedModelVersion.Builder> result = ListOfEvaluatedModelVersionsCopier.copyToBuilder(this.evaluatedModelVersions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluatedModelVersions(Collection<EvaluatedModelVersion.BuilderImpl> evaluatedModelVersions) {
            this.evaluatedModelVersions = ListOfEvaluatedModelVersionsCopier.copyFromBuilder(evaluatedModelVersions);
        }

        @Override
        @Transient
        public final Builder evaluatedModelVersions(Collection<EvaluatedModelVersion> evaluatedModelVersions) {
            this.evaluatedModelVersions = ListOfEvaluatedModelVersionsCopier.copy(evaluatedModelVersions);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder evaluatedModelVersions(EvaluatedModelVersion ... evaluatedModelVersions) {
            this.evaluatedModelVersions(Arrays.asList(evaluatedModelVersions));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder evaluatedModelVersions(Consumer<EvaluatedModelVersion.Builder> ... evaluatedModelVersions) {
            this.evaluatedModelVersions(Stream.of(evaluatedModelVersions).map(c -> (EvaluatedModelVersion)((EvaluatedModelVersion.Builder)EvaluatedModelVersion.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<EvaluatedExternalModel.Builder> getEvaluatedExternalModels() {
            List<EvaluatedExternalModel.Builder> result = ListOfEvaluatedExternalModelsCopier.copyToBuilder(this.evaluatedExternalModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluatedExternalModels(Collection<EvaluatedExternalModel.BuilderImpl> evaluatedExternalModels) {
            this.evaluatedExternalModels = ListOfEvaluatedExternalModelsCopier.copyFromBuilder(evaluatedExternalModels);
        }

        @Override
        @Transient
        public final Builder evaluatedExternalModels(Collection<EvaluatedExternalModel> evaluatedExternalModels) {
            this.evaluatedExternalModels = ListOfEvaluatedExternalModelsCopier.copy(evaluatedExternalModels);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder evaluatedExternalModels(EvaluatedExternalModel ... evaluatedExternalModels) {
            this.evaluatedExternalModels(Arrays.asList(evaluatedExternalModels));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder evaluatedExternalModels(Consumer<EvaluatedExternalModel.Builder> ... evaluatedExternalModels) {
            this.evaluatedExternalModels(Stream.of(evaluatedExternalModels).map(c -> (EvaluatedExternalModel)((EvaluatedExternalModel.Builder)EvaluatedExternalModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getPredictionTimestamp() {
            return this.predictionTimestamp;
        }

        public final void setPredictionTimestamp(String predictionTimestamp) {
            this.predictionTimestamp = predictionTimestamp;
        }

        @Override
        @Transient
        public final Builder predictionTimestamp(String predictionTimestamp) {
            this.predictionTimestamp = predictionTimestamp;
            return this;
        }

        @Override
        public GetEventPredictionMetadataResponse build() {
            return new GetEventPredictionMetadataResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEventPredictionMetadataResponse> {
        public Builder eventId(String var1);

        public Builder eventTypeName(String var1);

        public Builder entityId(String var1);

        public Builder entityType(String var1);

        public Builder eventTimestamp(String var1);

        public Builder detectorId(String var1);

        public Builder detectorVersionId(String var1);

        public Builder detectorVersionStatus(String var1);

        public Builder eventVariables(Collection<EventVariableSummary> var1);

        public Builder eventVariables(EventVariableSummary ... var1);

        public Builder eventVariables(Consumer<EventVariableSummary.Builder> ... var1);

        public Builder rules(Collection<EvaluatedRule> var1);

        public Builder rules(EvaluatedRule ... var1);

        public Builder rules(Consumer<EvaluatedRule.Builder> ... var1);

        public Builder ruleExecutionMode(String var1);

        public Builder ruleExecutionMode(RuleExecutionMode var1);

        public Builder outcomes(Collection<String> var1);

        public Builder outcomes(String ... var1);

        public Builder evaluatedModelVersions(Collection<EvaluatedModelVersion> var1);

        public Builder evaluatedModelVersions(EvaluatedModelVersion ... var1);

        public Builder evaluatedModelVersions(Consumer<EvaluatedModelVersion.Builder> ... var1);

        public Builder evaluatedExternalModels(Collection<EvaluatedExternalModel> var1);

        public Builder evaluatedExternalModels(EvaluatedExternalModel ... var1);

        public Builder evaluatedExternalModels(Consumer<EvaluatedExternalModel.Builder> ... var1);

        public Builder predictionTimestamp(String var1);
    }
}

