/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.ExternalModel;
import software.amazon.awssdk.services.frauddetector.model.ExternalModelListCopier;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetExternalModelsResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetExternalModelsResponse> {
    private static final SdkField<List<ExternalModel>> EXTERNAL_MODELS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("externalModels").getter(GetExternalModelsResponse.getter(GetExternalModelsResponse::externalModels)).setter(GetExternalModelsResponse.setter(Builder::externalModels)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalModels").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ExternalModel::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetExternalModelsResponse.getter(GetExternalModelsResponse::nextToken)).setter(GetExternalModelsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTERNAL_MODELS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ExternalModel> externalModels;
    private final String nextToken;

    private GetExternalModelsResponse(BuilderImpl builder) {
        super(builder);
        this.externalModels = builder.externalModels;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasExternalModels() {
        return this.externalModels != null && !(this.externalModels instanceof SdkAutoConstructList);
    }

    public final List<ExternalModel> externalModels() {
        return this.externalModels;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalModels() ? this.externalModels() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetExternalModelsResponse)) {
            return false;
        }
        GetExternalModelsResponse other = (GetExternalModelsResponse)((Object)obj);
        return this.hasExternalModels() == other.hasExternalModels() && Objects.equals(this.externalModels(), other.externalModels()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetExternalModelsResponse").add("ExternalModels", this.hasExternalModels() ? this.externalModels() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "externalModels": {
                return Optional.ofNullable(clazz.cast(this.externalModels()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetExternalModelsResponse, T> g) {
        return obj -> g.apply((GetExternalModelsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<ExternalModel> externalModels = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetExternalModelsResponse model) {
            super(model);
            this.externalModels(model.externalModels);
            this.nextToken(model.nextToken);
        }

        public final List<ExternalModel.Builder> getExternalModels() {
            List<ExternalModel.Builder> result = ExternalModelListCopier.copyToBuilder(this.externalModels);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setExternalModels(Collection<ExternalModel.BuilderImpl> externalModels) {
            this.externalModels = ExternalModelListCopier.copyFromBuilder(externalModels);
        }

        @Override
        @Transient
        public final Builder externalModels(Collection<ExternalModel> externalModels) {
            this.externalModels = ExternalModelListCopier.copy(externalModels);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder externalModels(ExternalModel ... externalModels) {
            this.externalModels(Arrays.asList(externalModels));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder externalModels(Consumer<ExternalModel.Builder> ... externalModels) {
            this.externalModels(Stream.of(externalModels).map(c -> (ExternalModel)((ExternalModel.Builder)ExternalModel.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public GetExternalModelsResponse build() {
            return new GetExternalModelsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetExternalModelsResponse> {
        public Builder externalModels(Collection<ExternalModel> var1);

        public Builder externalModels(ExternalModel ... var1);

        public Builder externalModels(Consumer<ExternalModel.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

