/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.frauddetector.model.BatchPrediction;
import software.amazon.awssdk.services.frauddetector.model.BatchPredictionListCopier;
import software.amazon.awssdk.services.frauddetector.model.FraudDetectorResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetBatchPredictionJobsResponse
extends FraudDetectorResponse
implements ToCopyableBuilder<Builder, GetBatchPredictionJobsResponse> {
    private static final SdkField<List<BatchPrediction>> BATCH_PREDICTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("batchPredictions").getter(GetBatchPredictionJobsResponse.getter(GetBatchPredictionJobsResponse::batchPredictions)).setter(GetBatchPredictionJobsResponse.setter(Builder::batchPredictions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("batchPredictions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(BatchPrediction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(GetBatchPredictionJobsResponse.getter(GetBatchPredictionJobsResponse::nextToken)).setter(GetBatchPredictionJobsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BATCH_PREDICTIONS_FIELD, NEXT_TOKEN_FIELD));
    private final List<BatchPrediction> batchPredictions;
    private final String nextToken;

    private GetBatchPredictionJobsResponse(BuilderImpl builder) {
        super(builder);
        this.batchPredictions = builder.batchPredictions;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasBatchPredictions() {
        return this.batchPredictions != null && !(this.batchPredictions instanceof SdkAutoConstructList);
    }

    public final List<BatchPrediction> batchPredictions() {
        return this.batchPredictions;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBatchPredictions() ? this.batchPredictions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetBatchPredictionJobsResponse)) {
            return false;
        }
        GetBatchPredictionJobsResponse other = (GetBatchPredictionJobsResponse)((Object)obj);
        return this.hasBatchPredictions() == other.hasBatchPredictions() && Objects.equals(this.batchPredictions(), other.batchPredictions()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"GetBatchPredictionJobsResponse").add("BatchPredictions", this.hasBatchPredictions() ? this.batchPredictions() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "batchPredictions": {
                return Optional.ofNullable(clazz.cast(this.batchPredictions()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetBatchPredictionJobsResponse, T> g) {
        return obj -> g.apply((GetBatchPredictionJobsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends FraudDetectorResponse.BuilderImpl
    implements Builder {
        private List<BatchPrediction> batchPredictions = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(GetBatchPredictionJobsResponse model) {
            super(model);
            this.batchPredictions(model.batchPredictions);
            this.nextToken(model.nextToken);
        }

        public final Collection<BatchPrediction.Builder> getBatchPredictions() {
            if (this.batchPredictions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.batchPredictions != null ? (Collection)this.batchPredictions.stream().map(BatchPrediction::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder batchPredictions(Collection<BatchPrediction> batchPredictions) {
            this.batchPredictions = BatchPredictionListCopier.copy(batchPredictions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchPredictions(BatchPrediction ... batchPredictions) {
            this.batchPredictions(Arrays.asList(batchPredictions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder batchPredictions(Consumer<BatchPrediction.Builder> ... batchPredictions) {
            this.batchPredictions(Stream.of(batchPredictions).map(c -> (BatchPrediction)((BatchPrediction.Builder)BatchPrediction.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setBatchPredictions(Collection<BatchPrediction.BuilderImpl> batchPredictions) {
            this.batchPredictions = BatchPredictionListCopier.copyFromBuilder(batchPredictions);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public GetBatchPredictionJobsResponse build() {
            return new GetBatchPredictionJobsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends FraudDetectorResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetBatchPredictionJobsResponse> {
        public Builder batchPredictions(Collection<BatchPrediction> var1);

        public Builder batchPredictions(BatchPrediction ... var1);

        public Builder batchPredictions(Consumer<BatchPrediction.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

