/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TrainingDataSourceEnum {
    EXTERNAL_EVENTS("EXTERNAL_EVENTS"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TrainingDataSourceEnum(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TrainingDataSourceEnum fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TrainingDataSourceEnum.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TrainingDataSourceEnum> knownValues() {
        return Stream.of(TrainingDataSourceEnum.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

