/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.frauddetector.FraudDetectorAsyncClient;
import software.amazon.awssdk.services.frauddetector.model.GetLabelsRequest;
import software.amazon.awssdk.services.frauddetector.model.GetLabelsResponse;

public class GetLabelsPublisher
implements SdkPublisher<GetLabelsResponse> {
    private final FraudDetectorAsyncClient client;
    private final GetLabelsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetLabelsPublisher(FraudDetectorAsyncClient client, GetLabelsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetLabelsPublisher(FraudDetectorAsyncClient client, GetLabelsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetLabelsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetLabelsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class GetLabelsResponseFetcher
    implements AsyncPageFetcher<GetLabelsResponse> {
        private GetLabelsResponseFetcher() {
        }

        public boolean hasNextPage(GetLabelsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<GetLabelsResponse> nextPage(GetLabelsResponse previousPage) {
            if (previousPage == null) {
                return GetLabelsPublisher.this.client.getLabels(GetLabelsPublisher.this.firstRequest);
            }
            return GetLabelsPublisher.this.client.getLabels((GetLabelsRequest)((Object)GetLabelsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

