/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.frauddetector.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.frauddetector.model.DataValidationMetrics;
import software.amazon.awssdk.services.frauddetector.model.TrainingMetrics;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrainingResult
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrainingResult> {
    private static final SdkField<DataValidationMetrics> DATA_VALIDATION_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataValidationMetrics").getter(TrainingResult.getter(TrainingResult::dataValidationMetrics)).setter(TrainingResult.setter(Builder::dataValidationMetrics)).constructor(DataValidationMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataValidationMetrics").build()}).build();
    private static final SdkField<TrainingMetrics> TRAINING_METRICS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("trainingMetrics").getter(TrainingResult.getter(TrainingResult::trainingMetrics)).setter(TrainingResult.setter(Builder::trainingMetrics)).constructor(TrainingMetrics::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("trainingMetrics").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_VALIDATION_METRICS_FIELD, TRAINING_METRICS_FIELD));
    private static final long serialVersionUID = 1L;
    private final DataValidationMetrics dataValidationMetrics;
    private final TrainingMetrics trainingMetrics;

    private TrainingResult(BuilderImpl builder) {
        this.dataValidationMetrics = builder.dataValidationMetrics;
        this.trainingMetrics = builder.trainingMetrics;
    }

    public DataValidationMetrics dataValidationMetrics() {
        return this.dataValidationMetrics;
    }

    public TrainingMetrics trainingMetrics() {
        return this.trainingMetrics;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataValidationMetrics());
        hashCode = 31 * hashCode + Objects.hashCode(this.trainingMetrics());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrainingResult)) {
            return false;
        }
        TrainingResult other = (TrainingResult)obj;
        return Objects.equals(this.dataValidationMetrics(), other.dataValidationMetrics()) && Objects.equals(this.trainingMetrics(), other.trainingMetrics());
    }

    public String toString() {
        return ToString.builder((String)"TrainingResult").add("DataValidationMetrics", (Object)this.dataValidationMetrics()).add("TrainingMetrics", (Object)this.trainingMetrics()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataValidationMetrics": {
                return Optional.ofNullable(clazz.cast(this.dataValidationMetrics()));
            }
            case "trainingMetrics": {
                return Optional.ofNullable(clazz.cast(this.trainingMetrics()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TrainingResult, T> g) {
        return obj -> g.apply((TrainingResult)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private DataValidationMetrics dataValidationMetrics;
        private TrainingMetrics trainingMetrics;

        private BuilderImpl() {
        }

        private BuilderImpl(TrainingResult model) {
            this.dataValidationMetrics(model.dataValidationMetrics);
            this.trainingMetrics(model.trainingMetrics);
        }

        public final DataValidationMetrics.Builder getDataValidationMetrics() {
            return this.dataValidationMetrics != null ? this.dataValidationMetrics.toBuilder() : null;
        }

        @Override
        public final Builder dataValidationMetrics(DataValidationMetrics dataValidationMetrics) {
            this.dataValidationMetrics = dataValidationMetrics;
            return this;
        }

        public final void setDataValidationMetrics(DataValidationMetrics.BuilderImpl dataValidationMetrics) {
            this.dataValidationMetrics = dataValidationMetrics != null ? dataValidationMetrics.build() : null;
        }

        public final TrainingMetrics.Builder getTrainingMetrics() {
            return this.trainingMetrics != null ? this.trainingMetrics.toBuilder() : null;
        }

        @Override
        public final Builder trainingMetrics(TrainingMetrics trainingMetrics) {
            this.trainingMetrics = trainingMetrics;
            return this;
        }

        public final void setTrainingMetrics(TrainingMetrics.BuilderImpl trainingMetrics) {
            this.trainingMetrics = trainingMetrics != null ? trainingMetrics.build() : null;
        }

        public TrainingResult build() {
            return new TrainingResult(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrainingResult> {
        public Builder dataValidationMetrics(DataValidationMetrics var1);

        default public Builder dataValidationMetrics(Consumer<DataValidationMetrics.Builder> dataValidationMetrics) {
            return this.dataValidationMetrics((DataValidationMetrics)((DataValidationMetrics.Builder)DataValidationMetrics.builder().applyMutation(dataValidationMetrics)).build());
        }

        public Builder trainingMetrics(TrainingMetrics var1);

        default public Builder trainingMetrics(Consumer<TrainingMetrics.Builder> trainingMetrics) {
            return this.trainingMetrics((TrainingMetrics)((TrainingMetrics.Builder)TrainingMetrics.builder().applyMutation(trainingMetrics)).build());
        }
    }
}

